/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.icons.AllIcons;
import com.intellij.java.JavaBundle;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Iconable;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.extractMethod.ExtractMethodHandler;
import com.intellij.refactoring.extractMethod.ExtractMethodProcessor;
import com.intellij.refactoring.extractMethod.PrepareFailedException;
import com.intellij.util.IncorrectOperationException;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExtractMethodIntentionAction
implements IntentionAction,
Iconable {
    @NotNull
    public String getText() {
        return JavaBundle.message((String)"intention.extract.method.text", (Object[])new Object[0]);
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (file instanceof PsiCodeFragment) {
            return false;
        }
        SelectionModel model = editor.getSelectionModel();
        if (!model.hasSelection()) {
            return false;
        }
        PsiElement[] elements = ExtractMethodHandler.getElements(project, editor, file);
        if (elements == null || elements.length == 0) {
            return false;
        }
        ExtractMethodProcessor processor2 = ExtractMethodHandler.getProcessor(project, elements, file, false);
        if (processor2 == null) {
            return false;
        }
        try {
            return processor2.prepare(null);
        }
        catch (PrepareFailedException e) {
            return false;
        }
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        new ExtractMethodHandler().invoke(project, editor, file, null);
    }

    public boolean startInWriteAction() {
        return false;
    }

    @Nullable
    public PsiElement getElementToMakeWritable(@NotNull PsiFile currentFile) {
        return currentFile;
    }

    public Icon getIcon(int flags) {
        return AllIcons.Actions.RefactoringBulb;
    }
}

