/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.codeInsight.intention.impl.SplitConditionUtil;
import com.intellij.java.JavaBundle;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiExpressionTrimRenderer;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExtractIfConditionAction
extends PsiElementBaseIntentionAction {
    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        PsiIfStatement ifStatement = (PsiIfStatement)PsiTreeUtil.getParentOfType((PsiElement)element, PsiIfStatement.class);
        if (ifStatement == null || ifStatement.getCondition() == null) {
            return false;
        }
        PsiExpression condition2 = ifStatement.getCondition();
        if (!(condition2 instanceof PsiPolyadicExpression)) {
            return false;
        }
        PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)condition2;
        PsiType expressionType = polyadicExpression.getType();
        if (expressionType == null || !PsiType.BOOLEAN.isAssignableFrom(expressionType)) {
            return false;
        }
        IElementType operation = polyadicExpression.getOperationTokenType();
        if (operation != JavaTokenType.OROR && operation != JavaTokenType.ANDAND) {
            return false;
        }
        PsiExpression operand2 = ExtractIfConditionAction.findOperand(element, polyadicExpression);
        if (operand2 == null) {
            return false;
        }
        this.setText(JavaBundle.message((String)"intention.extract.if.condition.text", (Object[])new Object[]{PsiExpressionTrimRenderer.render((PsiExpression)operand2)}));
        return true;
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        PsiIfStatement ifStatement = (PsiIfStatement)PsiTreeUtil.getParentOfType((PsiElement)element, PsiIfStatement.class);
        if (ifStatement == null) {
            return;
        }
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
        CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)project);
        CommentTracker tracker = new CommentTracker();
        PsiStatement newIfStatement = ExtractIfConditionAction.create(factory, ifStatement, element, tracker);
        if (newIfStatement == null) {
            return;
        }
        codeStyleManager.reformat(tracker.replaceAndRestoreComments((PsiElement)ifStatement, (PsiElement)newIfStatement));
    }

    @Nullable
    private static PsiStatement create(@NotNull PsiElementFactory factory, @NotNull PsiIfStatement ifStatement, @NotNull PsiElement element, CommentTracker tracker) {
        PsiExpression condition2 = ifStatement.getCondition();
        if (!(condition2 instanceof PsiPolyadicExpression)) {
            return null;
        }
        PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)condition2;
        PsiExpression operand2 = ExtractIfConditionAction.findOperand(element, polyadicExpression);
        if (operand2 == null) {
            return null;
        }
        PsiExpression leave = ExtractIfConditionAction.removeOperand(factory, polyadicExpression, operand2, tracker);
        return SplitConditionUtil.create(factory, ifStatement, operand2, leave, polyadicExpression.getOperationTokenType(), tracker);
    }

    @NotNull
    private static PsiExpression removeOperand(@NotNull PsiElementFactory factory, @NotNull PsiPolyadicExpression expression2, @NotNull PsiExpression operand2, CommentTracker tracker) {
        StringBuilder sb = new StringBuilder();
        for (PsiExpression e : expression2.getOperands()) {
            if (e == operand2) continue;
            PsiJavaToken token = expression2.getTokenBeforeOperand(e);
            if (token != null && sb.length() != 0) {
                sb.append(token.getText()).append(" ");
            }
            tracker.markUnchanged((PsiElement)ObjectUtils.notNull((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)e), (Object)e));
            sb.append(e.getText());
        }
        return factory.createExpressionFromText(sb.toString(), (PsiElement)expression2);
    }

    @Nullable
    private static PsiExpression findOperand(@NotNull PsiElement e, @NotNull PsiPolyadicExpression expression2) {
        TextRange elementTextRange = e.getTextRange();
        for (PsiExpression operand2 : expression2.getOperands()) {
            TextRange operandTextRange = operand2.getTextRange();
            if (operandTextRange == null || !operandTextRange.contains(elementTextRange)) continue;
            return operand2;
        }
        return null;
    }

    @NotNull
    public String getFamilyName() {
        return JavaBundle.message((String)"intention.extract.if.condition.family", (Object[])new Object[0]);
    }
}

