/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.java.JavaBundle;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class ConvertAbsolutePathToRelativeIntentionAction
extends BaseIntentionAction {
    protected boolean isConvertToRelative() {
        return true;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        FileReference fileReference;
        int offset = editor.getCaretModel().getOffset();
        PsiElement element = file.findElementAt(offset);
        if (element == null || element instanceof PsiWhiteSpace) {
            return false;
        }
        PsiReference reference = file.findReferenceAt(offset);
        FileReference fileReference2 = fileReference = reference == null ? null : FileReference.findFileReference((PsiReference)reference);
        if (fileReference != null) {
            FileReferenceSet set = fileReference.getFileReferenceSet();
            FileReference lastReference = set.getLastReference();
            return set.couldBeConvertedTo(this.isConvertToRelative()) && lastReference != null && (!this.isConvertToRelative() && !set.isAbsolutePathReference() || this.isConvertToRelative() && set.isAbsolutePathReference()) && lastReference.resolve() != null;
        }
        return false;
    }

    @NotNull
    public String getFamilyName() {
        return JavaBundle.message((String)"intention.family.convert.0.path.to.1", (Object[])new Object[]{this.isConvertToRelative() ? "absolute" : "relative", this.isConvertToRelative() ? "relative" : "absolute"});
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        FileReference lastReference;
        FileReference fileReference;
        PsiReference reference = file.findReferenceAt(editor.getCaretModel().getOffset());
        FileReference fileReference2 = fileReference = reference == null ? null : FileReference.findFileReference((PsiReference)reference);
        if (fileReference != null && (lastReference = fileReference.getFileReferenceSet().getLastReference()) != null) {
            lastReference.bindToElement((PsiElement)lastReference.resolve(), !this.isConvertToRelative());
        }
    }

    @NotNull
    public String getText() {
        return JavaBundle.message((String)"intention.text.convert.path.to.0", (Object[])new Object[]{this.isConvertToRelative() ? "relative" : "absolute"});
    }
}

