/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.generation.ClassMember;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.codeInsight.intention.impl.FieldFromParameterUtils;
import com.intellij.codeInsight.intention.impl.ParameterClassMember;
import com.intellij.ide.util.MemberChooser;
import com.intellij.java.JavaBundle;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.ex.IdeDocumentHistory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleSettings;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BindFieldsFromParametersAction
extends BaseIntentionAction
implements HighPriorityAction {
    private static final Logger LOG = Logger.getInstance(BindFieldsFromParametersAction.class);
    private static final Key<Map<SmartPsiElementPointer<PsiParameter>, Boolean>> PARAMS = Key.create((String)"FIELDS_FROM_PARAMS");
    private static final Object LOCK = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        PsiParameter psiParameter = FieldFromParameterUtils.findParameterAtCursor(file, editor);
        PsiMethod method = BindFieldsFromParametersAction.findMethod(psiParameter, editor, file);
        if (method == null) {
            return false;
        }
        List<PsiParameter> parameters2 = BindFieldsFromParametersAction.getAvailableParameters(method);
        Object object = LOCK;
        synchronized (object) {
            Collection<SmartPsiElementPointer<PsiParameter>> params = BindFieldsFromParametersAction.getUnboundedParams(method);
            params.clear();
            for (PsiParameter parameter2 : parameters2) {
                params.add((SmartPsiElementPointer<PsiParameter>)SmartPointerManager.getInstance((Project)project).createSmartPsiElementPointer((PsiElement)parameter2));
            }
            if (params.size() == 1 && psiParameter != null) {
                return false;
            }
            Iterator<SmartPsiElementPointer<PsiParameter>> iterator = params.iterator();
            if (!iterator.hasNext()) {
                return false;
            }
            if (psiParameter == null) {
                psiParameter = (PsiParameter)iterator.next().getElement();
                LOG.assertTrue(psiParameter != null);
            }
            this.setText(JavaBundle.message((String)"intention.bind.fields.from.parameters.text", (Object[])new Object[]{method.isConstructor() ? "constructor" : "method"}));
        }
        return BindFieldsFromParametersAction.isAvailable(psiParameter);
    }

    @Nullable
    private static PsiMethod findMethod(@Nullable PsiParameter parameter2, @NotNull Editor editor, @NotNull PsiFile file) {
        if (parameter2 == null) {
            PsiElement parent;
            PsiElement elementAt = file.findElementAt(editor.getCaretModel().getOffset());
            if (elementAt instanceof PsiIdentifier && (parent = elementAt.getParent()) instanceof PsiMethod) {
                return (PsiMethod)parent;
            }
        } else {
            PsiElement declarationScope = parameter2.getDeclarationScope();
            if (declarationScope instanceof PsiMethod) {
                return (PsiMethod)declarationScope;
            }
        }
        return null;
    }

    @NotNull
    private static List<PsiParameter> getAvailableParameters(@NotNull PsiMethod method) {
        ArrayList<PsiParameter> parameters2 = new ArrayList<PsiParameter>();
        for (PsiParameter parameter2 : method.getParameterList().getParameters()) {
            if (!BindFieldsFromParametersAction.isAvailable(parameter2)) continue;
            parameters2.add(parameter2);
        }
        return parameters2;
    }

    private static boolean isAvailable(@NotNull PsiParameter psiParameter) {
        PsiClass targetClass;
        PsiType type2 = FieldFromParameterUtils.getSubstitutedType(psiParameter);
        return FieldFromParameterUtils.isAvailable(psiParameter, type2, targetClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)psiParameter, PsiClass.class)) && psiParameter.getLanguage().isKindOf((Language)JavaLanguage.INSTANCE);
    }

    @NotNull
    private static Collection<SmartPsiElementPointer<PsiParameter>> getUnboundedParams(PsiMethod psiMethod) {
        Map params = (Map)psiMethod.getUserData(PARAMS);
        if (params == null) {
            params = ContainerUtil.createConcurrentWeakMap();
            psiMethod.putUserData(PARAMS, (Object)params);
        }
        final Map finalParams = params;
        return new AbstractCollection<SmartPsiElementPointer<PsiParameter>>(){

            @Override
            public boolean add(SmartPsiElementPointer<PsiParameter> psiVariable) {
                return finalParams.put(psiVariable, Boolean.TRUE) == null;
            }

            @Override
            public Iterator<SmartPsiElementPointer<PsiParameter>> iterator() {
                return finalParams.keySet().iterator();
            }

            @Override
            public int size() {
                return finalParams.size();
            }

            @Override
            public void clear() {
                finalParams.clear();
            }
        };
    }

    @NotNull
    public String getFamilyName() {
        return JavaBundle.message((String)"intention.bind.fields.from.parameters.family", (Object[])new Object[0]);
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) {
        BindFieldsFromParametersAction.invoke(project, editor, file, !ApplicationManager.getApplication().isUnitTestMode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void invoke(Project project, Editor editor, PsiFile file, boolean isInteractive) {
        PsiParameter psiParameter = FieldFromParameterUtils.findParameterAtCursor(file, editor);
        if (!FileModificationService.getInstance().prepareFileForWrite(file)) {
            return;
        }
        PsiMethod method = psiParameter != null ? (PsiMethod)psiParameter.getDeclarationScope() : (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)file.findElementAt(editor.getCaretModel().getOffset()), PsiMethod.class);
        LOG.assertTrue(method != null);
        HashSet<String> usedNames = new HashSet<String>();
        Iterable<PsiParameter> parameters2 = BindFieldsFromParametersAction.selectParameters(project, method, BindFieldsFromParametersAction.copyUnboundedParamsAndClearOriginal(method), isInteractive);
        MultiMap types = new MultiMap();
        for (PsiParameter parameter2 : parameters2) {
            types.putValue((Object)parameter2.getType(), (Object)parameter2);
        }
        JavaCodeStyleSettings settings = JavaCodeStyleSettings.getInstance(file);
        boolean preferLongerNames = settings.PREFER_LONGER_NAMES;
        for (PsiParameter selected : parameters2) {
            try {
                settings.PREFER_LONGER_NAMES = preferLongerNames || types.get((Object)selected.getType()).size() > 1;
                BindFieldsFromParametersAction.processParameter(project, selected, usedNames);
            }
            finally {
                settings.PREFER_LONGER_NAMES = preferLongerNames;
            }
        }
    }

    @NotNull
    private static Iterable<PsiParameter> selectParameters(@NotNull Project project, @NotNull PsiMethod method, @NotNull Collection<? extends SmartPsiElementPointer<PsiParameter>> unboundedParams, boolean isInteractive) {
        if (unboundedParams.size() < 2 || !isInteractive) {
            return BindFieldsFromParametersAction.revealPointers(unboundedParams);
        }
        ParameterClassMember[] members = BindFieldsFromParametersAction.sortByParameterIndex(BindFieldsFromParametersAction.toClassMemberArray(unboundedParams), method);
        MemberChooser<ParameterClassMember> chooser = BindFieldsFromParametersAction.showChooser(project, method, members);
        List selectedElements = chooser.getSelectedElements();
        if (chooser.getExitCode() != 0 || selectedElements == null) {
            return Collections.emptyList();
        }
        return BindFieldsFromParametersAction.revealParameterClassMembers(selectedElements);
    }

    @NotNull
    private static MemberChooser<ParameterClassMember> showChooser(@NotNull Project project, @NotNull PsiMethod method, ParameterClassMember @NotNull [] members) {
        MemberChooser chooser = new MemberChooser((ClassMember[])members, false, true, project);
        chooser.selectElements((ClassMember[])BindFieldsFromParametersAction.getInitialSelection(method, members));
        chooser.setTitle(JavaBundle.message((String)"dialog.title.choose.0.parameters", (Object[])new Object[]{method.isConstructor() ? "Constructor" : "Method"}));
        chooser.show();
        return chooser;
    }

    private static ParameterClassMember[] getInitialSelection(@NotNull PsiMethod method, ParameterClassMember @NotNull [] members) {
        PsiMethod calledMethod;
        PsiExpression expression2;
        HashSet resolvedInSuperOrThis = new HashSet();
        PsiCodeBlock body2 = method.getBody();
        LOG.assertTrue(body2 != null);
        PsiStatement[] statements = body2.getStatements();
        if (statements.length > 0 && statements[0] instanceof PsiExpressionStatement && (expression2 = ((PsiExpressionStatement)statements[0]).getExpression()) instanceof PsiMethodCallExpression && (calledMethod = ((PsiMethodCallExpression)expression2).resolveMethod()) != null && calledMethod.isConstructor()) {
            for (PsiExpression arg : ((PsiMethodCallExpression)expression2).getArgumentList().getExpressions()) {
                if (!(arg instanceof PsiReferenceExpression)) continue;
                ContainerUtil.addIfNotNull(resolvedInSuperOrThis, (Object)((PsiReferenceExpression)arg).resolve());
            }
        }
        return ContainerUtil.findAll((Object[])members, member -> !resolvedInSuperOrThis.contains(member.getParameter())).toArray(ParameterClassMember.EMPTY_ARRAY);
    }

    private static ParameterClassMember @NotNull [] sortByParameterIndex(ParameterClassMember @NotNull [] members, @NotNull PsiMethod method) {
        PsiParameterList parameterList = method.getParameterList();
        Arrays.sort(members, Comparator.comparingInt(o -> parameterList.getParameterIndex(o.getParameter())));
        return members;
    }

    @NotNull
    private static <T extends PsiElement> List<T> revealPointers(@NotNull Iterable<? extends SmartPsiElementPointer<T>> pointers) {
        ArrayList<PsiElement> result = new ArrayList<PsiElement>();
        for (SmartPsiElementPointer<T> pointer : pointers) {
            result.add(pointer.getElement());
        }
        return result;
    }

    @NotNull
    private static List<PsiParameter> revealParameterClassMembers(@NotNull Iterable<? extends ParameterClassMember> parameterClassMembers) {
        ArrayList<PsiParameter> result = new ArrayList<PsiParameter>();
        for (ParameterClassMember parameterClassMember : parameterClassMembers) {
            result.add(parameterClassMember.getParameter());
        }
        return result;
    }

    private static ParameterClassMember @NotNull [] toClassMemberArray(@NotNull Collection<? extends SmartPsiElementPointer<PsiParameter>> unboundedParams) {
        ParameterClassMember[] result = new ParameterClassMember[unboundedParams.size()];
        int i = 0;
        for (SmartPsiElementPointer<PsiParameter> smartPsiElementPointer : unboundedParams) {
            result[i++] = new ParameterClassMember((PsiParameter)smartPsiElementPointer.getElement());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private static Collection<SmartPsiElementPointer<PsiParameter>> copyUnboundedParamsAndClearOriginal(@NotNull PsiMethod method) {
        Object object = LOCK;
        synchronized (object) {
            Collection<SmartPsiElementPointer<PsiParameter>> unboundedParams = BindFieldsFromParametersAction.getUnboundedParams(method);
            ArrayList<SmartPsiElementPointer<PsiParameter>> result = new ArrayList<SmartPsiElementPointer<PsiParameter>>(unboundedParams);
            unboundedParams.clear();
            return result;
        }
    }

    private static void processParameter(@NotNull Project project, @NotNull PsiParameter parameter2, @NotNull Set<String> usedNames) {
        IdeDocumentHistory.getInstance((Project)project).includeCurrentPlaceAsChangePlace();
        PsiType type2 = FieldFromParameterUtils.getSubstitutedType(parameter2);
        JavaCodeStyleManager styleManager = JavaCodeStyleManager.getInstance((Project)project);
        String parameterName = parameter2.getName();
        String propertyName = styleManager.variableNameToPropertyName(parameterName, VariableKind.PARAMETER);
        PsiClass targetClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)parameter2, PsiClass.class);
        PsiElement declarationScope = parameter2.getDeclarationScope();
        if (!(declarationScope instanceof PsiMethod)) {
            return;
        }
        PsiMethod method = (PsiMethod)declarationScope;
        boolean isMethodStatic = method.hasModifierProperty("static");
        VariableKind kind2 = isMethodStatic ? VariableKind.STATIC_FIELD : VariableKind.FIELD;
        SuggestedNameInfo suggestedNameInfo = styleManager.suggestVariableName(kind2, propertyName, null, type2);
        String[] names2 = suggestedNameInfo.names;
        boolean isFinal = !isMethodStatic && method.isConstructor();
        String name2 = names2[0];
        if (targetClass != null) {
            for (String curName : names2) {
                PsiField fieldByName;
                if (usedNames.contains(curName) || (fieldByName = targetClass.findFieldByName(curName, false)) == null || method.isConstructor() && BindFieldsFromParametersAction.isFieldAssigned(fieldByName, method) || !fieldByName.getType().isAssignableFrom(parameter2.getType())) continue;
                name2 = curName;
                break;
            }
        }
        if (usedNames.contains(name2)) {
            for (String curName : names2) {
                if (usedNames.contains(curName)) continue;
                name2 = curName;
                break;
            }
        }
        String fieldName = usedNames.add(name2) ? name2 : JavaCodeStyleManager.getInstance((Project)project).suggestUniqueVariableName(name2, (PsiElement)parameter2, true);
        ApplicationManager.getApplication().runWriteAction(() -> {
            try {
                FieldFromParameterUtils.createFieldAndAddAssignment(project, targetClass, method, parameter2, type2, fieldName, isMethodStatic, isFinal);
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        });
    }

    private static boolean isFieldAssigned(PsiField field, PsiMethod method) {
        for (PsiReference reference : ReferencesSearch.search((PsiElement)field, (SearchScope)new LocalSearchScope((PsiElement)method))) {
            if (!(reference instanceof PsiReferenceExpression) || !PsiUtil.isOnAssignmentLeftHand((PsiExpression)((PsiReferenceExpression)reference))) continue;
            return true;
        }
        return false;
    }

    public boolean startInWriteAction() {
        return false;
    }
}

