/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.highlighting;

import com.intellij.codeInsight.highlighting.ReadWriteAccessDetector;
import com.intellij.psi.ImplicitVariable;
import com.intellij.psi.PsiAnnotationMethod;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.psi.util.PsiUtil;
import org.jetbrains.annotations.NotNull;

public class JavaReadWriteAccessDetector
extends ReadWriteAccessDetector {
    public boolean isReadWriteAccessible(@NotNull PsiElement element) {
        return element instanceof PsiVariable && !(element instanceof ImplicitVariable) || element instanceof PsiClass || element instanceof PsiAnnotationMethod && !(element instanceof PsiCompiledElement);
    }

    public boolean isDeclarationWriteAccess(@NotNull PsiElement element) {
        if (element instanceof PsiVariable && ((PsiVariable)element).getInitializer() != null) {
            return true;
        }
        return element instanceof PsiParameter && ((PsiParameter)element).getDeclarationScope() instanceof PsiForeachStatement;
    }

    @NotNull
    public ReadWriteAccessDetector.Access getReferenceAccess(@NotNull PsiElement referencedElement, @NotNull PsiReference reference) {
        return this.getExpressionAccess(reference.getElement());
    }

    @NotNull
    public ReadWriteAccessDetector.Access getExpressionAccess(@NotNull PsiElement expression2) {
        PsiElement actualReferee;
        if (!(expression2 instanceof PsiExpression)) {
            if (expression2 instanceof PsiNameValuePair || expression2 instanceof PsiIdentifier) {
                return ReadWriteAccessDetector.Access.Write;
            }
            return ReadWriteAccessDetector.Access.Read;
        }
        PsiExpression expr2 = (PsiExpression)expression2;
        boolean readAccess = PsiUtil.isAccessedForReading((PsiExpression)expr2);
        boolean writeAccess = PsiUtil.isAccessedForWriting((PsiExpression)expr2);
        if (!writeAccess && expr2 instanceof PsiReferenceExpression && (actualReferee = ((PsiReferenceExpression)expr2).resolve()) instanceof PsiMethod && PropertyUtilBase.isSimplePropertySetter((PsiMethod)((PsiMethod)actualReferee))) {
            writeAccess = true;
            readAccess = false;
        }
        if (writeAccess && readAccess) {
            return ReadWriteAccessDetector.Access.ReadWrite;
        }
        return writeAccess ? ReadWriteAccessDetector.Access.Write : ReadWriteAccessDetector.Access.Read;
    }
}

