/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.highlighting;

import com.intellij.codeInsight.highlighting.ChooseClassAndDoHighlightRunnable;
import com.intellij.codeInsight.highlighting.HighlightUsagesHandler;
import com.intellij.codeInsight.highlighting.HighlightUsagesHandlerBase;
import com.intellij.java.JavaBundle;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.HierarchicalMethodSignature;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.util.Consumer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HighlightOverridingMethodsHandler
extends HighlightUsagesHandlerBase<PsiClass> {
    private final PsiElement myTarget;
    private final PsiClass myClass;

    public HighlightOverridingMethodsHandler(Editor editor, PsiFile file, PsiElement target, PsiClass psiClass) {
        super(editor, file);
        this.myTarget = target;
        this.myClass = psiClass;
    }

    @NotNull
    public List<PsiClass> getTargets() {
        PsiReferenceList list;
        PsiReferenceList psiReferenceList = list = "extends".equals(this.myTarget.getText()) ? this.myClass.getExtendsList() : this.myClass.getImplementsList();
        if (list == null) {
            return Collections.emptyList();
        }
        PsiClassType[] classTypes = list.getReferencedTypes();
        return ChooseClassAndDoHighlightRunnable.resolveClasses(classTypes);
    }

    protected void selectTargets(@NotNull List<? extends PsiClass> targets, final @NotNull Consumer<? super List<? extends PsiClass>> selectionConsumer) {
        new ChooseClassAndDoHighlightRunnable(targets, this.myEditor, JavaBundle.message((String)"highlight.overridden.classes.chooser.title", (Object[])new Object[0])){

            protected void selected(PsiClass ... classes2) {
                selectionConsumer.consume(Arrays.asList(classes2));
            }
        }.run();
    }

    public void computeUsages(@NotNull List<? extends PsiClass> classes2) {
        for (PsiMethod method : this.myClass.getMethods()) {
            List superSignatures = method.getHierarchicalMethodSignature().getSuperSignatures();
            block1: for (HierarchicalMethodSignature superSignature : superSignatures) {
                PsiClass containingClass = superSignature.getMethod().getContainingClass();
                if (containingClass == null) continue;
                for (PsiClass psiClass : classes2) {
                    PsiIdentifier identifier;
                    if (!InheritanceUtil.isInheritorOrSelf((PsiClass)psiClass, (PsiClass)containingClass, (boolean)true) || (identifier = method.getNameIdentifier()) == null) continue;
                    this.addOccurrence((PsiElement)identifier);
                    continue block1;
                }
            }
        }
        if (this.myReadUsages.isEmpty()) {
            String name2;
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                return;
            }
            if (classes2.size() == 1) {
                ItemPresentation presentation = classes2.get(0).getPresentation();
                String name3 = presentation != null ? presentation.getPresentableText() : "";
            } else {
                name2 = "";
            }
            this.myHintText = JavaBundle.message((String)"no.methods.overriding.0.are.found", (Object[])new Object[]{classes2.size(), name2});
        } else {
            this.addOccurrence(this.myTarget);
            int methodCount = this.myReadUsages.size() - 1;
            this.myStatusText = JavaBundle.message((String)"status.bar.overridden.methods.highlighted.message", (Object[])new Object[]{methodCount, HighlightUsagesHandler.getShortcutText()});
        }
    }

    @Nullable
    public String getFeatureId() {
        return "codeassists.highlight.implements";
    }
}

