/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.generation;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.java.generate.exception.TemplateResourceException;
import org.jetbrains.java.generate.template.TemplateResource;
import org.jetbrains.java.generate.template.TemplatesManager;

@State(name="SetterTemplates", storages={@Storage(value="setterTemplates.xml")})
public final class SetterTemplatesManager
extends TemplatesManager {
    private static final String DEFAULT = "defaultSetter.vm";
    private static final String BUILDER = "builderSetter.vm";

    public static TemplatesManager getInstance() {
        return (TemplatesManager)ServiceManager.getService(SetterTemplatesManager.class);
    }

    @Override
    @NotNull
    public List<TemplateResource> getDefaultTemplates() {
        try {
            return Arrays.asList(new TemplateResource("IntelliJ Default", SetterTemplatesManager.readFile(DEFAULT), true), new TemplateResource("Builder", SetterTemplatesManager.readFile(BUILDER), true));
        }
        catch (IOException e) {
            throw new TemplateResourceException("Error loading default templates", e);
        }
    }

    protected static String readFile(String resource) throws IOException {
        return SetterTemplatesManager.readFile(resource, SetterTemplatesManager.class);
    }
}

