/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.generation;

import com.intellij.codeInsight.MemberImplementorExplorer;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NullableLazyValue;
import com.intellij.openapi.util.VolatileNullableLazyValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.HierarchicalMethodSignature;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureBackedByPsiMethod;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;

public class OverrideImplementExploreUtil {
    private static final NullableLazyValue<MemberImplementorExplorersProvider> ourExplorersProvider = new VolatileNullableLazyValue<MemberImplementorExplorersProvider>(){

        protected MemberImplementorExplorersProvider compute() {
            return (MemberImplementorExplorersProvider)ServiceManager.getService(MemberImplementorExplorersProvider.class);
        }
    };

    @NotNull
    public static Collection<CandidateInfo> getMethodsToOverrideImplement(@NotNull PsiClass aClass, boolean toImplement) {
        return OverrideImplementExploreUtil.getMapToOverrideImplement(aClass, toImplement).values();
    }

    @NotNull
    public static Collection<MethodSignature> getMethodSignaturesToImplement(@NotNull PsiClass aClass) {
        return OverrideImplementExploreUtil.getMapToOverrideImplement(aClass, true).keySet();
    }

    @NotNull
    public static Collection<MethodSignature> getMethodSignaturesToOverride(@NotNull PsiClass aClass) {
        if (aClass.isAnnotationType()) {
            return Collections.emptySet();
        }
        return OverrideImplementExploreUtil.getMapToOverrideImplement(aClass, false).keySet();
    }

    @NotNull
    public static Map<MethodSignature, CandidateInfo> getMapToOverrideImplement(@NotNull PsiClass aClass, boolean toImplement) {
        return OverrideImplementExploreUtil.getMapToOverrideImplement(aClass, toImplement, true);
    }

    @NotNull
    public static Map<MethodSignature, CandidateInfo> getMapToOverrideImplement(@NotNull PsiClass aClass, boolean toImplement, boolean skipImplemented) {
        if (aClass.isAnnotationType() || aClass instanceof PsiTypeParameter) {
            return Collections.emptyMap();
        }
        PsiUtilCore.ensureValid((PsiElement)aClass);
        Collection allMethodSigs = aClass.getVisibleSignatures();
        PsiResolveHelper resolveHelper = JavaPsiFacade.getInstance((Project)aClass.getProject()).getResolveHelper();
        LinkedHashMap<MethodSignature, PsiMethod> abstracts = new LinkedHashMap<MethodSignature, PsiMethod>();
        LinkedHashMap<MethodSignature, PsiMethod> finals = new LinkedHashMap<MethodSignature, PsiMethod>();
        LinkedHashMap<MethodSignature, PsiMethod> concretes = new LinkedHashMap<MethodSignature, PsiMethod>();
        for (HierarchicalMethodSignature signature : allMethodSigs) {
            PsiClass hisClass;
            PsiMethod method = signature.getMethod();
            PsiUtilCore.ensureValid((PsiElement)method);
            if (method.hasModifierProperty("static") || !resolveHelper.isAccessible((PsiMember)method, (PsiElement)aClass, aClass) || method.isConstructor() && method.hasModifierProperty("abstract")) continue;
            for (HierarchicalMethodSignature superMethodSignature : signature.getSuperSignatures()) {
                PsiMethod superMethod = superMethodSignature.getMethod();
                if (PsiUtil.getAccessLevel((PsiModifierList)superMethod.getModifierList()) <= PsiUtil.getAccessLevel((PsiModifierList)method.getModifierList())) continue;
                method = superMethod;
                break;
            }
            if ((hisClass = method.getContainingClass()) == null || method.isConstructor() && (!aClass.isInheritor(hisClass, false) || aClass instanceof PsiAnonymousClass || aClass.isEnum()) || skipImplemented && MethodSignatureUtil.findMethodBySignature((PsiClass)aClass, (MethodSignature)signature, (boolean)false) != null) continue;
            if (method.hasModifierProperty("final")) {
                finals.put((MethodSignature)signature, method);
                continue;
            }
            LinkedHashMap<MethodSignature, PsiMethod> map2 = hisClass.isInterface() || method.hasModifierProperty("abstract") ? abstracts : concretes;
            OverrideImplementExploreUtil.fillMap(signature, method, map2);
            if (!OverrideImplementExploreUtil.shouldAppearInOverrideList(aClass, method)) continue;
            OverrideImplementExploreUtil.fillMap(signature, method, concretes);
        }
        TreeMap<MethodSignature, CandidateInfo> result = new TreeMap<MethodSignature, CandidateInfo>(new MethodSignatureComparator());
        if (toImplement || aClass.isInterface()) {
            OverrideImplementExploreUtil.collectMethodsToImplement(aClass, abstracts, finals, concretes, result);
        } else {
            for (Map.Entry entry : concretes.entrySet()) {
                PsiMethod abstractOne;
                MethodSignature signature = (MethodSignature)entry.getKey();
                PsiMethod concrete = (PsiMethod)entry.getValue();
                if (finals.get(signature) != null || (abstractOne = (PsiMethod)abstracts.get(signature)) != null && abstractOne.getContainingClass().isInheritor(concrete.getContainingClass(), true) && !"java.lang.Object".equals(concrete.getContainingClass().getQualifiedName())) continue;
                PsiSubstitutor subst = OverrideImplementExploreUtil.correctSubstitutor(concrete, signature.getSubstitutor());
                CandidateInfo info = new CandidateInfo((PsiElement)concrete, subst);
                result.put(signature, info);
            }
        }
        return result;
    }

    private static boolean isDefaultMethod(@NotNull PsiClass aClass, @NotNull PsiMethod method) {
        return method.hasModifierProperty("default") && PsiUtil.getLanguageLevel((PsiElement)aClass).isAtLeast(LanguageLevel.JDK_1_8);
    }

    private static void fillMap(@NotNull HierarchicalMethodSignature signature, @NotNull PsiMethod method, @NotNull Map<MethodSignature, PsiMethod> map2) {
        PsiMethod other = map2.get(signature);
        if (other == null || OverrideImplementExploreUtil.preferLeftForImplement(method, other)) {
            map2.put((MethodSignature)signature, method);
        }
    }

    private static void collectMethodsToImplement(@NotNull PsiClass aClass, @NotNull Map<MethodSignature, PsiMethod> abstracts, @NotNull Map<MethodSignature, PsiMethod> finals, @NotNull Map<MethodSignature, PsiMethod> concretes, @NotNull Map<MethodSignature, CandidateInfo> result) {
        for (Map.Entry<MethodSignature, PsiMethod> entry : abstracts.entrySet()) {
            MethodSignature methodSignature = entry.getKey();
            PsiMethod abstractOne = entry.getValue();
            PsiMethod concrete = concretes.get(methodSignature);
            if (concrete != null && PsiUtil.getAccessLevel((PsiModifierList)concrete.getModifierList()) >= PsiUtil.getAccessLevel((PsiModifierList)abstractOne.getModifierList()) && (abstractOne.getContainingClass().isInterface() || !abstractOne.getContainingClass().isInheritor(concrete.getContainingClass(), true)) && !OverrideImplementExploreUtil.shouldAppearInOverrideList(aClass, abstractOne) || finals.get(methodSignature) != null) continue;
            PsiSubstitutor subst = OverrideImplementExploreUtil.correctSubstitutor(abstractOne, methodSignature.getSubstitutor());
            CandidateInfo info = new CandidateInfo((PsiElement)abstractOne, subst);
            result.put(methodSignature, info);
        }
        MemberImplementorExplorersProvider explorersProvider = (MemberImplementorExplorersProvider)ourExplorersProvider.getValue();
        if (explorersProvider != null) {
            for (MemberImplementorExplorer memberImplementorExplorer : explorersProvider.getExplorers()) {
                for (PsiMethod method : memberImplementorExplorer.getMethodsToImplement(aClass)) {
                    MethodSignatureBackedByPsiMethod signature = MethodSignatureBackedByPsiMethod.create((PsiMethod)method, (PsiSubstitutor)PsiSubstitutor.EMPTY);
                    CandidateInfo info = new CandidateInfo((PsiElement)method, PsiSubstitutor.EMPTY);
                    result.put((MethodSignature)signature, info);
                }
            }
        }
    }

    private static boolean shouldAppearInOverrideList(@NotNull PsiClass aClass, PsiMethod abstractOne) {
        return OverrideImplementExploreUtil.isDefaultMethod(aClass, abstractOne) || "java.lang.Record".equals(Objects.requireNonNull(abstractOne.getContainingClass()).getQualifiedName());
    }

    private static boolean preferLeftForImplement(@NotNull PsiMethod left, @NotNull PsiMethod right) {
        PsiAnnotation[] rightAnnotations;
        if (PsiUtil.getAccessLevel((PsiModifierList)left.getModifierList()) > PsiUtil.getAccessLevel((PsiModifierList)right.getModifierList())) {
            return true;
        }
        if (!left.getContainingClass().isInterface()) {
            return true;
        }
        if (!right.getContainingClass().isInterface()) {
            return false;
        }
        PsiAnnotation[] leftAnnotations = left.getModifierList().getAnnotations();
        return leftAnnotations.length > (rightAnnotations = right.getModifierList().getAnnotations()).length;
    }

    @NotNull
    public static PsiSubstitutor correctSubstitutor(@NotNull PsiMethod method, @NotNull PsiSubstitutor substitutor) {
        PsiClass hisClass = method.getContainingClass();
        PsiTypeParameter[] typeParameters = method.getTypeParameters();
        if (typeParameters.length > 0 && PsiUtil.isRawSubstitutor((PsiTypeParameterListOwner)hisClass, (PsiSubstitutor)substitutor)) {
            substitutor = JavaPsiFacade.getElementFactory((Project)method.getProject()).createRawSubstitutor(substitutor, typeParameters);
        }
        return substitutor;
    }

    public static class MethodSignatureComparator
    implements Comparator<MethodSignature> {
        @Override
        public int compare(MethodSignature o1, MethodSignature o2) {
            if (o1 instanceof MethodSignatureBackedByPsiMethod && o2 instanceof MethodSignatureBackedByPsiMethod) {
                PsiMethod m1 = ((MethodSignatureBackedByPsiMethod)o1).getMethod();
                PsiMethod m2 = ((MethodSignatureBackedByPsiMethod)o2).getMethod();
                PsiClass c1 = m1.getContainingClass();
                PsiClass c2 = m2.getContainingClass();
                if (c1 != null && c2 != null) {
                    if (c1 == c2) {
                        List<PsiMethod> methods = Arrays.asList(c1.getMethods());
                        return methods.indexOf(m1) - methods.indexOf(m2);
                    }
                    if (c1.isInheritor(c2, true)) {
                        return -1;
                    }
                    if (c2.isInheritor(c1, true)) {
                        return 1;
                    }
                    return StringUtil.notNullize((String)c1.getQualifiedName()).compareTo(StringUtil.notNullize((String)c2.getQualifiedName()));
                }
                return m1.getTextOffset() - m2.getTextOffset();
            }
            return 0;
        }
    }

    @FunctionalInterface
    public static interface MemberImplementorExplorersProvider {
        @NotNull
        public List<? extends MemberImplementorExplorer> getExplorers();
    }
}

