/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.wordSelection;

import com.intellij.codeInsight.editorActions.wordSelection.BasicSelectioner;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiTryStatement;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class FinallyBlockSelectioner
extends BasicSelectioner {
    @Override
    public boolean canSelect(@NotNull PsiElement e) {
        return e instanceof PsiKeyword && "finally".equals(e.getText());
    }

    public List<TextRange> select(@NotNull PsiElement e, @NotNull CharSequence editorText, int cursorOffset, @NotNull Editor editor) {
        PsiTryStatement tryStatement;
        PsiCodeBlock finallyBlock;
        ArrayList<TextRange> result = new ArrayList<TextRange>();
        PsiElement parent = e.getParent();
        if (parent instanceof PsiTryStatement && (finallyBlock = (tryStatement = (PsiTryStatement)parent).getFinallyBlock()) != null) {
            result.add(new TextRange(e.getTextRange().getStartOffset(), finallyBlock.getTextRange().getEndOffset()));
        }
        return result;
    }
}

