/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.codeInsight.editorActions.BackspaceHandlerDelegate;
import com.intellij.codeInsight.editorActions.JavaTypedHandler;
import com.intellij.codeInsight.editorActions.TypedHandlerUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiUtil;
import org.jetbrains.annotations.NotNull;

public class JavaBackspaceHandler
extends BackspaceHandlerDelegate {
    private boolean myToDeleteGt;

    public void beforeCharDeleted(char c, @NotNull PsiFile file, @NotNull Editor editor) {
        this.myToDeleteGt = c == '<' && file instanceof PsiJavaFile && PsiUtil.isLanguageLevel5OrHigher((PsiElement)file) && TypedHandlerUtil.isAfterClassLikeIdentifierOrDot((int)(editor.getCaretModel().getOffset() - 1), (Editor)editor, (IElementType)JavaTokenType.DOT, (IElementType)JavaTokenType.IDENTIFIER, (boolean)true);
    }

    public boolean charDeleted(char c, @NotNull PsiFile file, @NotNull Editor editor) {
        if (c == '<' && this.myToDeleteGt) {
            int offset = editor.getCaretModel().getOffset();
            CharSequence chars = editor.getDocument().getCharsSequence();
            if (editor.getDocument().getTextLength() <= offset) {
                return false;
            }
            char c1 = chars.charAt(offset);
            if (c1 != '>') {
                return true;
            }
            TypedHandlerUtil.handleGenericLTDeletion((Editor)editor, (int)offset, (IElementType)JavaTokenType.LT, (IElementType)JavaTokenType.GT, (TokenSet)JavaTypedHandler.INVALID_INSIDE_REFERENCE);
            return true;
        }
        return false;
    }

    @Deprecated
    public static void handleLTDeletion(@NotNull Editor editor, int offset, @NotNull IElementType lt, @NotNull IElementType gt, @NotNull TokenSet invalidInsideReference) {
        TypedHandlerUtil.handleGenericLTDeletion((Editor)editor, (int)offset, (IElementType)lt, (IElementType)gt, (TokenSet)invalidInsideReference);
    }
}

