/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.codeInsight.editorActions.ChainCallJoinLinesHandler;
import com.intellij.codeInsight.editorActions.JoinLinesHandlerDelegate;
import com.intellij.openapi.editor.Document;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import org.jetbrains.annotations.NotNull;

public class AssignmentSequenceJoinLinesHandler
implements JoinLinesHandlerDelegate {
    public int tryJoinLines(@NotNull Document document, @NotNull PsiFile psiFile, int start, int end) {
        PsiJavaToken elementAtStartLineEnd = (PsiJavaToken)ObjectUtils.tryCast((Object)psiFile.findElementAt(start), PsiJavaToken.class);
        if (elementAtStartLineEnd == null || !elementAtStartLineEnd.getTokenType().equals(JavaTokenType.SEMICOLON)) {
            return -1;
        }
        PsiElement firstElement = elementAtStartLineEnd.getParent();
        PsiExpression firstValue = null;
        PsiLocalVariable variable = null;
        if (firstElement instanceof PsiExpressionStatement) {
            PsiExpressionStatement firstStatement = (PsiExpressionStatement)firstElement;
            PsiAssignmentExpression firstAssignment = ExpressionUtils.getAssignment((PsiElement)firstStatement);
            if (firstAssignment == null) {
                return -1;
            }
            PsiReferenceExpression ref = (PsiReferenceExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)firstAssignment.getLExpression()), PsiReferenceExpression.class);
            if (ref == null) {
                return -1;
            }
            variable = (PsiVariable)ObjectUtils.tryCast((Object)ref.resolve(), PsiVariable.class);
            firstValue = firstAssignment.getRExpression();
        } else if (firstElement instanceof PsiLocalVariable) {
            variable = (PsiLocalVariable)firstElement;
            firstValue = variable.getInitializer();
        }
        if (firstValue == null || !(variable instanceof PsiLocalVariable) && !(variable instanceof PsiParameter)) {
            return -1;
        }
        PsiExpressionStatement secondStatement = (PsiExpressionStatement)PsiTreeUtil.getParentOfType((PsiElement)psiFile.findElementAt(end), PsiExpressionStatement.class);
        PsiExpression secondValue = ExpressionUtils.getAssignmentTo((PsiElement)secondStatement, (PsiVariable)variable);
        if (!(secondValue instanceof PsiMethodCallExpression)) {
            return -1;
        }
        PsiExpression qualifier = ChainCallJoinLinesHandler.getDeepQualifier((PsiMethodCallExpression)secondValue);
        if (!ExpressionUtils.isReferenceTo(qualifier, (PsiVariable)variable)) {
            return -1;
        }
        if (ReferencesSearch.search((PsiElement)variable, (SearchScope)new LocalSearchScope((PsiElement)secondValue)).findAll().size() > 1) {
            return -1;
        }
        qualifier.replace((PsiElement)firstValue);
        firstValue.replace((PsiElement)secondValue);
        secondStatement.delete();
        return firstElement.getTextRange().getEndOffset();
    }
}

