/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.quickfix.StaticImportMemberFix;
import com.intellij.codeInsight.daemon.impl.quickfix.StaticImportMethodQuestionAction;
import com.intellij.codeInsight.daemon.impl.quickfix.StaticMembersProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.PsiShortNamesCache;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.Processor;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StaticImportConstantFix
extends StaticImportMemberFix<PsiField, PsiJavaCodeReferenceElement> {
    StaticImportConstantFix(@NotNull PsiFile file, @NotNull PsiJavaCodeReferenceElement referenceElement) {
        super(file, referenceElement);
    }

    @Override
    @NotNull
    protected String getBaseText() {
        return QuickFixBundle.message("static.import.constant.text", new Object[0]);
    }

    @Override
    @NotNull
    protected String getMemberPresentableText(@NotNull PsiField field) {
        return PsiFormatUtil.formatVariable((PsiVariable)field, (int)6145, (PsiSubstitutor)PsiSubstitutor.EMPTY);
    }

    @Override
    @NotNull
    protected List<PsiField> getMembersToImport(boolean applicableOnly, @NotNull StaticMembersProcessor.SearchMode searchMode) {
        String name2;
        Project project = this.myRef.getProject();
        PsiShortNamesCache cache = PsiShortNamesCache.getInstance((Project)project);
        PsiJavaCodeReferenceElement element = (PsiJavaCodeReferenceElement)this.myRef.getElement();
        String string = name2 = element != null ? element.getReferenceName() : null;
        if (name2 == null) {
            return Collections.emptyList();
        }
        if (element instanceof PsiExpression && PsiUtil.isAccessedForWriting((PsiExpression)((PsiExpression)element)) || element.getParent() instanceof PsiTypeElement || element.getParent() instanceof PsiAnnotation) {
            return Collections.emptyList();
        }
        StaticMembersProcessor<PsiField> processor2 = new StaticMembersProcessor<PsiField>((PsiElement)element, this.toAddStaticImports(), searchMode){

            @Override
            protected boolean isApplicable(PsiField field, PsiElement place) {
                ProgressManager.checkCanceled();
                PsiType fieldType = field.getType();
                return this.isApplicableFor(fieldType);
            }
        };
        cache.processFieldsWithName(name2, (Processor)processor2, element.getResolveScope(), null);
        return processor2.getMembersToImport(applicableOnly);
    }

    @NotNull
    protected StaticImportMethodQuestionAction<PsiField> createQuestionAction(@NotNull List<? extends PsiField> methodsToImport, @NotNull Project project, Editor editor) {
        return new StaticImportMethodQuestionAction<PsiField>(project, editor, methodsToImport, this.myRef){

            @Override
            @NotNull
            protected String getPopupTitle() {
                return QuickFixBundle.message("field.to.import.chooser.title", new Object[0]);
            }
        };
    }

    @Override
    @Nullable
    protected PsiElement getElement() {
        return this.myRef.getElement();
    }

    @Override
    @Nullable
    protected PsiElement getQualifierExpression() {
        PsiJavaCodeReferenceElement element = (PsiJavaCodeReferenceElement)this.myRef.getElement();
        return element != null ? element.getQualifier() : null;
    }

    @Override
    @Nullable
    protected PsiElement resolveRef() {
        PsiJavaCodeReferenceElement referenceElement = (PsiJavaCodeReferenceElement)this.getElement();
        return referenceElement != null ? referenceElement.advancedResolve(true).getElement() : null;
    }

    @Override
    protected boolean toAddStaticImports() {
        return true;
    }
}

