/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiWildcardType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReplacePrimitiveWithBoxedTypeAction
extends LocalQuickFixAndIntentionActionOnPsiElement {
    private final String myPrimitiveName;
    private final String myBoxedTypeName;
    private static final Logger LOG = Logger.getInstance(ReplacePrimitiveWithBoxedTypeAction.class);

    public ReplacePrimitiveWithBoxedTypeAction(@NotNull PsiTypeElement element, @NotNull String typeName, @NotNull String boxedTypeName) {
        super((PsiElement)element);
        this.myPrimitiveName = typeName;
        this.myBoxedTypeName = boxedTypeName;
    }

    @NotNull
    public String getText() {
        return CommonQuickFixBundle.message((String)"fix.replace.x.with.y", (Object[])new Object[]{this.myPrimitiveName, this.myBoxedTypeName});
    }

    @NotNull
    public String getFamilyName() {
        return QuickFixBundle.message("convert.primitive.to.boxed.type", new Object[0]);
    }

    public boolean isAvailable(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (startElement instanceof PsiTypeElement) {
            PsiType type2 = ((PsiTypeElement)startElement).getType();
            if (type2 instanceof PsiWildcardType) {
                type2 = ((PsiWildcardType)type2).getBound();
            }
            if (type2 instanceof PsiPrimitiveType) {
                return ((PsiPrimitiveType)type2).getBoxedType(startElement) != null;
            }
        }
        return false;
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        PsiClassType boxedType;
        PsiType type2 = ((PsiTypeElement)startElement).getType();
        if (type2 instanceof PsiPrimitiveType) {
            boxedType = ((PsiPrimitiveType)type2).getBoxedType(startElement);
        } else {
            LOG.assertTrue(type2 instanceof PsiWildcardType);
            PsiWildcardType wildcardType = (PsiWildcardType)type2;
            PsiClassType boxedBound = ((PsiPrimitiveType)wildcardType.getBound()).getBoxedType(startElement);
            LOG.assertTrue(boxedBound != null);
            boxedType = wildcardType.isExtends() ? PsiWildcardType.createExtends((PsiManager)startElement.getManager(), (PsiType)boxedBound) : PsiWildcardType.createSuper((PsiManager)startElement.getManager(), (PsiType)boxedBound);
        }
        LOG.assertTrue(boxedType != null);
        startElement.replace((PsiElement)JavaPsiFacade.getElementFactory((Project)project).createTypeElement((PsiType)boxedType));
    }
}

