/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.java.analysis.JavaAnalysisBundle;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReplaceAssignmentFromVoidWithStatementIntentionAction
implements IntentionAction {
    private final PsiElement myParent;
    private final PsiExpression myLExpr;

    public ReplaceAssignmentFromVoidWithStatementIntentionAction(@NotNull PsiElement parent, @NotNull PsiExpression lExpr) {
        this.myParent = parent;
        this.myLExpr = lExpr;
    }

    @Nls
    @NotNull
    public String getText() {
        return this.getFamilyName();
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        return JavaAnalysisBundle.message((String)"remove.left.side.of.assignment", (Object[])new Object[0]);
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        return this.myParent.isValid() && this.myLExpr.isValid();
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        this.myParent.replace((PsiElement)this.myLExpr);
    }

    public boolean startInWriteAction() {
        return true;
    }

    @Nullable
    public FileModifier getFileModifierForPreview(@NotNull PsiFile target) {
        return new ReplaceAssignmentFromVoidWithStatementIntentionAction(PsiTreeUtil.findSameElementInCopy((PsiElement)this.myParent, (PsiFile)target), (PsiExpression)PsiTreeUtil.findSameElementInCopy((PsiElement)this.myLExpr, (PsiFile)target));
    }
}

