/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.ig.psiutils.CommentTracker;
import org.jetbrains.annotations.NotNull;

public class InsertNewFix
implements IntentionAction {
    private final PsiMethodCallExpression myMethodCall;
    private final PsiClass myClass;

    public InsertNewFix(@NotNull PsiMethodCallExpression methodCall, @NotNull PsiClass aClass) {
        this.myMethodCall = methodCall;
        this.myClass = aClass;
    }

    @NotNull
    public String getText() {
        return QuickFixBundle.message("insert.new.fix", new Object[0]);
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        return this.myMethodCall.isValid() && BaseIntentionAction.canModify((PsiElement)this.myMethodCall) && !(this.myMethodCall.getNextSibling() instanceof PsiErrorElement);
    }

    @NotNull
    public PsiElement getElementToMakeWritable(@NotNull PsiFile file) {
        return this.myMethodCall;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)this.myMethodCall.getProject());
        PsiNewExpression newExpression = (PsiNewExpression)factory.createExpressionFromText("new X()", null);
        CommentTracker tracker = new CommentTracker();
        PsiJavaCodeReferenceElement classReference2 = newExpression.getClassReference();
        assert (classReference2 != null);
        classReference2.replace((PsiElement)factory.createClassReferenceElement(this.myClass));
        PsiExpressionList argumentList = newExpression.getArgumentList();
        assert (argumentList != null);
        argumentList.replace((PsiElement)tracker.markUnchanged(this.myMethodCall.getArgumentList()));
        tracker.replaceAndRestoreComments((PsiElement)this.myMethodCall, (PsiElement)newExpression);
    }

    public boolean startInWriteAction() {
        return true;
    }
}

