/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.java.analysis.JavaAnalysisBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.util.IncorrectOperationException;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class FlipIntersectionSidesFix
implements IntentionAction {
    private static final Logger LOG = Logger.getInstance(FlipIntersectionSidesFix.class);
    private final String myClassName;
    private final List<PsiTypeElement> myConjuncts;
    private final PsiTypeElement myConjunct;
    private final PsiTypeElement myCastTypeElement;

    public FlipIntersectionSidesFix(String className2, @NotNull List<PsiTypeElement> conjList, PsiTypeElement conjunct, PsiTypeElement castTypeElement) {
        this.myClassName = className2;
        this.myConjuncts = conjList;
        LOG.assertTrue(!conjList.isEmpty());
        this.myConjunct = conjunct;
        this.myCastTypeElement = castTypeElement;
    }

    @NotNull
    public String getText() {
        return JavaAnalysisBundle.message((String)"move.0.to.the.beginning", (Object[])new Object[]{this.myClassName});
    }

    @NotNull
    public String getFamilyName() {
        return JavaAnalysisBundle.message((String)"move.to.front", (Object[])new Object[0]);
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        for (PsiTypeElement typeElement : this.myConjuncts) {
            if (typeElement.isValid()) continue;
            return false;
        }
        return !Comparing.strEqual((String)this.myConjunct.getText(), (String)this.myConjuncts.get(0).getText());
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        this.myConjuncts.remove(this.myConjunct);
        this.myConjuncts.add(0, this.myConjunct);
        String intersectionTypeText = StringUtil.join(this.myConjuncts, element -> element.getText(), (String)" & ");
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)project);
        PsiTypeCastExpression fixedCast = (PsiTypeCastExpression)elementFactory.createExpressionFromText("(" + intersectionTypeText + ") a", (PsiElement)this.myCastTypeElement);
        PsiTypeElement fixedCastCastType = fixedCast.getCastType();
        LOG.assertTrue(fixedCastCastType != null);
        PsiElement flippedTypeElement = this.myCastTypeElement.replace((PsiElement)fixedCastCastType);
        CodeStyleManager.getInstance((Project)project).reformat(flippedTypeElement);
    }

    public boolean startInWriteAction() {
        return true;
    }
}

