/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.BlockUtils;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.JavaElementKind;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.SideEffectChecker;
import com.siyeh.ig.psiutils.StatementExtractor;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeleteSideEffectsAwareFix
extends LocalQuickFixAndIntentionActionOnPsiElement
implements LowPriorityAction {
    private final SmartPsiElementPointer<PsiStatement> myStatementPtr;
    private final SmartPsiElementPointer<PsiExpression> myExpressionPtr;
    private final String myMessage;
    private final boolean myIsAvailable;

    public DeleteSideEffectsAwareFix(@NotNull PsiStatement statement, PsiExpression expression2) {
        this(statement, expression2, false);
    }

    public DeleteSideEffectsAwareFix(@NotNull PsiStatement statement, PsiExpression expression2, boolean alwaysAvailable) {
        super((PsiElement)statement);
        SmartPointerManager manager = SmartPointerManager.getInstance((Project)statement.getProject());
        this.myStatementPtr = manager.createSmartPsiElementPointer((PsiElement)statement);
        this.myExpressionPtr = manager.createSmartPsiElementPointer((PsiElement)expression2);
        List<PsiExpression> sideEffects = SideEffectChecker.extractSideEffectExpressions(expression2);
        if (sideEffects.isEmpty()) {
            JavaElementKind kind2 = statement instanceof PsiExpressionStatement ? JavaElementKind.EXPRESSION : JavaElementKind.STATEMENT;
            this.myMessage = CommonQuickFixBundle.message((String)"fix.remove.title", (Object[])new Object[]{kind2.object()});
        } else {
            PsiStatement[] statements = StatementExtractor.generateStatements(sideEffects, expression2);
            this.myMessage = statements.length == 1 && statements[0] instanceof PsiIfStatement ? QuickFixBundle.message("extract.side.effects.convert.to.if", new Object[0]) : QuickFixBundle.message("extract.side.effects", statements.length);
        }
        this.myIsAvailable = alwaysAvailable || sideEffects.size() != 1 || !(statement instanceof PsiExpressionStatement) || sideEffects.get(0) != PsiUtil.skipParenthesizedExprDown((PsiExpression)expression2);
    }

    @Nls
    @NotNull
    public String getText() {
        return this.myMessage;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        return QuickFixBundle.message("extract.side.effects.family.name", new Object[0]);
    }

    public boolean isAvailable(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        return this.myIsAvailable;
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        PsiElement parent;
        PsiStatement statement = (PsiStatement)this.myStatementPtr.getElement();
        if (statement == null) {
            return;
        }
        PsiExpression expression2 = (PsiExpression)this.myExpressionPtr.getElement();
        if (expression2 == null) {
            return;
        }
        List<PsiExpression> sideEffects = SideEffectChecker.extractSideEffectExpressions(expression2);
        CommentTracker ct = new CommentTracker();
        sideEffects.forEach(ct::markUnchanged);
        PsiStatement[] statements = StatementExtractor.generateStatements(sideEffects, expression2);
        if (statements.length > 0) {
            PsiStatement lastAdded = BlockUtils.addBefore(statement, statements);
            statement = (PsiStatement)Objects.requireNonNull(PsiTreeUtil.getNextSiblingOfType((PsiElement)lastAdded, PsiStatement.class));
        }
        if (!(!((parent = statement.getParent()) instanceof PsiStatement) || parent instanceof PsiIfStatement && ((PsiIfStatement)parent).getElseBranch() == statement || parent instanceof PsiForStatement && ((PsiForStatement)parent).getUpdate() == statement)) {
            ct.replaceAndRestoreComments((PsiElement)statement, "{}");
        } else {
            ct.deleteAndRestoreComments((PsiElement)statement);
        }
    }

    @Nullable
    public FileModifier getFileModifierForPreview(@NotNull PsiFile target) {
        PsiExpression expression2 = (PsiExpression)this.myExpressionPtr.getElement();
        PsiStatement statement = (PsiStatement)this.myStatementPtr.getElement();
        if (expression2 == null || statement == null) {
            return null;
        }
        return new DeleteSideEffectsAwareFix((PsiStatement)PsiTreeUtil.findSameElementInCopy((PsiElement)statement, (PsiFile)target), (PsiExpression)PsiTreeUtil.findSameElementInCopy((PsiElement)expression2, (PsiFile)target));
    }
}

