/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DeleteMethodBodyFix
implements IntentionAction {
    private final PsiMethod myMethod;

    public DeleteMethodBodyFix(@NotNull PsiMethod method) {
        this.myMethod = method;
    }

    @NotNull
    public String getText() {
        return QuickFixBundle.message("delete.body.text", new Object[0]);
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        return this.myMethod.isValid() && BaseIntentionAction.canModify((PsiElement)this.myMethod) && this.myMethod.getBody() != null;
    }

    @NotNull
    public PsiElement getElementToMakeWritable(@NotNull PsiFile file) {
        return this.myMethod;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        PsiCodeBlock body2 = this.myMethod.getBody();
        assert (body2 != null);
        body2.delete();
    }

    public boolean startInWriteAction() {
        return true;
    }

    @Nullable
    public FileModifier getFileModifierForPreview(@NotNull PsiFile target) {
        return new DeleteMethodBodyFix((PsiMethod)PsiTreeUtil.findSameElementInCopy((PsiElement)this.myMethod, (PsiFile)target));
    }
}

