/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.ExpectedTypeInfo;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateMethodFromUsageFix;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class CreateStaticMethodQuickFix
implements LocalQuickFix {
    private final SmartPsiElementPointer<PsiClass> myTargetClass;
    private final String myMethodName;
    private final List<String> myTypes;

    public CreateStaticMethodQuickFix(@NotNull PsiClass aClass, @NotNull String name2, @NotNull List<String> types) {
        this.myTargetClass = SmartPointerManager.createPointer((PsiElement)aClass);
        this.myMethodName = name2;
        this.myTypes = types;
    }

    @NotNull
    public String getFamilyName() {
        return QuickFixBundle.message("create.method.from.usage.family", new Object[0]);
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        PsiMethod method;
        PsiClass targetClass = (PsiClass)this.myTargetClass.getElement();
        if (targetClass == null) {
            return;
        }
        boolean java8Interface = false;
        if (targetClass.isInterface()) {
            if (PsiUtil.isLanguageLevel8OrHigher((PsiElement)targetClass)) {
                java8Interface = true;
            } else {
                return;
            }
        }
        if ((method = CreateMethodFromUsageFix.createMethod(targetClass, null, null, this.myMethodName)) == null) {
            return;
        }
        if (!java8Interface) {
            PsiUtil.setModifierProperty((PsiModifierListOwner)method, (String)"public", (boolean)true);
        }
        PsiUtil.setModifierProperty((PsiModifierListOwner)method, (String)"static", (boolean)true);
        List args = ContainerUtil.map(this.myTypes, s -> new Pair(null, (Object)PsiType.getTypeByName((String)s, (Project)project, (GlobalSearchScope)GlobalSearchScope.allScope((Project)project))));
        CreateMethodFromUsageFix.doCreate(targetClass, method, false, args, PsiSubstitutor.UNKNOWN, ExpectedTypeInfo.EMPTY_ARRAY, null);
    }
}

