/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.ExpectedTypeInfo;
import com.intellij.codeInsight.ExpectedTypesProvider;
import com.intellij.codeInsight.TailType;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateClassFromNewFix;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateClassKind;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateFromUsageUtils;
import com.intellij.codeInsight.daemon.impl.quickfix.GuessTypeParameters;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.TemplateBuilder;
import com.intellij.codeInsight.template.TemplateBuilderImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JVMElementFactory;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiRecordComponent;
import com.intellij.psi.PsiRecordHeader;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateRecordFromNewFix
extends CreateClassFromNewFix {
    public CreateRecordFromNewFix(PsiNewExpression newExpression) {
        super(newExpression);
    }

    @Override
    @NotNull
    protected CreateClassKind getKind() {
        return CreateClassKind.RECORD;
    }

    @Override
    @NotNull
    TemplateBuilderImpl createConstructorTemplate(PsiClass aClass, PsiNewExpression newExpression, PsiExpressionList argList) {
        TemplateBuilderImpl templateBuilder = new TemplateBuilderImpl((PsiElement)aClass);
        PsiRecordHeader header = aClass.getRecordHeader();
        CreateRecordFromNewFix.setupRecordComponents(header, (TemplateBuilder)templateBuilder, argList, CreateRecordFromNewFix.getTargetSubstitutor((PsiElement)newExpression));
        return templateBuilder;
    }

    static void setupRecordComponents(@Nullable PsiRecordHeader header, @NotNull TemplateBuilder builder, @NotNull PsiExpressionList argumentList, @NotNull PsiSubstitutor substitutor) throws IncorrectOperationException {
        if (header == null) {
            return;
        }
        PsiExpression[] args = argumentList.getExpressions();
        PsiManager psiManager = header.getManager();
        Project project = psiManager.getProject();
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
        GlobalSearchScope resolveScope = header.getResolveScope();
        GuessTypeParameters guesser = new GuessTypeParameters(project, (JVMElementFactory)JavaPsiFacade.getElementFactory((Project)project), builder, substitutor);
        PsiClass containingClass = header.getContainingClass();
        if (containingClass == null) {
            return;
        }
        class ComponentData {
            final PsiType myType;
            final String[] myNames;

            ComponentData(PsiType type2, String[] names2) {
                this.myType = type2;
                this.myNames = names2;
            }

            public String toString() {
                return this.myType.getCanonicalText() + " " + this.myNames[0];
            }
        }
        ArrayList<ComponentData> components = new ArrayList<ComponentData>();
        for (int i = 0; i < Math.min(args.length, 255); ++i) {
            PsiExpression exp = args[i];
            PsiType argType = RefactoringUtil.getTypeByExpression(exp);
            SuggestedNameInfo suggestedInfo = JavaCodeStyleManager.getInstance((Project)project).suggestVariableName(VariableKind.PARAMETER, null, exp, argType);
            String[] names2 = suggestedInfo.names;
            if (names2.length == 0) {
                names2 = new String[]{"c" + i};
            }
            argType = CreateFromUsageUtils.getParameterTypeByArgumentType(argType, psiManager, resolveScope);
            components.add(new ComponentData(argType, names2));
        }
        PsiRecordHeader newHeader = factory.createRecordHeaderFromText(StringUtil.join(components, (String)", "), (PsiElement)containingClass);
        PsiRecordHeader replacedHeader = (PsiRecordHeader)header.replace((PsiElement)newHeader);
        PsiRecordComponent[] recordComponents = replacedHeader.getRecordComponents();
        assert (recordComponents.length == components.size());
        for (int i = 0; i < recordComponents.length; ++i) {
            PsiRecordComponent component = recordComponents[i];
            ComponentData data = (ComponentData)components.get(i);
            ExpectedTypeInfo info = ExpectedTypesProvider.createInfo(data.myType, 2, data.myType, TailType.NONE);
            PsiElement context = PsiTreeUtil.getParentOfType((PsiElement)argumentList, (Class[])new Class[]{PsiClass.class, PsiMethod.class});
            guesser.setupTypeElement(Objects.requireNonNull(component.getTypeElement()), new ExpectedTypeInfo[]{info}, context, containingClass);
            CreateFromUsageUtils.ParameterNameExpression expression2 = new CreateFromUsageUtils.ParameterNameExpression(data.myNames);
            builder.replaceElement((PsiElement)Objects.requireNonNull(component.getNameIdentifier()), (Expression)expression2);
        }
    }
}

