/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightControlFlowUtil;
import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResourceVariable;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import gnu.trove.THashMap;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BringVariableIntoScopeFix
implements IntentionAction {
    private static final Logger LOG = Logger.getInstance(BringVariableIntoScopeFix.class);
    @NotNull
    private final PsiReferenceExpression myUnresolvedReference;
    @NotNull
    private final PsiLocalVariable myOutOfScopeVariable;

    private BringVariableIntoScopeFix(@NotNull PsiReferenceExpression unresolvedReference, @NotNull PsiLocalVariable variable) {
        this.myUnresolvedReference = unresolvedReference;
        this.myOutOfScopeVariable = variable;
    }

    @Nullable
    static BringVariableIntoScopeFix fromReference(PsiReferenceExpression unresolvedReference) {
        if (unresolvedReference.isQualified()) {
            return null;
        }
        String referenceName = unresolvedReference.getReferenceName();
        if (referenceName == null) {
            return null;
        }
        PsiElement container = PsiTreeUtil.getParentOfType((PsiElement)unresolvedReference, (Class[])new Class[]{PsiCodeBlock.class, PsiClass.class});
        if (!(container instanceof PsiCodeBlock)) {
            return null;
        }
        while (container.getParent() instanceof PsiStatement || container.getParent() instanceof PsiCatchSection) {
            container = container.getParent();
        }
        class Visitor
        extends JavaRecursiveElementWalkingVisitor {
            int variableCount = 0;
            PsiLocalVariable myOutOfScopeVariable;
            final /* synthetic */ String val$referenceName;

            Visitor(String string) {
                this.val$referenceName = string;
            }

            public void visitReferenceExpression(PsiReferenceExpression expression2) {
            }

            public void visitExpression(PsiExpression expression2) {
            }

            public void visitLocalVariable(PsiLocalVariable variable) {
                if (this.val$referenceName.equals(variable.getName())) {
                    this.myOutOfScopeVariable = variable;
                    ++this.variableCount;
                    if (this.variableCount > 1) {
                        this.stopWalking();
                    }
                }
            }
        }
        Visitor visitor2 = new Visitor(referenceName);
        container.accept((PsiElementVisitor)visitor2);
        if (visitor2.variableCount != 1 || visitor2.myOutOfScopeVariable instanceof PsiResourceVariable) {
            return null;
        }
        return new BringVariableIntoScopeFix(unresolvedReference, visitor2.myOutOfScopeVariable);
    }

    @NotNull
    public String getText() {
        PsiLocalVariable variable = this.myOutOfScopeVariable;
        String varText = !variable.isValid() ? "" : PsiFormatUtil.formatVariable((PsiVariable)variable, (int)3, (PsiSubstitutor)PsiSubstitutor.EMPTY);
        return QuickFixBundle.message("bring.variable.to.scope.text", varText);
    }

    @NotNull
    public String getFamilyName() {
        return QuickFixBundle.message("bring.variable.to.scope.family", new Object[0]);
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (!(file instanceof PsiJavaFile)) {
            return false;
        }
        return this.myUnresolvedReference.isValid() && BaseIntentionAction.canModify((PsiElement)this.myUnresolvedReference) && this.myOutOfScopeVariable.isValid();
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiFile file) throws IncorrectOperationException {
        PsiLocalVariable child;
        PsiLocalVariable outOfScopeVariable = this.myOutOfScopeVariable;
        LOG.assertTrue(outOfScopeVariable != null);
        PsiManager manager = file.getManager();
        outOfScopeVariable.normalizeDeclaration();
        PsiUtil.setModifierProperty((PsiModifierListOwner)outOfScopeVariable, (String)"final", (boolean)false);
        PsiElement commonParent = PsiTreeUtil.findCommonParent((PsiElement)outOfScopeVariable, (PsiElement)this.myUnresolvedReference);
        LOG.assertTrue(commonParent != null);
        Object object = child = outOfScopeVariable.getTextRange().getStartOffset() < this.myUnresolvedReference.getTextRange().getStartOffset() ? outOfScopeVariable : this.myUnresolvedReference;
        while (child.getParent() != commonParent) {
            child = child.getParent();
        }
        PsiDeclarationStatement newDeclaration = (PsiDeclarationStatement)JavaPsiFacade.getElementFactory((Project)manager.getProject()).createStatementFromText("int i = 0", null);
        PsiVariable variable = (PsiVariable)newDeclaration.getDeclaredElements()[0].replace((PsiElement)outOfScopeVariable);
        if (variable.getInitializer() != null) {
            variable.getInitializer().delete();
        }
        while (!(child instanceof PsiStatement) || !(child.getParent() instanceof PsiCodeBlock)) {
            child = child.getParent();
            commonParent = commonParent.getParent();
        }
        LOG.assertTrue(commonParent != null);
        PsiDeclarationStatement added = (PsiDeclarationStatement)commonParent.addBefore((PsiElement)newDeclaration, (PsiElement)child);
        PsiElement[] declaredElements = added.getDeclaredElements();
        LOG.assertTrue(declaredElements.length > 0, (Object)added.getText());
        PsiLocalVariable addedVar = (PsiLocalVariable)declaredElements[0];
        assert (addedVar != null) : added;
        CodeStyleManager.getInstance((Project)manager.getProject()).reformat(commonParent);
        PsiExpression initializer = outOfScopeVariable.getInitializer();
        if (initializer != null) {
            PsiExpressionStatement assignment = (PsiExpressionStatement)JavaPsiFacade.getElementFactory((Project)manager.getProject()).createStatementFromText(outOfScopeVariable.getName() + "= e;", null);
            Objects.requireNonNull(((PsiAssignmentExpression)assignment.getExpression()).getRExpression()).replace((PsiElement)initializer);
            assignment = (PsiExpressionStatement)CodeStyleManager.getInstance((Project)manager.getProject()).reformat((PsiElement)assignment);
            PsiDeclarationStatement declStatement = (PsiDeclarationStatement)PsiTreeUtil.getParentOfType((PsiElement)outOfScopeVariable, PsiDeclarationStatement.class);
            LOG.assertTrue(declStatement != null);
            PsiElement parent = declStatement.getParent();
            if (parent instanceof PsiForStatement) {
                declStatement.replace((PsiElement)assignment);
            } else {
                parent.addAfter((PsiElement)assignment, (PsiElement)declStatement);
            }
        }
        if (outOfScopeVariable.isValid()) {
            outOfScopeVariable.delete();
        }
        if (HighlightControlFlowUtil.checkVariableInitializedBeforeUsage(this.myUnresolvedReference, (PsiVariable)addedVar, (Map<PsiElement, Collection<PsiReferenceExpression>>)new THashMap(), file) != null) {
            BringVariableIntoScopeFix.initialize(addedVar);
        }
    }

    private static void initialize(PsiLocalVariable variable) throws IncorrectOperationException {
        PsiType type2 = variable.getType();
        String init = PsiTypesUtil.getDefaultValueOfType((PsiType)type2);
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)variable.getProject());
        PsiExpression initializer = factory.createExpressionFromText(init, (PsiElement)variable);
        variable.setInitializer(initializer);
    }

    public boolean startInWriteAction() {
        return true;
    }

    @NotNull
    public FileModifier getFileModifierForPreview(@NotNull PsiFile target) {
        return new BringVariableIntoScopeFix((PsiReferenceExpression)PsiTreeUtil.findSameElementInCopy((PsiElement)this.myUnresolvedReference, (PsiFile)target), (PsiLocalVariable)PsiTreeUtil.findSameElementInCopy((PsiElement)this.myOutOfScopeVariable, (PsiFile)target));
    }
}

