/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.impl.quickfix.AddReturnFix;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.codeInsight.lookup.ExpressionLookupItem;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.PsiElementResult;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.TemplateBuilderFactory;
import com.intellij.codeInsight.template.TemplateBuilderImpl;
import com.intellij.codeInsight.template.impl.ConstantNode;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.java.JavaBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDiamondTypeImpl;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddVariableInitializerFix
extends LocalQuickFixAndIntentionActionOnPsiElement {
    private static final Logger LOG = Logger.getInstance(AddReturnFix.class);

    public AddVariableInitializerFix(@NotNull PsiVariable variable) {
        super((PsiElement)variable);
    }

    @NotNull
    public String getText() {
        PsiVariable variable = (PsiVariable)ObjectUtils.tryCast((Object)this.myStartElement.getElement(), PsiVariable.class);
        return variable == null ? this.getFamilyName() : JavaBundle.message((String)"quickfix.add.variable.text", (Object[])new Object[]{variable.getName()});
    }

    @NotNull
    public String getFamilyName() {
        return JavaBundle.message((String)"quickfix.add.variable.family.name", (Object[])new Object[0]);
    }

    public boolean isAvailable(@NotNull Project project, @NotNull PsiFile file, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        PsiVariable variable = (PsiVariable)ObjectUtils.tryCast((Object)startElement, PsiVariable.class);
        return variable != null && variable.isValid() && BaseIntentionAction.canModify((PsiElement)variable) && !variable.hasInitializer() && !(variable instanceof PsiParameter);
    }

    @NotNull
    public PsiElement getElementToMakeWritable(@NotNull PsiFile file) {
        return file;
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        PsiVariable variable = (PsiVariable)ObjectUtils.tryCast((Object)startElement, PsiVariable.class);
        if (variable == null) {
            return;
        }
        LookupElement[] suggestedInitializers = AddVariableInitializerFix.suggestInitializer(variable);
        LOG.assertTrue(suggestedInitializers.length > 0);
        LOG.assertTrue(suggestedInitializers[0] instanceof ExpressionLookupItem);
        PsiExpression initializer = (PsiExpression)suggestedInitializers[0].getObject();
        variable.setInitializer(initializer);
        if (!file.isPhysical()) {
            return;
        }
        Document document = Objects.requireNonNull(PsiDocumentManager.getInstance((Project)project).getDocument(file));
        PsiDocumentManager.getInstance((Project)initializer.getProject()).doPostponedOperationsAndUnblockDocument(document);
        AddVariableInitializerFix.runAssignmentTemplate(Collections.singletonList(variable.getInitializer()), suggestedInitializers, editor);
    }

    static void runAssignmentTemplate(@NotNull List<? extends PsiExpression> initializers, LookupElement @NotNull [] suggestedInitializers, @Nullable Editor editor) {
        PsiExpression context;
        if (editor == null) {
            return;
        }
        LOG.assertTrue(!initializers.isEmpty());
        PsiExpression initializer = (PsiExpression)Objects.requireNonNull(ContainerUtil.getFirstItem(initializers));
        Object object = context = initializers.size() == 1 ? initializer : PsiTreeUtil.findCommonParent(initializers);
        if (context == null) {
            return;
        }
        TemplateBuilderImpl builder = (TemplateBuilderImpl)TemplateBuilderFactory.getInstance().createTemplateBuilder((PsiElement)context);
        for (PsiExpression psiExpression : initializers) {
            builder.replaceElement((PsiElement)psiExpression, (Expression)new ConstantNode((Result)new PsiElementResult(suggestedInitializers[0].getPsiElement())).withLookupItems(suggestedInitializers));
        }
        builder.run(editor, false);
    }

    static LookupElement @NotNull [] suggestInitializer(PsiVariable variable) {
        PsiType type2 = variable.getType();
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)variable.getProject());
        SmartList result = new SmartList();
        String defaultValue = PsiTypesUtil.getDefaultValueOfType((PsiType)type2);
        ExpressionLookupItem defaultExpression = new ExpressionLookupItem(elementFactory.createExpressionFromText(defaultValue, (PsiElement)variable));
        result.add(defaultExpression);
        if (type2 instanceof PsiClassType) {
            PsiClass aClass;
            if (type2.equalsToText("java.lang.String")) {
                result.add(new ExpressionLookupItem(elementFactory.createExpressionFromText("\"\"", (PsiElement)variable)));
            }
            if ((aClass = PsiTypesUtil.getPsiClass((PsiType)type2)) != null && !aClass.hasModifierProperty("abstract") && PsiUtil.hasDefaultConstructor((PsiClass)aClass)) {
                String typeText = type2.getCanonicalText(false);
                if (aClass.getTypeParameters().length > 0 && PsiUtil.isLanguageLevel7OrHigher((PsiElement)variable) && !PsiDiamondTypeImpl.haveConstructorsGenericsParameters(aClass)) {
                    typeText = TypeConversionUtil.erasure((PsiType)type2).getCanonicalText(false) + "<>";
                }
                String expressionText = "new " + typeText + "()";
                PsiExpression initializer = elementFactory.createExpressionFromText(expressionText, (PsiElement)variable);
                String variableName2 = variable.getName();
                LOG.assertTrue(variableName2 != null);
                PsiDeclarationStatement statement = elementFactory.createVariableDeclarationStatement(variableName2, variable.getType(), initializer, (PsiElement)variable);
                ExpressionLookupItem newExpression = new ExpressionLookupItem(((PsiLocalVariable)statement.getDeclaredElements()[0]).getInitializer());
                result.add(newExpression);
            }
        }
        return result.toArray(LookupElement.EMPTY_ARRAY);
    }

    public boolean startInWriteAction() {
        return true;
    }
}

