/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.JavaPsiRecordUtil;
import com.intellij.util.ArrayUtil;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddParameterListFix
extends LocalQuickFixAndIntentionActionOnPsiElement {
    public AddParameterListFix(@NotNull PsiMethod method) {
        super((PsiElement)method);
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (!(startElement instanceof PsiMethod)) {
            return;
        }
        PsiMethod method = (PsiMethod)startElement;
        PsiIdentifier identifier = method.getNameIdentifier();
        if (identifier == null) {
            return;
        }
        method.addAfter((PsiElement)JavaPsiFacade.getElementFactory((Project)project).createParameterList(ArrayUtil.EMPTY_STRING_ARRAY, PsiType.EMPTY_ARRAY), (PsiElement)identifier);
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getText() {
        return this.getFamilyName();
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        return QuickFixBundle.message("insert.empty.parenthesis", new Object[0]);
    }

    public boolean isAvailable(@NotNull Project project, @NotNull PsiFile file, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        return super.isAvailable(project, file, editor, startElement, endElement) && startElement instanceof PsiMethod && JavaPsiRecordUtil.isCompactConstructor((PsiMethod)startElement);
    }
}

