/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.google.common.collect.Lists;
import com.intellij.codeInsight.ExceptionUtil;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pass;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.IntroduceTargetChooser;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.SmartList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddExceptionToExistingCatchFix
extends PsiElementBaseIntentionAction {
    private final PsiElement myErrorElement;

    public AddExceptionToExistingCatchFix(PsiElement errorElement) {
        this.myErrorElement = errorElement;
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (!FileModificationService.getInstance().preparePsiElementsForWrite(new PsiElement[]{this.myErrorElement})) {
            return;
        }
        Context context = Context.from(this.myErrorElement);
        if (context == null) {
            return;
        }
        final List unhandledExceptions = context.myExceptions;
        List catches = context.myCatches;
        if (catches.size() == 1) {
            PsiCatchSection selectedSection = (PsiCatchSection)catches.get(0);
            AddExceptionToExistingCatchFix.addTypeToCatch(unhandledExceptions, selectedSection);
        } else {
            IntroduceTargetChooser.showChooser((Editor)editor, (List)catches, (Pass)new Pass<PsiCatchSection>(){

                public void pass(PsiCatchSection section) {
                    AddExceptionToExistingCatchFix.addTypeToCatch(unhandledExceptions, section);
                }
            }, section -> Objects.requireNonNull(section.getCatchType()).getPresentableText(), (String)QuickFixBundle.message("add.exception.to.existing.catch.chooser.title", new Object[0]), catchSection -> Objects.requireNonNull(((PsiCatchSection)catchSection).getParameter()).getTextRange());
        }
    }

    private static List<PsiCatchSection> findSuitableSections(List<? extends PsiCatchSection> sections, @NotNull List<? extends PsiClassType> exceptionTypes, boolean isJava7OrHigher) {
        ArrayList<PsiCatchSection> finalSections = new ArrayList<PsiCatchSection>();
        for (PsiCatchSection section : Lists.reverse(sections)) {
            finalSections.add(section);
            PsiType sectionType = section.getCatchType();
            if (sectionType == null) continue;
            for (PsiType psiType : exceptionTypes) {
                if (!psiType.isAssignableFrom(sectionType)) continue;
                return finalSections;
            }
        }
        if (!isJava7OrHigher) {
            return Collections.emptyList();
        }
        return finalSections;
    }

    private static void addTypeToCatch(@NotNull List<? extends PsiClassType> exceptionsToAdd, @NotNull PsiCatchSection catchSection) {
        Project project = catchSection.getProject();
        WriteCommandAction.runWriteCommandAction((Project)project, (String)QuickFixBundle.message("add.exception.to.existing.catch.family", new Object[0]), null, () -> {
            if (!catchSection.isValid() || !exceptionsToAdd.stream().allMatch(type2 -> type2.isValid())) {
                return;
            }
            PsiParameter parameter2 = catchSection.getParameter();
            if (parameter2 == null) {
                return;
            }
            PsiTypeElement typeElement = parameter2.getTypeElement();
            if (typeElement == null) {
                return;
            }
            PsiType parameterType = parameter2.getType();
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
            String flattenText = AddExceptionToExistingCatchFix.getTypeText(exceptionsToAdd, parameter2, parameterType, factory);
            PsiElement newTypeElement = typeElement.replace((PsiElement)factory.createTypeElementFromText(flattenText, (PsiElement)parameter2));
            CodeStyleManager.getInstance((Project)project).reformat(JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences(newTypeElement));
        }, (PsiFile[])new PsiFile[0]);
    }

    private static String getTypeText(@NotNull List<? extends PsiClassType> exceptionsToAdd, PsiParameter parameter2, PsiType parameterType, PsiElementFactory factory) {
        String typeText = parameterType.getCanonicalText() + " | " + exceptionsToAdd.stream().map(type2 -> type2.getCanonicalText()).collect(Collectors.joining(" | "));
        PsiTypeElement element = factory.createTypeElementFromText(typeText, (PsiElement)parameter2);
        List flatten = PsiDisjunctionType.flattenAndRemoveDuplicates((List)((PsiDisjunctionType)element.getType()).getDisjunctions());
        return flatten.stream().map(type2 -> type2.getCanonicalText()).collect(Collectors.joining(" | "));
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        Context context = Context.from(this.myErrorElement);
        if (context != null) {
            this.setText(context.getMessage());
            return true;
        }
        return false;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        return QuickFixBundle.message("add.exception.to.existing.catch.family", new Object[0]);
    }

    private static boolean replacementNeeded(@NotNull PsiClassType newException, @NotNull PsiType catchType) {
        if (catchType instanceof PsiDisjunctionType) {
            PsiDisjunctionType disjunction = (PsiDisjunctionType)catchType;
            for (PsiType type2 : disjunction.getDisjunctions()) {
                if (!newException.isAssignableFrom(type2)) continue;
                return true;
            }
            return false;
        }
        return newException.isAssignableFrom(catchType);
    }

    public boolean startInWriteAction() {
        return false;
    }

    private static class Context {
        private final List<? extends PsiCatchSection> myCatches;
        private final List<? extends PsiClassType> myExceptions;

        private Context(List<? extends PsiCatchSection> catches, List<? extends PsiClassType> exceptions) {
            this.myCatches = catches;
            this.myExceptions = exceptions;
        }

        @Nullable
        static Context from(@NotNull PsiElement element) {
            if (!element.isValid() || element instanceof PsiMethodReferenceExpression) {
                return null;
            }
            boolean isJava7OrHigher = PsiUtil.isLanguageLevel7OrHigher((PsiElement)element);
            ArrayList<PsiClassType> unhandledExceptions = new ArrayList<PsiClassType>(ExceptionUtil.getOwnUnhandledExceptions(element));
            if (unhandledExceptions.isEmpty()) {
                return null;
            }
            List<PsiTryStatement> tryStatements = Context.getTryStatements(element);
            List sections = tryStatements.stream().flatMap(stmt -> AddExceptionToExistingCatchFix.findSuitableSections(Arrays.asList(stmt.getCatchSections()), unhandledExceptions, isJava7OrHigher).stream()).filter(catchSection -> {
                PsiParameter parameter2 = catchSection.getParameter();
                if (parameter2 == null) {
                    return false;
                }
                return parameter2.getTypeElement() != null;
            }).collect(Collectors.toList());
            if (sections.isEmpty()) {
                return null;
            }
            return new Context(sections, unhandledExceptions);
        }

        @NotNull
        private static List<PsiTryStatement> getTryStatements(@NotNull PsiElement element) {
            PsiElement current = element;
            SmartList parents = new SmartList();
            for (PsiElement parent = element.getParent(); !(parent == null || parent instanceof PsiLambdaExpression || parent instanceof PsiMember || parent instanceof PsiFile); parent = parent.getParent()) {
                PsiTryStatement tryStatement;
                if (parent instanceof PsiTryStatement && (tryStatement = (PsiTryStatement)parent).getFinallyBlock() != current && !(current instanceof PsiCatchSection)) {
                    parents.add((PsiTryStatement)parent);
                }
                current = parent;
            }
            return parents;
        }

        private String getMessage() {
            if (this.myCatches.size() == 1 && this.myExceptions.size() == 1) {
                PsiClassType exceptionType = this.myExceptions.get(0);
                PsiCatchSection catchSection = this.myCatches.get(0);
                PsiParameter parameter2 = catchSection.getParameter();
                assert (parameter2 != null);
                PsiType catchType = parameter2.getType();
                if (AddExceptionToExistingCatchFix.replacementNeeded(exceptionType, catchType)) {
                    return QuickFixBundle.message("add.exception.to.existing.catch.replacement", catchType.getPresentableText(), exceptionType.getPresentableText());
                }
                return QuickFixBundle.message("add.exception.to.existing.catch.no.replacement", catchType.getPresentableText(), exceptionType.getPresentableText());
            }
            return QuickFixBundle.message("add.exception.to.existing.catch.generic", new Object[0]);
        }
    }
}

