/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.codeInsight.daemon.impl.UnusedSymbolUtil;
import com.intellij.concurrency.JobLauncher;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.search.searches.DeepestSuperMethodsSearch;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;

public class JavaTelescope {
    private static final int TOO_MANY_USAGES = -1;

    public static String usagesHint(@NotNull PsiMember member, @NotNull PsiFile file) {
        List<Object> things;
        Project project = file.getProject();
        AtomicInteger totalUsageCount = new AtomicInteger();
        ProgressIndicator progress = (ProgressIndicator)ObjectUtils.notNull((Object)ProgressIndicatorProvider.getGlobalProgressIndicator(), (Object)new EmptyProgressIndicator());
        List<Object> list = things = member instanceof PsiMethod ? new ArrayList(DeepestSuperMethodsSearch.search((PsiMethod)((PsiMethod)member)).findAll()) : Collections.singletonList(member);
        if (things.isEmpty()) {
            things.add(member);
        }
        JobLauncher.getInstance().invokeConcurrentlyUnderProgress(things, progress, e -> {
            int count = JavaTelescope.usagesCount(project, file, e, progress);
            int newCount = totalUsageCount.updateAndGet(old -> count == -1 ? -1 : old + count);
            return newCount != -1;
        });
        if (totalUsageCount.get() == -1 || totalUsageCount.get() == 0) {
            return null;
        }
        String format = "{0,choice, 0#no usages|1#1 usage|2#{0,number} usages}";
        return MessageFormat.format(format, totalUsageCount.get());
    }

    private static int usagesCount(@NotNull Project project, @NotNull PsiFile containingFile, @NotNull PsiMember member, @NotNull ProgressIndicator progress) {
        AtomicInteger count = new AtomicInteger();
        boolean ok = UnusedSymbolUtil.processUsages(project, containingFile, member, progress, null, (Processor<? super UsageInfo>)((Processor)info -> {
            PsiFile psiFile = info.getFile();
            if (psiFile == null) {
                return true;
            }
            int offset = info.getNavigationOffset();
            if (offset == -1) {
                return true;
            }
            count.incrementAndGet();
            return true;
        }));
        if (!ok) {
            return -1;
        }
        return count.get();
    }

    public static int collectInheritingClasses(@NotNull PsiClass aClass) {
        if (aClass.hasModifierProperty("final")) {
            return 0;
        }
        if ("java.lang.Object".equals(aClass.getQualifiedName())) {
            return 0;
        }
        AtomicInteger count = new AtomicInteger();
        ClassInheritorsSearch.INSTANCE.createQuery((Object)new ClassInheritorsSearch.SearchParameters(aClass, aClass.getUseScope(), true, true, true)).forEach(__ -> count.incrementAndGet());
        return count.get();
    }

    public static int collectOverridingMethods(@NotNull PsiMethod method) {
        AtomicInteger count = new AtomicInteger();
        OverridingMethodsSearch.search((PsiMethod)method).forEach(__ -> count.incrementAndGet());
        return count.get();
    }
}

