/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.codeInsight.ExceptionUtil;
import com.intellij.codeInsight.daemon.JavaErrorBundle;
import com.intellij.codeInsight.daemon.QuickFixActionRegistrar;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.analysis.GenericsHighlightUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightClassUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightControlFlowUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightFixUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightInfoHolder;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightMessageUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightNamesUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightingFeature;
import com.intellij.codeInsight.daemon.impl.analysis.JavaGenericsUtil;
import com.intellij.codeInsight.daemon.impl.analysis.JavaHighlightUtil;
import com.intellij.codeInsight.daemon.impl.analysis.RefCountHolder;
import com.intellij.codeInsight.daemon.impl.quickfix.AddTypeArgumentsFix;
import com.intellij.codeInsight.daemon.impl.quickfix.CastMethodArgumentFix;
import com.intellij.codeInsight.daemon.impl.quickfix.ChangeStringLiteralToCharInMethodCallFix;
import com.intellij.codeInsight.daemon.impl.quickfix.ChangeTypeArgumentsFix;
import com.intellij.codeInsight.daemon.impl.quickfix.ConstructorParametersFixer;
import com.intellij.codeInsight.daemon.impl.quickfix.ConvertDoubleToFloatFix;
import com.intellij.codeInsight.daemon.impl.quickfix.MethodReturnFixFactory;
import com.intellij.codeInsight.daemon.impl.quickfix.PermuteArgumentsFix;
import com.intellij.codeInsight.daemon.impl.quickfix.QualifySuperArgumentFix;
import com.intellij.codeInsight.daemon.impl.quickfix.QualifyThisArgumentFix;
import com.intellij.codeInsight.daemon.impl.quickfix.QuickFixAction;
import com.intellij.codeInsight.daemon.impl.quickfix.QuickFixActionRegistrarImpl;
import com.intellij.codeInsight.daemon.impl.quickfix.RemoveRedundantArgumentsFix;
import com.intellij.codeInsight.daemon.impl.quickfix.WrapExpressionFix;
import com.intellij.codeInsight.daemon.impl.quickfix.WrapObjectWithOptionalOfNullableFix;
import com.intellij.codeInsight.daemon.impl.quickfix.WrapWithAdapterMethodCallFix;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.QuickFixFactory;
import com.intellij.codeInsight.intention.impl.PriorityIntentionActionWrapper;
import com.intellij.codeInsight.quickfix.UnresolvedReferenceQuickFixProvider;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.codeInspection.LocalQuickFixOnPsiElementAsIntentionAdapter;
import com.intellij.lang.jvm.JvmModifier;
import com.intellij.lang.jvm.JvmModifiersOwner;
import com.intellij.lang.jvm.actions.ChangeModifierRequest;
import com.intellij.lang.jvm.actions.JvmElementActionFactories;
import com.intellij.lang.jvm.actions.MemberRequestsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.colors.EditorColorsUtil;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.ExternallyDefinedPsiElement;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.HierarchicalMethodSignature;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiConstantEvaluationHelper;
import com.intellij.psi.PsiConstructorCall;
import com.intellij.psi.PsiDiamondType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJvmMember;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiRecordComponent;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.PsiSuperMethodImplUtil;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceSession;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.AccessModifier;
import com.intellij.psi.util.JavaPsiRecordUtil;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureBackedByPsiMethod;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.util.RefactoringChangeUtil;
import com.intellij.ui.ColorUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.JavaPsiConstructorUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.VisibilityUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MostlySingularMultiMap;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.xml.util.XmlStringUtil;
import com.siyeh.ig.psiutils.ExpressionUtils;
import java.awt.Color;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HighlightMethodUtil {
    private static final QuickFixFactory QUICK_FIX_FACTORY = QuickFixFactory.getInstance();
    private static final Logger LOG = Logger.getInstance(HighlightMethodUtil.class);

    private HighlightMethodUtil() {
    }

    @NotNull
    static String createClashMethodMessage(@NotNull PsiMethod method1, @NotNull PsiMethod method2, boolean showContainingClasses) {
        if (showContainingClasses) {
            PsiClass class1 = method1.getContainingClass();
            PsiClass class2 = method2.getContainingClass();
            if (class1 != null && class2 != null) {
                return JavaErrorBundle.message("clash.methods.message.show.classes", JavaHighlightUtil.formatMethod(method1), JavaHighlightUtil.formatMethod(method2), HighlightUtil.formatClass(class1), HighlightUtil.formatClass(class2));
            }
        }
        return JavaErrorBundle.message("clash.methods.message", JavaHighlightUtil.formatMethod(method1), JavaHighlightUtil.formatMethod(method2));
    }

    static HighlightInfo checkMethodWeakerPrivileges(@NotNull MethodSignatureBackedByPsiMethod methodSignature, @NotNull List<? extends HierarchicalMethodSignature> superMethodSignatures, boolean includeRealPositionInfo, @NotNull PsiFile containingFile) {
        PsiMethod method = methodSignature.getMethod();
        PsiModifierList modifierList = method.getModifierList();
        if (modifierList.hasModifierProperty("public")) {
            return null;
        }
        int accessLevel = PsiUtil.getAccessLevel((PsiModifierList)modifierList);
        String accessModifier = PsiUtil.getAccessModifier((int)accessLevel);
        for (MethodSignatureBackedByPsiMethod methodSignatureBackedByPsiMethod : superMethodSignatures) {
            HighlightInfo info;
            PsiMethod superMethod = methodSignatureBackedByPsiMethod.getMethod();
            if (method.hasModifierProperty("abstract") && !MethodSignatureUtil.isSuperMethod((PsiMethod)superMethod, (PsiMethod)method) || !PsiUtil.isAccessible((Project)containingFile.getProject(), (PsiMember)superMethod, (PsiElement)method, null) || !includeRealPositionInfo && MethodSignatureUtil.isSuperMethod((PsiMethod)superMethod, (PsiMethod)method) || (info = HighlightMethodUtil.isWeaker(method, modifierList, accessModifier, accessLevel, superMethod, includeRealPositionInfo)) == null) continue;
            return info;
        }
        return null;
    }

    private static HighlightInfo isWeaker(@NotNull PsiMethod method, @NotNull PsiModifierList modifierList, @NotNull String accessModifier, int accessLevel, @NotNull PsiMethod superMethod, boolean includeRealPositionInfo) {
        int superAccessLevel = PsiUtil.getAccessLevel((PsiModifierList)superMethod.getModifierList());
        if (accessLevel < superAccessLevel) {
            String description = JavaErrorBundle.message("weaker.privileges", HighlightMethodUtil.createClashMethodMessage(method, superMethod, true), VisibilityUtil.toPresentableText((String)accessModifier), PsiUtil.getAccessModifier((int)superAccessLevel));
            TextRange textRange = TextRange.EMPTY_RANGE;
            if (includeRealPositionInfo) {
                PsiElement keyword = PsiUtil.findModifierInList((PsiModifierList)modifierList, (String)accessModifier);
                if (keyword != null) {
                    textRange = keyword.getTextRange();
                } else {
                    PsiIdentifier identifier = method.getNameIdentifier();
                    if (identifier != null) {
                        textRange = identifier.getTextRange();
                    }
                }
            }
            HighlightInfo info = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range(textRange).descriptionAndTooltip(description).create();
            QuickFixAction.registerQuickFixAction((HighlightInfo)info, null, (IntentionAction)QUICK_FIX_FACTORY.createChangeModifierFix());
            return info;
        }
        return null;
    }

    static HighlightInfo checkMethodIncompatibleReturnType(@NotNull MethodSignatureBackedByPsiMethod methodSignature, @NotNull List<? extends HierarchicalMethodSignature> superMethodSignatures, boolean includeRealPositionInfo) {
        return HighlightMethodUtil.checkMethodIncompatibleReturnType(methodSignature, superMethodSignatures, includeRealPositionInfo, null);
    }

    static HighlightInfo checkMethodIncompatibleReturnType(@NotNull MethodSignatureBackedByPsiMethod methodSignature, @NotNull List<? extends HierarchicalMethodSignature> superMethodSignatures, boolean includeRealPositionInfo, @Nullable TextRange textRange) {
        PsiMethod method = methodSignature.getMethod();
        PsiType returnType = methodSignature.getSubstitutor().substitute(method.getReturnType());
        PsiClass aClass = method.getContainingClass();
        if (aClass == null) {
            return null;
        }
        for (MethodSignatureBackedByPsiMethod methodSignatureBackedByPsiMethod : superMethodSignatures) {
            HighlightInfo info;
            PsiTypeElement typeElement;
            PsiClass superClass;
            PsiType declaredReturnType;
            PsiMethod superMethod = methodSignatureBackedByPsiMethod.getMethod();
            PsiType superReturnType = declaredReturnType = superMethod.getReturnType();
            if (methodSignatureBackedByPsiMethod.isRaw()) {
                superReturnType = TypeConversionUtil.erasure((PsiType)declaredReturnType);
            }
            if (returnType == null || superReturnType == null || method == superMethod || (superClass = superMethod.getContainingClass()) == null) continue;
            if (textRange == null && includeRealPositionInfo && (typeElement = method.getReturnTypeElement()) != null) {
                textRange = typeElement.getTextRange();
            }
            if (textRange == null) {
                textRange = TextRange.EMPTY_RANGE;
            }
            if ((info = HighlightMethodUtil.checkSuperMethodSignature(superMethod, methodSignatureBackedByPsiMethod, superReturnType, method, methodSignature, returnType, JavaErrorBundle.message("incompatible.return.type", new Object[0]), textRange, PsiUtil.getLanguageLevel((PsiElement)aClass))) == null) continue;
            return info;
        }
        return null;
    }

    private static HighlightInfo checkSuperMethodSignature(@NotNull PsiMethod superMethod, @NotNull MethodSignatureBackedByPsiMethod superMethodSignature, @NotNull PsiType superReturnType, @NotNull PsiMethod method, @NotNull MethodSignatureBackedByPsiMethod methodSignature, @NotNull PsiType returnType, @NotNull String detailMessage, @NotNull TextRange range, @NotNull LanguageLevel languageLevel) {
        PsiSubstitutor unifyingSubstitutor;
        PsiClass containingClass;
        PsiClass superContainingClass = superMethod.getContainingClass();
        if (superContainingClass != null && "java.lang.Object".equals(superContainingClass.getQualifiedName()) && !superMethod.hasModifierProperty("public") && (containingClass = method.getContainingClass()) != null && containingClass.isInterface() && !superContainingClass.isInterface()) {
            return null;
        }
        boolean isJdk15 = languageLevel.isAtLeast(LanguageLevel.JDK_1_5);
        PsiType substitutedSuperReturnType = isJdk15 && !superMethodSignature.isRaw() && superMethodSignature.equals((Object)methodSignature) ? ((unifyingSubstitutor = MethodSignatureUtil.getSuperMethodSignatureSubstitutor((MethodSignature)methodSignature, (MethodSignature)superMethodSignature)) == null ? superReturnType : unifyingSubstitutor.substitute(superReturnType)) : TypeConversionUtil.erasure((PsiType)superMethodSignature.getSubstitutor().substitute(superReturnType));
        if (returnType.equals(substitutedSuperReturnType)) {
            return null;
        }
        if (!(returnType instanceof PsiPrimitiveType) && substitutedSuperReturnType.getDeepComponentType() instanceof PsiClassType && isJdk15 && ((Boolean)LambdaUtil.performWithSubstitutedParameterBounds((PsiTypeParameter[])methodSignature.getTypeParameters(), (PsiSubstitutor)methodSignature.getSubstitutor(), () -> TypeConversionUtil.isAssignable((PsiType)substitutedSuperReturnType, (PsiType)returnType))).booleanValue()) {
            return null;
        }
        return HighlightMethodUtil.createIncompatibleReturnTypeMessage(method, superMethod, substitutedSuperReturnType, returnType, detailMessage, range);
    }

    private static HighlightInfo createIncompatibleReturnTypeMessage(@NotNull PsiMethod method, @NotNull PsiMethod superMethod, @NotNull PsiType substitutedSuperReturnType, @NotNull PsiType returnType, @NotNull String detailMessage, @NotNull TextRange textRange) {
        String description = MessageFormat.format("{0}; {1}", HighlightMethodUtil.createClashMethodMessage(method, superMethod, true), detailMessage);
        HighlightInfo errorResult = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range(textRange).descriptionAndTooltip(description).create();
        QuickFixAction.registerQuickFixAction((HighlightInfo)errorResult, (IntentionAction)QUICK_FIX_FACTORY.createMethodReturnFix(method, substitutedSuperReturnType, false));
        QuickFixAction.registerQuickFixAction((HighlightInfo)errorResult, (IntentionAction)QUICK_FIX_FACTORY.createSuperMethodReturnFix(superMethod, returnType));
        PsiClass returnClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)returnType);
        if (returnClass != null && substitutedSuperReturnType instanceof PsiClassType) {
            QuickFixAction.registerQuickFixAction((HighlightInfo)errorResult, (IntentionAction)QUICK_FIX_FACTORY.createChangeParameterClassFix(returnClass, (PsiClassType)substitutedSuperReturnType));
        }
        return errorResult;
    }

    static HighlightInfo checkMethodOverridesFinal(@NotNull MethodSignatureBackedByPsiMethod methodSignature, @NotNull List<? extends HierarchicalMethodSignature> superMethodSignatures) {
        PsiMethod method = methodSignature.getMethod();
        for (MethodSignatureBackedByPsiMethod methodSignatureBackedByPsiMethod : superMethodSignatures) {
            PsiMethod superMethod = methodSignatureBackedByPsiMethod.getMethod();
            HighlightInfo info = HighlightMethodUtil.checkSuperMethodIsFinal(method, superMethod);
            if (info == null) continue;
            return info;
        }
        return null;
    }

    private static HighlightInfo checkSuperMethodIsFinal(@NotNull PsiMethod method, @NotNull PsiMethod superMethod) {
        if (superMethod.hasModifierProperty("final")) {
            PsiClass superClass = superMethod.getContainingClass();
            String description = JavaErrorBundle.message("final.method.override", JavaHighlightUtil.formatMethod(method), JavaHighlightUtil.formatMethod(superMethod), superClass != null ? HighlightUtil.formatClass(superClass) : "<unknown>");
            TextRange textRange = HighlightNamesUtil.getMethodDeclarationTextRange(method);
            HighlightInfo errorResult = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range(textRange).descriptionAndTooltip(description).create();
            QuickFixAction.registerQuickFixActions((HighlightInfo)errorResult, null, (Iterable)JvmElementActionFactories.createModifierActions((JvmModifiersOwner)superMethod, (ChangeModifierRequest)MemberRequestsKt.modifierRequest((JvmModifier)JvmModifier.FINAL, (boolean)false)));
            return errorResult;
        }
        return null;
    }

    static HighlightInfo checkMethodIncompatibleThrows(@NotNull MethodSignatureBackedByPsiMethod methodSignature, @NotNull List<? extends HierarchicalMethodSignature> superMethodSignatures, boolean includeRealPositionInfo, @NotNull PsiClass analyzedClass) {
        PsiJavaCodeReferenceElement[] referenceElements;
        ArrayList<PsiJavaCodeReferenceElement> exceptionContexts;
        PsiMethod method = methodSignature.getMethod();
        PsiClass aClass = method.getContainingClass();
        if (aClass == null) {
            return null;
        }
        PsiSubstitutor superSubstitutor = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)aClass, (PsiClass)analyzedClass, (PsiSubstitutor)PsiSubstitutor.EMPTY);
        PsiClassType[] exceptions = method.getThrowsList().getReferencedTypes();
        if (includeRealPositionInfo) {
            exceptionContexts = new ArrayList<PsiJavaCodeReferenceElement>();
            referenceElements = method.getThrowsList().getReferenceElements();
        } else {
            exceptionContexts = null;
            referenceElements = null;
        }
        ArrayList<PsiClassType> checkedExceptions = new ArrayList<PsiClassType>();
        for (int i = 0; i < exceptions.length; ++i) {
            PsiClassType psiClassType = exceptions[i];
            if (psiClassType == null) {
                LOG.error("throws: " + method.getThrowsList().getText() + "; method: " + method);
                continue;
            }
            if (ExceptionUtil.isUncheckedException(psiClassType)) continue;
            checkedExceptions.add(psiClassType);
            if (!includeRealPositionInfo || i >= referenceElements.length) continue;
            PsiJavaCodeReferenceElement exceptionRef = referenceElements[i];
            exceptionContexts.add(exceptionRef);
        }
        for (MethodSignatureBackedByPsiMethod methodSignatureBackedByPsiMethod : superMethodSignatures) {
            TextRange textRange;
            PsiClass superContainingClass;
            PsiMethod superMethod = methodSignatureBackedByPsiMethod.getMethod();
            int index = HighlightMethodUtil.getExtraExceptionNum((MethodSignature)methodSignature, methodSignatureBackedByPsiMethod, checkedExceptions, superSubstitutor);
            if (index == -1 || aClass.isInterface() && ((superContainingClass = superMethod.getContainingClass()) != null && !superContainingClass.isInterface() || superContainingClass != null && !aClass.isInheritor(superContainingClass, true))) continue;
            PsiClassType exception = (PsiClassType)checkedExceptions.get(index);
            String description = JavaErrorBundle.message("overridden.method.does.not.throw", HighlightMethodUtil.createClashMethodMessage(method, superMethod, true), JavaHighlightUtil.formatType((PsiType)exception));
            if (includeRealPositionInfo) {
                PsiElement exceptionContext = (PsiElement)exceptionContexts.get(index);
                textRange = exceptionContext.getTextRange();
            } else {
                textRange = TextRange.EMPTY_RANGE;
            }
            HighlightInfo errorResult = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range(textRange).descriptionAndTooltip(description).create();
            QuickFixAction.registerQuickFixAction((HighlightInfo)errorResult, (IntentionAction)new LocalQuickFixOnPsiElementAsIntentionAdapter(QUICK_FIX_FACTORY.createMethodThrowsFix(method, exception, false, false)));
            QuickFixAction.registerQuickFixAction((HighlightInfo)errorResult, (IntentionAction)new LocalQuickFixOnPsiElementAsIntentionAdapter(QUICK_FIX_FACTORY.createMethodThrowsFix(superMethod, exception, true, true)));
            return errorResult;
        }
        return null;
    }

    private static int getExtraExceptionNum(@NotNull MethodSignature methodSignature, @NotNull MethodSignatureBackedByPsiMethod superSignature, @NotNull List<? extends PsiClassType> checkedExceptions, @NotNull PsiSubstitutor substitutorForDerivedClass) {
        PsiMethod superMethod = superSignature.getMethod();
        PsiSubstitutor substitutorForMethod = MethodSignatureUtil.getSuperMethodSignatureSubstitutor((MethodSignature)methodSignature, (MethodSignature)superSignature);
        for (int i = 0; i < checkedExceptions.size(); ++i) {
            PsiClassType checkedEx = checkedExceptions.get(i);
            PsiType substituted = substitutorForMethod == null ? TypeConversionUtil.erasure((PsiType)checkedEx) : substitutorForMethod.substitute((PsiType)checkedEx);
            PsiType exception = substitutorForDerivedClass.substitute(substituted);
            if (HighlightMethodUtil.isMethodThrows(superMethod, substitutorForMethod, exception, substitutorForDerivedClass)) continue;
            return i;
        }
        return -1;
    }

    private static boolean isMethodThrows(@NotNull PsiMethod method, @Nullable PsiSubstitutor substitutorForMethod, PsiType exception, @NotNull PsiSubstitutor substitutorForDerivedClass) {
        PsiClassType[] thrownExceptions;
        for (PsiClassType thrownException1 : thrownExceptions = method.getThrowsList().getReferencedTypes()) {
            PsiType thrownException = substitutorForMethod != null ? substitutorForMethod.substitute((PsiType)thrownException1) : TypeConversionUtil.erasure((PsiType)thrownException1);
            if (!TypeConversionUtil.isAssignable((PsiType)(thrownException = substitutorForDerivedClass.substitute(thrownException)), (PsiType)exception)) continue;
            return true;
        }
        return false;
    }

    static void checkMethodCall(@NotNull PsiMethodCallExpression methodCall, @NotNull PsiResolveHelper resolveHelper, @NotNull LanguageLevel languageLevel, @NotNull JavaSdkVersion javaSdkVersion, @NotNull PsiFile file, HighlightInfoHolder holder) {
        HighlightInfo highlightInfo;
        PsiExpressionList list = methodCall.getArgumentList();
        PsiReferenceExpression referenceToMethod = methodCall.getMethodExpression();
        JavaResolveResult[] results = referenceToMethod.multiResolve(true);
        JavaResolveResult resolveResult = results.length == 1 ? results[0] : JavaResolveResult.EMPTY;
        PsiElement resolved = resolveResult.getElement();
        boolean isDummy = HighlightMethodUtil.isDummyConstructorCall(methodCall, resolveHelper, list, referenceToMethod);
        if (isDummy) {
            return;
        }
        PsiSubstitutor substitutor = resolveResult.getSubstitutor();
        if (resolved instanceof PsiMethod && resolveResult.isValidResult()) {
            PsiElement element;
            PsiClass containingClass;
            PsiElement nameElement = referenceToMethod.getReferenceNameElement();
            TextRange fixRange = HighlightMethodUtil.getFixRange((PsiElement)methodCall);
            highlightInfo = HighlightUtil.checkUnhandledExceptions((PsiElement)methodCall, nameElement != null ? nameElement.getTextRange() : fixRange);
            if (highlightInfo == null && ((PsiMethod)resolved).hasModifierProperty("static") && (containingClass = ((PsiMethod)resolved).getContainingClass()) != null && containingClass.isInterface() && (highlightInfo = HighlightUtil.checkFeature(element = (PsiElement)ObjectUtils.notNull((Object)referenceToMethod.getReferenceNameElement(), (Object)referenceToMethod), HighlightingFeature.STATIC_INTERFACE_CALLS, languageLevel, file)) == null) {
                highlightInfo = HighlightMethodUtil.checkStaticInterfaceCallQualifier(referenceToMethod, resolveResult, fixRange, containingClass);
            }
            if (highlightInfo == null) {
                highlightInfo = GenericsHighlightUtil.checkInferredIntersections(substitutor, fixRange);
            }
            if (highlightInfo == null) {
                highlightInfo = HighlightMethodUtil.checkVarargParameterErasureToBeAccessible((MethodCandidateInfo)resolveResult, (PsiCall)methodCall);
            }
            if (highlightInfo == null) {
                highlightInfo = HighlightMethodUtil.createIncompatibleTypeHighlightInfo((PsiCallExpression)methodCall, resolveHelper, (MethodCandidateInfo)resolveResult, fixRange);
            }
        } else {
            PsiMethod resolvedMethod = null;
            MethodCandidateInfo candidateInfo = null;
            if (resolveResult instanceof MethodCandidateInfo) {
                candidateInfo = (MethodCandidateInfo)resolveResult;
                resolvedMethod = candidateInfo.getElement();
            }
            if (!resolveResult.isAccessible() || !resolveResult.isStaticsScopeCorrect()) {
                highlightInfo = null;
            } else if (candidateInfo != null && !candidateInfo.isApplicable()) {
                if (candidateInfo.isTypeArgumentsApplicable()) {
                    highlightInfo = HighlightMethodUtil.createIncompatibleCallHighlightInfo(holder, list, candidateInfo);
                    if (highlightInfo != null) {
                        HighlightMethodUtil.registerMethodCallIntentions(highlightInfo, methodCall, list, resolveHelper);
                        HighlightMethodUtil.registerMethodReturnFixAction(highlightInfo, candidateInfo, (PsiCall)methodCall);
                        HighlightMethodUtil.registerTargetTypeFixesBasedOnApplicabilityInference(methodCall, candidateInfo, resolvedMethod, highlightInfo);
                        holder.add(highlightInfo);
                        return;
                    }
                } else {
                    PsiReferenceParameterList typeArgumentList = methodCall.getTypeArgumentList();
                    PsiSubstitutor applicabilitySubstitutor = candidateInfo.getSubstitutor(false);
                    highlightInfo = typeArgumentList.getTypeArguments().length == 0 && resolvedMethod.hasTypeParameters() ? GenericsHighlightUtil.checkInferredTypeArguments((PsiTypeParameterListOwner)resolvedMethod, (PsiElement)methodCall, applicabilitySubstitutor) : GenericsHighlightUtil.checkParameterizedReferenceTypeArguments(resolved, (PsiJavaCodeReferenceElement)referenceToMethod, applicabilitySubstitutor, javaSdkVersion);
                }
            } else {
                String description = JavaErrorBundle.message("method.call.expected", new Object[0]);
                highlightInfo = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)methodCall).descriptionAndTooltip(description).create();
                if (resolved instanceof PsiClass) {
                    QuickFixAction.registerQuickFixAction((HighlightInfo)highlightInfo, (IntentionAction)QUICK_FIX_FACTORY.createInsertNewFix(methodCall, (PsiClass)resolved));
                } else {
                    PsiMethod method;
                    TextRange range = HighlightMethodUtil.getFixRange((PsiElement)methodCall);
                    HighlightMethodUtil.registerUsageFixes(methodCall, highlightInfo, range);
                    HighlightMethodUtil.registerStaticMethodQualifierFixes(methodCall, highlightInfo);
                    if (resolved instanceof PsiVariable && languageLevel.isAtLeast(LanguageLevel.JDK_1_8) && (method = LambdaUtil.getFunctionalInterfaceMethod((PsiType)((PsiVariable)resolved).getType())) != null) {
                        QuickFixAction.registerQuickFixAction((HighlightInfo)highlightInfo, (TextRange)range, (IntentionAction)QUICK_FIX_FACTORY.createInsertMethodCallFix(methodCall, method));
                    }
                }
            }
        }
        if (highlightInfo == null) {
            highlightInfo = GenericsHighlightUtil.checkParameterizedReferenceTypeArguments(resolved, (PsiJavaCodeReferenceElement)referenceToMethod, substitutor, javaSdkVersion);
        }
        holder.add(highlightInfo);
    }

    private static void registerStaticMethodQualifierFixes(@NotNull PsiMethodCallExpression methodCall, HighlightInfo highlightInfo) {
        TextRange methodExpressionRange = methodCall.getMethodExpression().getTextRange();
        QuickFixAction.registerQuickFixAction((HighlightInfo)highlightInfo, (TextRange)methodExpressionRange, (IntentionAction)QUICK_FIX_FACTORY.createStaticImportMethodFix(methodCall));
        QuickFixAction.registerQuickFixAction((HighlightInfo)highlightInfo, (TextRange)methodExpressionRange, (IntentionAction)QUICK_FIX_FACTORY.createQualifyStaticMethodCallFix(methodCall));
        QuickFixAction.registerQuickFixAction((HighlightInfo)highlightInfo, (TextRange)methodExpressionRange, (IntentionAction)QUICK_FIX_FACTORY.addMethodQualifierFix(methodCall));
    }

    private static HighlightInfo createIncompatibleCallHighlightInfo(HighlightInfoHolder holder, PsiExpressionList list, @NotNull MethodCandidateInfo candidateInfo) {
        List<Object> mismatchedExpressions;
        PsiMethod resolvedMethod = candidateInfo.getElement();
        PsiSubstitutor substitutor = candidateInfo.getSubstitutor();
        String methodName = HighlightMessageUtil.getSymbolName((PsiElement)resolvedMethod, substitutor);
        PsiClass parent = resolvedMethod.getContainingClass();
        String containerName = parent == null ? "" : HighlightMessageUtil.getSymbolName((PsiElement)parent, substitutor);
        String argTypes = HighlightMethodUtil.buildArgTypesList(list);
        String description = JavaErrorBundle.message("wrong.method.arguments", methodName, containerName, argTypes);
        String toolTip = null;
        if (parent != null) {
            PsiParameter[] parameters2;
            PsiExpression[] expressions2 = list.getExpressions();
            mismatchedExpressions = HighlightMethodUtil.mismatchedArgs(expressions2, substitutor, parameters2 = resolvedMethod.getParameterList().getParameters(), candidateInfo.isVarargs());
            if (mismatchedExpressions.size() == 1) {
                toolTip = HighlightMethodUtil.createOneArgMismatchTooltip(candidateInfo, mismatchedExpressions, expressions2, parameters2);
            }
            if (toolTip == null) {
                toolTip = HighlightMethodUtil.createMismatchedArgumentsHtmlTooltip(candidateInfo, list);
            }
        } else {
            mismatchedExpressions = Collections.emptyList();
            toolTip = description;
        }
        if (mismatchedExpressions.size() == list.getExpressions().length || mismatchedExpressions.isEmpty()) {
            return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)list).description(description).escapedToolTip(toolTip).navigationShift(1).create();
        }
        HighlightInfo highlightInfo = null;
        for (PsiExpression psiExpression : mismatchedExpressions) {
            HighlightInfo info = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)psiExpression).description(description).escapedToolTip(toolTip).create();
            if (highlightInfo == null) {
                highlightInfo = info;
                continue;
            }
            holder.add(info);
        }
        return highlightInfo;
    }

    private static String createOneArgMismatchTooltip(MethodCandidateInfo candidateInfo, @NotNull List<? extends PsiExpression> mismatchedExpressions, PsiExpression[] expressions2, PsiParameter[] parameters2) {
        PsiExpression wrongArg = mismatchedExpressions.get(0);
        PsiType argType = wrongArg.getType();
        if (argType != null) {
            boolean varargs = candidateInfo.getApplicabilityLevel() == 2;
            int idx = ArrayUtil.find((Object[])expressions2, (Object)wrongArg);
            PsiType paramType = candidateInfo.getSubstitutor().substitute(PsiTypesUtil.getParameterType((PsiParameter[])parameters2, (int)idx, (boolean)varargs));
            String errorMessage = candidateInfo.getInferenceErrorMessage();
            String reason = errorMessage != null ? "<table><tr><td style='padding-left: 4px; padding-top: 10;'>reason: " + XmlStringUtil.escapeString((String)errorMessage).replaceAll("\n", "<br/>") + "</td></tr></table>" : "";
            return HighlightUtil.createIncompatibleTypesTooltip(paramType, argType, (lRawType, lTypeArguments, rRawType, rTypeArguments) -> JavaErrorBundle.message("incompatible.types.html.tooltip", lRawType, lTypeArguments, rRawType, rTypeArguments, reason, "#" + ColorUtil.toHex((Color)UIUtil.getContextHelpForeground())));
        }
        return null;
    }

    static HighlightInfo createIncompatibleTypeHighlightInfo(@NotNull PsiCallExpression methodCall, @NotNull PsiResolveHelper resolveHelper, @NotNull MethodCandidateInfo resolveResult, TextRange fixRange) {
        String errorMessage = resolveResult.getInferenceErrorMessage();
        if (errorMessage == null) {
            return null;
        }
        PsiMethod method = resolveResult.getElement();
        PsiType expectedTypeByParent = InferenceSession.getTargetTypeByParent((PsiElement)methodCall);
        PsiType actualType = resolveResult.getSubstitutor(false).substitute(method.getReturnType());
        HighlightInfo highlightInfo = expectedTypeByParent != null && actualType != null && !expectedTypeByParent.isAssignableFrom(actualType) ? HighlightUtil.createIncompatibleTypeHighlightInfo(expectedTypeByParent, actualType, fixRange, 0, XmlStringUtil.escapeString((String)errorMessage)) : HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).descriptionAndTooltip(errorMessage).range(fixRange).create();
        if (highlightInfo != null && methodCall instanceof PsiMethodCallExpression) {
            HighlightMethodUtil.registerMethodCallIntentions(highlightInfo, (PsiMethodCallExpression)methodCall, ((PsiMethodCallExpression)methodCall).getArgumentList(), resolveHelper);
            HighlightMethodUtil.registerMethodReturnFixAction(highlightInfo, resolveResult, (PsiCall)methodCall);
            HighlightMethodUtil.registerTargetTypeFixesBasedOnApplicabilityInference((PsiMethodCallExpression)methodCall, resolveResult, method, highlightInfo);
        }
        return highlightInfo;
    }

    private static void registerUsageFixes(@NotNull PsiMethodCallExpression methodCall, @Nullable HighlightInfo highlightInfo, @NotNull TextRange range) {
        for (IntentionAction action : QUICK_FIX_FACTORY.createCreateMethodFromUsageFixes(methodCall)) {
            QuickFixAction.registerQuickFixAction((HighlightInfo)highlightInfo, (TextRange)range, (IntentionAction)action);
        }
    }

    private static void registerThisSuperFixes(@NotNull PsiMethodCallExpression methodCall, @Nullable HighlightInfo highlightInfo, @NotNull TextRange range) {
        for (IntentionAction action : QUICK_FIX_FACTORY.createCreateConstructorFromCallExpressionFixes(methodCall)) {
            QuickFixAction.registerQuickFixAction((HighlightInfo)highlightInfo, (TextRange)range, (IntentionAction)action);
        }
    }

    private static void registerTargetTypeFixesBasedOnApplicabilityInference(@NotNull PsiMethodCallExpression methodCall, @NotNull MethodCandidateInfo resolveResult, @NotNull PsiMethod resolved, HighlightInfo highlightInfo) {
        PsiType expectedTypeByApplicabilityConstraints;
        PsiType rType;
        PsiElement resolve2;
        PsiExpression lExpression;
        PsiElement parent = PsiUtil.skipParenthesizedExprUp((PsiElement)methodCall.getParent());
        PsiVariable variable = null;
        if (parent instanceof PsiVariable) {
            variable = (PsiVariable)parent;
        } else if (parent instanceof PsiAssignmentExpression && (lExpression = ((PsiAssignmentExpression)parent).getLExpression()) instanceof PsiReferenceExpression && (resolve2 = ((PsiReferenceExpression)lExpression).resolve()) instanceof PsiVariable) {
            variable = (PsiVariable)resolve2;
        }
        if (variable != null && (rType = methodCall.getType()) != null && !variable.getType().isAssignableFrom(rType) && (expectedTypeByApplicabilityConstraints = resolveResult.getSubstitutor(false).substitute(resolved.getReturnType())) != null && !variable.getType().isAssignableFrom(expectedTypeByApplicabilityConstraints) && PsiTypesUtil.allTypeParametersResolved((PsiElement)variable, (PsiType)expectedTypeByApplicabilityConstraints)) {
            HighlightFixUtil.registerChangeVariableTypeFixes(variable, expectedTypeByApplicabilityConstraints, (PsiExpression)methodCall, highlightInfo);
        }
    }

    static HighlightInfo checkStaticInterfaceCallQualifier(@NotNull PsiReferenceExpression referenceToMethod, @NotNull JavaResolveResult resolveResult, @NotNull TextRange fixRange, @NotNull PsiClass containingClass) {
        String message2 = HighlightMethodUtil.checkStaticInterfaceMethodCallQualifier(referenceToMethod, resolveResult.getCurrentFileResolveScope(), containingClass);
        if (message2 != null) {
            HighlightInfo highlightInfo = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).descriptionAndTooltip(message2).range(fixRange).create();
            QuickFixAction.registerQuickFixAction((HighlightInfo)highlightInfo, (IntentionAction)QUICK_FIX_FACTORY.createAccessStaticViaInstanceFix(referenceToMethod, resolveResult));
            return highlightInfo;
        }
        return null;
    }

    private static String checkStaticInterfaceMethodCallQualifier(@NotNull PsiReferenceExpression ref, @Nullable PsiElement scope, @NotNull PsiClass containingClass) {
        PsiExpression qualifierExpression2 = ref.getQualifierExpression();
        if (qualifierExpression2 == null && (scope instanceof PsiImportStaticStatement || PsiTreeUtil.isAncestor((PsiElement)containingClass, (PsiElement)ref, (boolean)true))) {
            return null;
        }
        if (qualifierExpression2 instanceof PsiReferenceExpression) {
            PsiElement resolve2 = ((PsiReferenceExpression)qualifierExpression2).resolve();
            if (containingClass.getManager().areElementsEquivalent(resolve2, (PsiElement)containingClass)) {
                return null;
            }
            if (resolve2 instanceof PsiTypeParameter) {
                HashSet<PsiClass> classes2 = new HashSet<PsiClass>();
                for (PsiClassType type2 : ((PsiTypeParameter)resolve2).getExtendsListTypes()) {
                    PsiClass aClass = type2.resolve();
                    if (aClass == null) continue;
                    classes2.add(aClass);
                }
                if (classes2.size() == 1 && classes2.contains(containingClass)) {
                    return null;
                }
            }
        }
        return JavaErrorBundle.message("static.interface.method.call.qualifier", new Object[0]);
    }

    private static void registerMethodReturnFixAction(@NotNull HighlightInfo highlightInfo, @NotNull MethodCandidateInfo candidate, @NotNull PsiCall methodCall) {
        PsiMethod containerMethod;
        if (methodCall.getParent() instanceof PsiReturnStatement && (containerMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)methodCall, PsiMethod.class, (boolean)true, (Class[])new Class[]{PsiLambdaExpression.class})) != null) {
            PsiMethod method = candidate.getElement();
            PsiExpression methodCallCopy = JavaPsiFacade.getElementFactory((Project)method.getProject()).createExpressionFromText(methodCall.getText(), (PsiElement)methodCall);
            PsiType methodCallTypeByArgs = methodCallCopy.getType();
            methodCallTypeByArgs = JavaPsiFacade.getElementFactory((Project)method.getProject()).createRawSubstitutor((PsiTypeParameterListOwner)method).substitute(methodCallTypeByArgs);
            if (methodCallTypeByArgs != null) {
                QuickFixAction.registerQuickFixAction((HighlightInfo)highlightInfo, (TextRange)HighlightMethodUtil.getFixRange((PsiElement)methodCall), (IntentionAction)QUICK_FIX_FACTORY.createMethodReturnFix(containerMethod, methodCallTypeByArgs, true));
            }
        }
    }

    @NotNull
    private static List<PsiExpression> mismatchedArgs(PsiExpression @NotNull [] expressions2, PsiSubstitutor substitutor, PsiParameter @NotNull [] parameters2, boolean varargs) {
        if (!(parameters2.length != 0 && parameters2[parameters2.length - 1].isVarArgs() || parameters2.length == expressions2.length)) {
            return Collections.emptyList();
        }
        ArrayList<PsiExpression> result = new ArrayList<PsiExpression>();
        for (int i = 0; i < Math.max(parameters2.length, expressions2.length); ++i) {
            if (HighlightMethodUtil.assignmentCompatible(i, parameters2, expressions2, substitutor, varargs)) continue;
            result.add(i < expressions2.length ? expressions2[i] : null);
        }
        return result;
    }

    static boolean isDummyConstructorCall(@NotNull PsiMethodCallExpression methodCall, @NotNull PsiResolveHelper resolveHelper, @NotNull PsiExpressionList list, @NotNull PsiReferenceExpression referenceToMethod) {
        CandidateInfo[] candidates;
        boolean isDummy = false;
        boolean isThisOrSuper = referenceToMethod.getReferenceNameElement() instanceof PsiKeyword;
        if (isThisOrSuper && list.isEmpty() && (candidates = resolveHelper.getReferencedMethodCandidates((PsiCallExpression)methodCall, true)).length == 1 && !candidates[0].getElement().isPhysical()) {
            isDummy = true;
        }
        return isDummy;
    }

    static HighlightInfo checkAmbiguousMethodCallIdentifier(@NotNull PsiReferenceExpression referenceToMethod, JavaResolveResult @NotNull [] resolveResults, @NotNull PsiExpressionList list, @Nullable PsiElement element, @NotNull JavaResolveResult resolveResult, @NotNull PsiMethodCallExpression methodCall, @NotNull PsiResolveHelper resolveHelper, @NotNull LanguageLevel languageLevel, @NotNull PsiFile file) {
        HighlightInfo info;
        String description;
        MethodCandidateInfo methodCandidate2 = (MethodCandidateInfo)HighlightMethodUtil.findCandidates((JavaResolveResult[])resolveResults).second;
        if (methodCandidate2 != null) {
            return null;
        }
        MethodCandidateInfo[] candidates = HighlightMethodUtil.toMethodCandidates(resolveResults);
        HighlightInfoType highlightInfoType = HighlightInfoType.ERROR;
        PsiElement elementToHighlight = (PsiElement)ObjectUtils.notNull((Object)referenceToMethod.getReferenceNameElement(), (Object)referenceToMethod);
        if (element != null && !resolveResult.isAccessible()) {
            description = HighlightUtil.accessProblemDescription((PsiElement)referenceToMethod, element, resolveResult);
        } else if (element != null && !resolveResult.isStaticsScopeCorrect()) {
            PsiClass containingClass;
            if (element instanceof PsiMethod && ((PsiMethod)element).hasModifierProperty("static") && (containingClass = ((PsiMethod)element).getContainingClass()) != null && containingClass.isInterface()) {
                info = HighlightUtil.checkFeature(elementToHighlight, HighlightingFeature.STATIC_INTERFACE_CALLS, languageLevel, file);
                if (info != null) {
                    return info;
                }
                info = HighlightMethodUtil.checkStaticInterfaceCallQualifier(referenceToMethod, resolveResult, elementToHighlight.getTextRange(), containingClass);
                if (info != null) {
                    return info;
                }
            }
            description = HighlightUtil.staticContextProblemDescription(element);
        } else if (candidates.length == 0) {
            PsiClass qualifierClass = RefactoringChangeUtil.getQualifierClass(referenceToMethod);
            String qualifier = qualifierClass != null ? qualifierClass.getName() : null;
            description = qualifier != null ? JavaErrorBundle.message("ambiguous.method.call.no.match", referenceToMethod.getReferenceName(), qualifier) : JavaErrorBundle.message("cannot.resolve.method", referenceToMethod.getReferenceName() + HighlightMethodUtil.buildArgTypesList(list));
            highlightInfoType = HighlightInfoType.WRONG_REF;
        } else {
            return null;
        }
        String toolTip = XmlStringUtil.escapeString((String)description);
        info = HighlightInfo.newHighlightInfo((HighlightInfoType)highlightInfoType).range(elementToHighlight).description(description).escapedToolTip(toolTip).create();
        HighlightMethodUtil.registerMethodCallIntentions(info, methodCall, list, resolveHelper);
        if (element != null && !resolveResult.isStaticsScopeCorrect()) {
            HighlightFixUtil.registerStaticProblemQuickFixAction(element, info, (PsiJavaCodeReferenceElement)referenceToMethod);
        }
        TextRange fixRange = HighlightMethodUtil.getFixRange(elementToHighlight);
        CastMethodArgumentFix.REGISTRAR.registerCastActions((CandidateInfo[])candidates, (PsiCall)methodCall, info, fixRange);
        WrapObjectWithOptionalOfNullableFix.REGISTAR.registerCastActions((CandidateInfo[])candidates, (PsiCall)methodCall, info, fixRange);
        WrapWithAdapterMethodCallFix.registerCastActions((CandidateInfo[])candidates, (PsiCall)methodCall, info, fixRange);
        PermuteArgumentsFix.registerFix(info, (PsiCall)methodCall, (CandidateInfo[])candidates, fixRange);
        WrapExpressionFix.registerWrapAction((JavaResolveResult[])candidates, list.getExpressions(), info, fixRange);
        HighlightMethodUtil.registerChangeParameterClassFix((PsiCall)methodCall, list, info);
        if (candidates.length == 0) {
            UnresolvedReferenceQuickFixProvider.registerReferenceFixes((PsiReference)methodCall.getMethodExpression(), (QuickFixActionRegistrar)new QuickFixActionRegistrarImpl(info));
        }
        return info;
    }

    static HighlightInfo checkAmbiguousMethodCallArguments(@NotNull PsiReferenceExpression referenceToMethod, JavaResolveResult @NotNull [] resolveResults, @NotNull PsiExpressionList list, PsiElement element, @NotNull JavaResolveResult resolveResult, @NotNull PsiMethodCallExpression methodCall, @NotNull PsiResolveHelper resolveHelper, @NotNull PsiElement elementToHighlight) {
        String toolTip;
        String description;
        Pair<MethodCandidateInfo, MethodCandidateInfo> pair2 = HighlightMethodUtil.findCandidates(resolveResults);
        MethodCandidateInfo methodCandidate1 = (MethodCandidateInfo)pair2.first;
        MethodCandidateInfo methodCandidate2 = (MethodCandidateInfo)pair2.second;
        MethodCandidateInfo[] candidates = HighlightMethodUtil.toMethodCandidates(resolveResults);
        HighlightInfoType highlightInfoType = HighlightInfoType.ERROR;
        if (methodCandidate2 != null) {
            VirtualFile virtualFile2;
            PsiMethod element1 = methodCandidate1.getElement();
            String m1 = PsiFormatUtil.formatMethod((PsiMethod)element1, (PsiSubstitutor)methodCandidate1.getSubstitutor(false), (int)4353, (int)2);
            PsiMethod element2 = methodCandidate2.getElement();
            String m2 = PsiFormatUtil.formatMethod((PsiMethod)element2, (PsiSubstitutor)methodCandidate2.getSubstitutor(false), (int)4353, (int)2);
            VirtualFile virtualFile1 = PsiUtilCore.getVirtualFile((PsiElement)element1);
            if (!Comparing.equal((Object)virtualFile1, (Object)(virtualFile2 = PsiUtilCore.getVirtualFile((PsiElement)element2)))) {
                if (virtualFile1 != null) {
                    m1 = m1 + " (In " + virtualFile1.getPresentableUrl() + ")";
                }
                if (virtualFile2 != null) {
                    m2 = m2 + " (In " + virtualFile2.getPresentableUrl() + ")";
                }
            }
            description = JavaErrorBundle.message("ambiguous.method.call", m1, m2);
            toolTip = HighlightMethodUtil.createAmbiguousMethodHtmlTooltip(new MethodCandidateInfo[]{methodCandidate1, methodCandidate2});
        } else {
            if (element != null && !resolveResult.isAccessible()) {
                return null;
            }
            if (element != null && !resolveResult.isStaticsScopeCorrect()) {
                return null;
            }
            String methodName = referenceToMethod.getReferenceName() + HighlightMethodUtil.buildArgTypesList(list);
            description = JavaErrorBundle.message("cannot.resolve.method", methodName);
            if (candidates.length == 0) {
                return null;
            }
            toolTip = XmlStringUtil.escapeString((String)description);
        }
        HighlightInfo info = HighlightInfo.newHighlightInfo((HighlightInfoType)highlightInfoType).range(elementToHighlight).description(description).escapedToolTip(toolTip).create();
        if (methodCandidate2 == null) {
            HighlightMethodUtil.registerMethodCallIntentions(info, methodCall, list, resolveHelper);
        }
        if (!resolveResult.isAccessible() && resolveResult.isStaticsScopeCorrect() && methodCandidate2 != null) {
            HighlightFixUtil.registerAccessQuickFixAction((PsiJvmMember)element, (PsiJavaCodeReferenceElement)referenceToMethod, info, resolveResult.getCurrentFileResolveScope());
        }
        if (element != null && !resolveResult.isStaticsScopeCorrect()) {
            HighlightFixUtil.registerStaticProblemQuickFixAction(element, info, (PsiJavaCodeReferenceElement)referenceToMethod);
        }
        TextRange fixRange = HighlightMethodUtil.getFixRange(elementToHighlight);
        CastMethodArgumentFix.REGISTRAR.registerCastActions((CandidateInfo[])candidates, (PsiCall)methodCall, info, fixRange);
        WrapObjectWithOptionalOfNullableFix.REGISTAR.registerCastActions((CandidateInfo[])candidates, (PsiCall)methodCall, info, fixRange);
        WrapWithAdapterMethodCallFix.registerCastActions((CandidateInfo[])candidates, (PsiCall)methodCall, info, fixRange);
        PermuteArgumentsFix.registerFix(info, (PsiCall)methodCall, (CandidateInfo[])candidates, fixRange);
        WrapExpressionFix.registerWrapAction((JavaResolveResult[])candidates, list.getExpressions(), info, fixRange);
        HighlightMethodUtil.registerChangeParameterClassFix((PsiCall)methodCall, list, info);
        return info;
    }

    @NotNull
    private static Pair<MethodCandidateInfo, MethodCandidateInfo> findCandidates(JavaResolveResult @NotNull [] resolveResults) {
        MethodCandidateInfo methodCandidate1 = null;
        MethodCandidateInfo methodCandidate2 = null;
        for (JavaResolveResult result : resolveResults) {
            MethodCandidateInfo candidate;
            if (!(result instanceof MethodCandidateInfo) || !(candidate = (MethodCandidateInfo)result).isApplicable() || candidate.getElement().isConstructor()) continue;
            if (methodCandidate1 == null) {
                methodCandidate1 = candidate;
                continue;
            }
            methodCandidate2 = candidate;
            break;
        }
        return Pair.pair(methodCandidate1, methodCandidate2);
    }

    private static MethodCandidateInfo @NotNull [] toMethodCandidates(JavaResolveResult @NotNull [] resolveResults) {
        ArrayList<MethodCandidateInfo> candidateList = new ArrayList<MethodCandidateInfo>(resolveResults.length);
        for (JavaResolveResult result : resolveResults) {
            MethodCandidateInfo candidate;
            if (!(result instanceof MethodCandidateInfo) || !(candidate = (MethodCandidateInfo)result).isAccessible()) continue;
            candidateList.add(candidate);
        }
        return candidateList.toArray(new MethodCandidateInfo[0]);
    }

    private static void registerMethodCallIntentions(@Nullable HighlightInfo highlightInfo, @NotNull PsiMethodCallExpression methodCall, @NotNull PsiExpressionList list, @NotNull PsiResolveHelper resolveHelper) {
        PsiType methodCallType;
        TextRange fixRange = HighlightMethodUtil.getFixRange((PsiElement)methodCall);
        PsiExpression qualifierExpression2 = methodCall.getMethodExpression().getQualifierExpression();
        if (qualifierExpression2 instanceof PsiReferenceExpression) {
            PsiElement resolve2 = ((PsiReferenceExpression)qualifierExpression2).resolve();
            if (resolve2 instanceof PsiClass && ((PsiClass)resolve2).getContainingClass() != null && !((PsiClass)resolve2).hasModifierProperty("static")) {
                QuickFixAction.registerQuickFixActions((HighlightInfo)highlightInfo, null, (Iterable)JvmElementActionFactories.createModifierActions((JvmModifiersOwner)((PsiClass)resolve2), (ChangeModifierRequest)MemberRequestsKt.modifierRequest((JvmModifier)JvmModifier.STATIC, (boolean)true)));
            }
        } else if (qualifierExpression2 instanceof PsiSuperExpression && ((PsiSuperExpression)qualifierExpression2).getQualifier() == null) {
            QualifySuperArgumentFix.registerQuickFixAction((PsiSuperExpression)qualifierExpression2, highlightInfo);
        }
        HighlightMethodUtil.registerUsageFixes(methodCall, highlightInfo, fixRange);
        HighlightMethodUtil.registerThisSuperFixes(methodCall, highlightInfo, fixRange);
        CandidateInfo[] methodCandidates = resolveHelper.getReferencedMethodCandidates((PsiCallExpression)methodCall, false);
        CastMethodArgumentFix.REGISTRAR.registerCastActions(methodCandidates, (PsiCall)methodCall, highlightInfo, fixRange);
        AddTypeArgumentsFix.REGISTRAR.registerCastActions(methodCandidates, (PsiCall)methodCall, highlightInfo, fixRange);
        WrapObjectWithOptionalOfNullableFix.REGISTAR.registerCastActions(methodCandidates, (PsiCall)methodCall, highlightInfo, fixRange);
        MethodReturnFixFactory.INSTANCE.registerCastActions(methodCandidates, (PsiCall)methodCall, highlightInfo, fixRange);
        WrapWithAdapterMethodCallFix.registerCastActions(methodCandidates, (PsiCall)methodCall, highlightInfo, fixRange);
        HighlightMethodUtil.registerMethodAccessLevelIntentions(methodCandidates, methodCall, list, highlightInfo);
        if (!PermuteArgumentsFix.registerFix(highlightInfo, (PsiCall)methodCall, methodCandidates, fixRange)) {
            HighlightMethodUtil.registerChangeMethodSignatureFromUsageIntentions((JavaResolveResult[])methodCandidates, list, highlightInfo, fixRange);
        }
        RemoveRedundantArgumentsFix.registerIntentions((JavaResolveResult[])methodCandidates, list, highlightInfo, fixRange);
        ConvertDoubleToFloatFix.registerIntentions((JavaResolveResult[])methodCandidates, list, highlightInfo, fixRange);
        WrapExpressionFix.registerWrapAction((JavaResolveResult[])methodCandidates, list.getExpressions(), highlightInfo, fixRange);
        HighlightMethodUtil.registerChangeParameterClassFix((PsiCall)methodCall, list, highlightInfo);
        if (methodCandidates.length == 0) {
            HighlightMethodUtil.registerStaticMethodQualifierFixes(methodCall, highlightInfo);
        }
        for (IntentionAction action : QUICK_FIX_FACTORY.getVariableTypeFromCallFixes(methodCall, list)) {
            QuickFixAction.registerQuickFixAction((HighlightInfo)highlightInfo, (TextRange)fixRange, (IntentionAction)action);
        }
        QuickFixAction.registerQuickFixAction((HighlightInfo)highlightInfo, (TextRange)fixRange, (IntentionAction)QUICK_FIX_FACTORY.createReplaceAddAllArrayToCollectionFix(methodCall));
        QuickFixAction.registerQuickFixAction((HighlightInfo)highlightInfo, (TextRange)fixRange, (IntentionAction)QUICK_FIX_FACTORY.createSurroundWithArrayFix((PsiCall)methodCall, null));
        QualifyThisArgumentFix.registerQuickFixAction(methodCandidates, (PsiCall)methodCall, highlightInfo, fixRange);
        PsiType expectedTypeByParent = PsiTypesUtil.getExpectedTypeByParent((PsiElement)methodCall);
        if (expectedTypeByParent != null && (methodCallType = methodCall.getType()) != null && TypeConversionUtil.areTypesConvertible((PsiType)methodCallType, (PsiType)expectedTypeByParent) && !TypeConversionUtil.isAssignable((PsiType)expectedTypeByParent, (PsiType)methodCallType)) {
            QuickFixAction.registerQuickFixAction((HighlightInfo)highlightInfo, (TextRange)fixRange, (IntentionAction)QUICK_FIX_FACTORY.createAddTypeCastFix(expectedTypeByParent, (PsiExpression)methodCall));
        }
        CandidateInfo[] candidates = resolveHelper.getReferencedMethodCandidates((PsiCallExpression)methodCall, true);
        ChangeStringLiteralToCharInMethodCallFix.registerFixes(candidates, methodCall, highlightInfo);
    }

    private static void registerMethodAccessLevelIntentions(CandidateInfo @NotNull [] methodCandidates, @NotNull PsiMethodCallExpression methodCall, @NotNull PsiExpressionList exprList, @Nullable HighlightInfo highlightInfo) {
        for (CandidateInfo methodCandidate : methodCandidates) {
            PsiMethod method = (PsiMethod)methodCandidate.getElement();
            if (methodCandidate.isAccessible() || !PsiUtil.isApplicable((PsiMethod)method, (PsiSubstitutor)methodCandidate.getSubstitutor(), (PsiExpressionList)exprList)) continue;
            HighlightFixUtil.registerAccessQuickFixAction((PsiJvmMember)method, (PsiJavaCodeReferenceElement)methodCall.getMethodExpression(), highlightInfo, methodCandidate.getCurrentFileResolveScope());
        }
    }

    @NotNull
    private static String createAmbiguousMethodHtmlTooltip(MethodCandidateInfo @NotNull [] methodCandidates) {
        return JavaErrorBundle.message("ambiguous.method.html.tooltip", methodCandidates[0].getElement().getParameterList().getParametersCount() + 2, HighlightMethodUtil.createAmbiguousMethodHtmlTooltipMethodRow(methodCandidates[0]), HighlightMethodUtil.getContainingClassName(methodCandidates[0]), HighlightMethodUtil.createAmbiguousMethodHtmlTooltipMethodRow(methodCandidates[1]), HighlightMethodUtil.getContainingClassName(methodCandidates[1]));
    }

    @NotNull
    private static String getContainingClassName(@NotNull MethodCandidateInfo methodCandidate) {
        PsiMethod method = methodCandidate.getElement();
        PsiClass containingClass = method.getContainingClass();
        return containingClass == null ? method.getContainingFile().getName() : HighlightUtil.formatClass(containingClass, false);
    }

    @Language(value="HTML")
    @NotNull
    private static String createAmbiguousMethodHtmlTooltipMethodRow(@NotNull MethodCandidateInfo methodCandidate) {
        PsiMethod method = methodCandidate.getElement();
        PsiParameter[] parameters2 = method.getParameterList().getParameters();
        PsiSubstitutor substitutor = methodCandidate.getSubstitutor();
        StringBuilder ms = new StringBuilder("<td><b>" + method.getName() + "</b></td>");
        for (int j = 0; j < parameters2.length; ++j) {
            PsiParameter parameter2 = parameters2[j];
            PsiType type2 = substitutor.substitute(parameter2.getType());
            ms.append("<td><b>").append(j == 0 ? "(" : "").append(XmlStringUtil.escapeString((String)type2.getPresentableText())).append(j == parameters2.length - 1 ? ")" : ",").append("</b></td>");
        }
        if (parameters2.length == 0) {
            ms.append("<td><b>()</b></td>");
        }
        return ms.toString();
    }

    @NotNull
    private static String createMismatchedArgumentsHtmlTooltip(@NotNull MethodCandidateInfo info, @NotNull PsiExpressionList list) {
        PsiMethod method = info.getElement();
        PsiSubstitutor substitutor = info.getSubstitutor();
        PsiParameter[] parameters2 = method.getParameterList().getParameters();
        return HighlightMethodUtil.createMismatchedArgumentsHtmlTooltip(list, info, parameters2, substitutor);
    }

    @Language(value="HTML")
    @NotNull
    private static String createMismatchedArgumentsHtmlTooltip(@NotNull PsiExpressionList list, @Nullable MethodCandidateInfo info, PsiParameter @NotNull [] parameters2, @NotNull PsiSubstitutor substitutor) {
        String errorMessage;
        PsiExpression[] expressions2 = list.getExpressions();
        if (!(parameters2.length != 0 && parameters2[parameters2.length - 1].isVarArgs() || parameters2.length == expressions2.length)) {
            return "<html>Expected " + parameters2.length + " arguments but found " + expressions2.length + "</html>";
        }
        String greyedColor = ColorUtil.toHtmlColor((Color)UIUtil.getContextHelpForeground());
        StringBuilder s = new StringBuilder("<html><body><table>");
        s.append("<tr>");
        s.append("<td/>");
        s.append("<td style='color: ").append(greyedColor).append("; padding-left: 16px; padding-right: 24px;'>Required type</td>");
        s.append("<td style='color: ").append(greyedColor).append("; padding-right: 28px;'>Provided</td>");
        s.append("</tr>");
        String parameterNameStyle = String.format("color: %s; font-size:%dpt; padding:1px 4px 1px 4px;", greyedColor, StartupUiUtil.getLabelFont().getSize() - (SystemInfo.isWindows ? 0 : 1));
        Color paramBgColor = EditorColorsUtil.getGlobalOrDefaultColorScheme().getAttributes(DefaultLanguageHighlighterColors.INLINE_PARAMETER_HINT).getBackgroundColor();
        if (paramBgColor != null) {
            parameterNameStyle = parameterNameStyle + "background-color: " + ColorUtil.toHtmlColor((Color)paramBgColor) + ";";
        }
        boolean varargAdded = false;
        for (int i = 0; i < Math.max(parameters2.length, expressions2.length); ++i) {
            boolean varargs;
            boolean bl = varargs = info != null && info.isVarargs();
            if (HighlightMethodUtil.assignmentCompatible(i, parameters2, expressions2, substitutor, varargs)) continue;
            PsiParameter parameter2 = null;
            if (i < parameters2.length) {
                parameter2 = parameters2[i];
                varargAdded = parameter2.isVarArgs();
            } else if (!varargAdded) {
                parameter2 = parameters2[parameters2.length - 1];
                varargAdded = true;
            }
            PsiType parameterType = substitutor.substitute(PsiTypesUtil.getParameterType((PsiParameter[])parameters2, (int)i, (boolean)varargs));
            PsiExpression expression2 = i < expressions2.length ? expressions2[i] : null;
            boolean showShortType = HighlightUtil.showShortType(parameterType, expression2 != null ? expression2.getType() : null);
            s.append("<tr>");
            if (parameter2 != null) {
                s.append("<td><table><tr><td style='").append(parameterNameStyle).append("'>").append(parameter2.getName()).append(":</td></tr></table></td>");
                s.append("<td style='padding-left: 16px; padding-right: 24px;'>").append(HighlightUtil.redIfNotMatch(substitutor.substitute(parameter2.getType()), true, showShortType)).append("</td>");
            } else {
                s.append("<td/>");
                s.append("<td style='padding-left: 16px; padding-right: 24px;'/>");
            }
            if (expression2 != null) {
                s.append("<td style='padding-right: 28px;'>").append(HighlightMethodUtil.mismatchedExpressionType(parameterType, expression2)).append("</td>");
            } else {
                s.append("<td style='padding-right: 28px;'/>");
            }
            s.append("</tr>");
        }
        s.append("</table>");
        String string = errorMessage = info != null ? info.getInferenceErrorMessage() : null;
        if (errorMessage != null) {
            s.append("<table><tr><td style='padding-left: 4px; padding-top: 10;'>").append("reason: ").append(XmlStringUtil.escapeString((String)errorMessage).replaceAll("\n", "<br/>")).append("</td></tr></table>");
        }
        s.append("</body></html>");
        return s.toString();
    }

    @NotNull
    private static String mismatchedExpressionType(PsiType parameterType, @NotNull PsiExpression expression2) {
        return HighlightUtil.createIncompatibleTypesTooltip(parameterType, expression2.getType(), new HighlightUtil.IncompatibleTypesTooltipComposer(){

            @Override
            @NotNull
            public String consume(@NotNull String lRawType, @NotNull String lTypeArguments, @NotNull String rRawType, @NotNull String rTypeArguments) {
                return rRawType + rTypeArguments;
            }

            @Override
            public boolean skipTypeArgsColumns() {
                return true;
            }
        });
    }

    private static boolean assignmentCompatible(int i, PsiParameter @NotNull [] parameters2, PsiExpression @NotNull [] expressions2, @NotNull PsiSubstitutor substitutor, boolean varargs) {
        PsiExpression expression2;
        PsiExpression psiExpression = expression2 = i < expressions2.length ? expressions2[i] : null;
        if (expression2 == null) {
            return true;
        }
        PsiType paramType = substitutor.substitute(PsiTypesUtil.getParameterType((PsiParameter[])parameters2, (int)i, (boolean)varargs));
        return paramType != null && TypeConversionUtil.areTypesAssignmentCompatible((PsiType)paramType, (PsiExpression)expression2);
    }

    static HighlightInfo checkMethodMustHaveBody(@NotNull PsiMethod method, @Nullable PsiClass aClass) {
        HighlightInfo errorResult = null;
        if (!(method.getBody() != null || method.hasModifierProperty("abstract") || method.hasModifierProperty("native") || aClass == null || aClass.isInterface() || PsiUtilCore.hasErrorElementChild((PsiElement)method))) {
            int start = method.getModifierList().getTextRange().getStartOffset();
            int end = method.getTextRange().getEndOffset();
            String description = JavaErrorBundle.message("missing.method.body", new Object[0]);
            errorResult = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range(start, end).descriptionAndTooltip(description).create();
            if (HighlightUtil.getIncompatibleModifier("abstract", method.getModifierList()) == null && !(aClass instanceof PsiAnonymousClass)) {
                QuickFixAction.registerQuickFixActions((HighlightInfo)errorResult, null, (Iterable)JvmElementActionFactories.createModifierActions((JvmModifiersOwner)method, (ChangeModifierRequest)MemberRequestsKt.modifierRequest((JvmModifier)JvmModifier.ABSTRACT, (boolean)true)));
            }
            QuickFixAction.registerQuickFixAction((HighlightInfo)errorResult, (IntentionAction)QUICK_FIX_FACTORY.createAddMethodBodyFix(method));
        }
        return errorResult;
    }

    static HighlightInfo checkAbstractMethodInConcreteClass(@NotNull PsiMethod method, @NotNull PsiElement elementToHighlight) {
        HighlightInfo errorResult = null;
        PsiClass aClass = method.getContainingClass();
        if (method.hasModifierProperty("abstract") && aClass != null && !aClass.hasModifierProperty("abstract") && !aClass.isEnum() && !PsiUtilCore.hasErrorElementChild((PsiElement)method)) {
            String description = JavaErrorBundle.message("abstract.method.in.non.abstract.class", new Object[0]);
            errorResult = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range(elementToHighlight).descriptionAndTooltip(description).create();
            if (method.getBody() != null) {
                QuickFixAction.registerQuickFixAction((HighlightInfo)errorResult, (IntentionAction)QUICK_FIX_FACTORY.createModifierListFix((PsiModifierListOwner)method, "abstract", false, false));
            }
            QuickFixAction.registerQuickFixAction((HighlightInfo)errorResult, (IntentionAction)QUICK_FIX_FACTORY.createAddMethodBodyFix(method));
            QuickFixAction.registerQuickFixAction((HighlightInfo)errorResult, (IntentionAction)QUICK_FIX_FACTORY.createModifierListFix((PsiModifierListOwner)aClass, "abstract", true, false));
        }
        return errorResult;
    }

    static HighlightInfo checkConstructorName(@NotNull PsiMethod method) {
        PsiClass aClass = method.getContainingClass();
        if (aClass != null) {
            String className2;
            String string = className2 = aClass instanceof PsiAnonymousClass ? null : aClass.getName();
            if (className2 == null || !Comparing.strEqual((String)method.getName(), (String)className2)) {
                PsiElement element = (PsiElement)ObjectUtils.notNull((Object)method.getNameIdentifier(), (Object)method);
                String description = JavaErrorBundle.message("missing.return.type", new Object[0]);
                HighlightInfo info = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range(element).descriptionAndTooltip(description).create();
                if (className2 != null) {
                    QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)QUICK_FIX_FACTORY.createRenameElementFix((PsiNamedElement)method, className2));
                }
                return info;
            }
        }
        return null;
    }

    static HighlightInfo checkDuplicateMethod(@NotNull PsiClass aClass, @NotNull PsiMethod method, @NotNull MostlySingularMultiMap<MethodSignature, PsiMethod> duplicateMethods) {
        if (method instanceof ExternallyDefinedPsiElement) {
            return null;
        }
        MethodSignature methodSignature = method.getSignature(PsiSubstitutor.EMPTY);
        int methodCount = 1;
        List methods = (List)duplicateMethods.get((Object)methodSignature);
        if (methods.size() > 1) {
            ++methodCount;
        }
        if (methodCount == 1 && aClass.isEnum() && GenericsHighlightUtil.isEnumSyntheticMethod(methodSignature, aClass.getProject())) {
            ++methodCount;
        }
        if (methodCount > 1) {
            String description = JavaErrorBundle.message("duplicate.method", JavaHighlightUtil.formatMethod(method), HighlightUtil.formatClass(aClass));
            TextRange textRange = HighlightNamesUtil.getMethodDeclarationTextRange(method);
            return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)method, textRange.getStartOffset(), textRange.getEndOffset()).descriptionAndTooltip(description).create();
        }
        return null;
    }

    static HighlightInfo checkMethodCanHaveBody(@NotNull PsiMethod method, @NotNull LanguageLevel languageLevel) {
        PsiClass aClass = method.getContainingClass();
        boolean hasNoBody = method.getBody() == null;
        boolean isInterface = aClass != null && aClass.isInterface();
        boolean isExtension = method.hasModifierProperty("default");
        boolean isStatic = method.hasModifierProperty("static");
        boolean isPrivate = method.hasModifierProperty("private");
        ArrayList<Object> additionalFixes = new ArrayList<Object>();
        String description = null;
        if (hasNoBody) {
            if (isExtension) {
                description = JavaErrorBundle.message("extension.method.should.have.a.body", new Object[0]);
            } else if (isInterface) {
                if (isStatic && languageLevel.isAtLeast(LanguageLevel.JDK_1_8)) {
                    description = JavaErrorBundle.message("static.methods.in.interfaces.should.have.body", new Object[0]);
                } else if (isPrivate && languageLevel.isAtLeast(LanguageLevel.JDK_1_9)) {
                    description = JavaErrorBundle.message("private.methods.in.interfaces.should.have.body", new Object[0]);
                }
            }
            if (description != null) {
                additionalFixes.add(QUICK_FIX_FACTORY.createAddMethodBodyFix(method));
            }
        } else if (isInterface) {
            if (!(isExtension || isStatic || isPrivate)) {
                description = JavaErrorBundle.message("interface.methods.cannot.have.body", new Object[0]);
                if (languageLevel.isAtLeast(LanguageLevel.JDK_1_8) && Stream.of(method.findDeepestSuperMethods()).map(PsiJvmMember::getContainingClass).filter(Objects::nonNull).map(PsiClass::getQualifiedName).noneMatch("java.lang.Object"::equals)) {
                    LocalQuickFixAndIntentionActionOnPsiElement makeDefaultFix = QUICK_FIX_FACTORY.createModifierListFix((PsiModifierListOwner)method, "default", true, false);
                    additionalFixes.add(PriorityIntentionActionWrapper.highPriority((IntentionAction)makeDefaultFix));
                    additionalFixes.add(QUICK_FIX_FACTORY.createModifierListFix((PsiModifierListOwner)method, "static", true, false));
                }
            }
        } else if (isExtension) {
            description = JavaErrorBundle.message("extension.method.in.class", new Object[0]);
            additionalFixes.add(QUICK_FIX_FACTORY.createModifierListFix((PsiModifierListOwner)method, "default", false, false));
        } else if (method.hasModifierProperty("abstract")) {
            description = JavaErrorBundle.message("abstract.methods.cannot.have.a.body", new Object[0]);
        } else if (method.hasModifierProperty("native")) {
            description = JavaErrorBundle.message("native.methods.cannot.have.a.body", new Object[0]);
        }
        if (description == null) {
            return null;
        }
        TextRange textRange = HighlightNamesUtil.getMethodDeclarationTextRange(method);
        HighlightInfo info = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range(textRange).descriptionAndTooltip(description).create();
        if (!hasNoBody) {
            if (!isExtension) {
                QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)QUICK_FIX_FACTORY.createDeleteMethodBodyFix(method));
            }
            QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)QUICK_FIX_FACTORY.createPushDownMethodFix());
        }
        if (method.hasModifierProperty("abstract") && !isInterface) {
            QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)QUICK_FIX_FACTORY.createModifierListFix((PsiModifierListOwner)method, "abstract", false, false));
        }
        for (IntentionAction intentionAction : additionalFixes) {
            QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)intentionAction);
        }
        return info;
    }

    static HighlightInfo checkConstructorCallProblems(@NotNull PsiMethodCallExpression methodCall) {
        PsiMethod ctor;
        if (!JavaPsiConstructorUtil.isConstructorCall((PsiElement)methodCall)) {
            return null;
        }
        PsiElement codeBlock = methodCall.getParent().getParent();
        if (codeBlock instanceof PsiCodeBlock && (ctor = (PsiMethod)ObjectUtils.tryCast((Object)codeBlock.getParent(), PsiMethod.class)) != null && ctor.isConstructor()) {
            if (JavaPsiRecordUtil.isCompactConstructor(ctor) || JavaPsiRecordUtil.isExplicitCanonicalConstructor(ctor)) {
                String message2 = JavaErrorBundle.message("record.constructor.call.in.canonical", new Object[0]);
                return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)methodCall).descriptionAndTooltip(message2).create();
            }
            PsiElement prevSibling = methodCall.getParent().getPrevSibling();
            while (true) {
                if (prevSibling == null) {
                    return null;
                }
                if (prevSibling instanceof PsiStatement) break;
                prevSibling = prevSibling.getPrevSibling();
            }
        }
        PsiReferenceExpression expression2 = methodCall.getMethodExpression();
        String message3 = JavaErrorBundle.message("constructor.call.must.be.first.statement", expression2.getText() + "()");
        return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)methodCall).descriptionAndTooltip(message3).create();
    }

    static HighlightInfo checkSuperAbstractMethodDirectCall(@NotNull PsiMethodCallExpression methodCallExpression) {
        PsiReferenceExpression expression2 = methodCallExpression.getMethodExpression();
        if (!(expression2.getQualifierExpression() instanceof PsiSuperExpression)) {
            return null;
        }
        PsiMethod method = methodCallExpression.resolveMethod();
        if (method != null && method.hasModifierProperty("abstract")) {
            String message2 = JavaErrorBundle.message("direct.abstract.method.access", JavaHighlightUtil.formatMethod(method));
            return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)methodCallExpression).descriptionAndTooltip(message2).create();
        }
        return null;
    }

    static HighlightInfo checkConstructorCallsBaseClassConstructor(@NotNull PsiMethod constructor, @Nullable RefCountHolder refCountHolder, @NotNull PsiResolveHelper resolveHelper) {
        PsiClassType[] handledExceptions;
        if (!constructor.isConstructor()) {
            return null;
        }
        PsiClass aClass = constructor.getContainingClass();
        if (aClass == null) {
            return null;
        }
        if (aClass.isEnum()) {
            return null;
        }
        PsiCodeBlock body2 = constructor.getBody();
        if (body2 == null) {
            return null;
        }
        if (JavaPsiConstructorUtil.findThisOrSuperCallInConstructor((PsiMethod)constructor) != null) {
            return null;
        }
        TextRange textRange = HighlightNamesUtil.getMethodDeclarationTextRange(constructor);
        HighlightInfo info = HighlightClassUtil.checkBaseClassDefaultConstructorProblem(aClass, refCountHolder, resolveHelper, textRange, handledExceptions = constructor.getThrowsList().getReferencedTypes());
        if (info != null) {
            QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)QUICK_FIX_FACTORY.createInsertSuperFix(constructor));
            QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)QUICK_FIX_FACTORY.createInsertThisFix(constructor));
            PsiClass superClass = aClass.getSuperClass();
            if (superClass != null) {
                QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)QUICK_FIX_FACTORY.createAddDefaultConstructorFix(superClass));
            }
        }
        return info;
    }

    static HighlightInfo checkStaticMethodOverride(@NotNull PsiMethod method, @NotNull PsiFile containingFile) {
        if (method.isConstructor()) {
            return null;
        }
        PsiClass aClass = method.getContainingClass();
        if (aClass == null) {
            return null;
        }
        HierarchicalMethodSignature methodSignature = PsiSuperMethodImplUtil.getHierarchicalMethodSignature(method);
        List superSignatures = methodSignature.getSuperSignatures();
        if (superSignatures.isEmpty()) {
            return null;
        }
        boolean isStatic = method.hasModifierProperty("static");
        for (HierarchicalMethodSignature signature : superSignatures) {
            HighlightInfo highlightInfo;
            PsiMethod superMethod = signature.getMethod();
            PsiClass superClass = superMethod.getContainingClass();
            if (superClass == null || (highlightInfo = HighlightMethodUtil.checkStaticMethodOverride(aClass, method, isStatic, superClass, superMethod, containingFile)) == null) continue;
            return highlightInfo;
        }
        return null;
    }

    private static HighlightInfo checkStaticMethodOverride(@NotNull PsiClass aClass, @NotNull PsiMethod method, boolean isMethodStatic, @NotNull PsiClass superClass, @NotNull PsiMethod superMethod, @NotNull PsiFile containingFile) {
        PsiManager manager = containingFile.getManager();
        PsiModifierList superModifierList = superMethod.getModifierList();
        PsiModifierList modifierList = method.getModifierList();
        if (superModifierList.hasModifierProperty("private")) {
            return null;
        }
        if (superModifierList.hasModifierProperty("packageLocal") && !JavaPsiFacade.getInstance((Project)manager.getProject()).arePackagesTheSame((PsiElement)aClass, (PsiElement)superClass)) {
            return null;
        }
        boolean isSuperMethodStatic = superModifierList.hasModifierProperty("static");
        if (isMethodStatic != isSuperMethodStatic) {
            TextRange textRange = HighlightNamesUtil.getMethodDeclarationTextRange(method);
            String messageKey = isMethodStatic ? "static.method.cannot.override.instance.method" : "instance.method.cannot.override.static.method";
            String description = JavaErrorBundle.message(messageKey, JavaHighlightUtil.formatMethod(method), HighlightUtil.formatClass(aClass), JavaHighlightUtil.formatMethod(superMethod), HighlightUtil.formatClass(superClass));
            HighlightInfo info = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range(textRange).descriptionAndTooltip(description).create();
            if (!isSuperMethodStatic || HighlightUtil.getIncompatibleModifier("static", modifierList) == null) {
                QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)QUICK_FIX_FACTORY.createModifierListFix((PsiModifierListOwner)method, "static", isSuperMethodStatic, false));
            }
            if (manager.isInProject((PsiElement)superMethod) && (!isMethodStatic || HighlightUtil.getIncompatibleModifier("static", superModifierList) == null)) {
                QuickFixAction.registerQuickFixActions((HighlightInfo)info, null, (Iterable)JvmElementActionFactories.createModifierActions((JvmModifiersOwner)superMethod, (ChangeModifierRequest)MemberRequestsKt.modifierRequest((JvmModifier)JvmModifier.STATIC, (boolean)isMethodStatic)));
            }
            return info;
        }
        if (isMethodStatic) {
            if (superClass.isInterface()) {
                return null;
            }
            int accessLevel = PsiUtil.getAccessLevel((PsiModifierList)modifierList);
            String accessModifier = PsiUtil.getAccessModifier((int)accessLevel);
            HighlightInfo info = HighlightMethodUtil.isWeaker(method, modifierList, accessModifier, accessLevel, superMethod, true);
            if (info != null) {
                return info;
            }
            info = HighlightMethodUtil.checkSuperMethodIsFinal(method, superMethod);
            if (info != null) {
                return info;
            }
        }
        return null;
    }

    private static HighlightInfo checkInterfaceInheritedMethodsReturnTypes(@NotNull List<? extends MethodSignatureBackedByPsiMethod> superMethodSignatures, @NotNull LanguageLevel languageLevel) {
        if (superMethodSignatures.size() < 2) {
            return null;
        }
        MethodSignatureBackedByPsiMethod[] returnTypeSubstitutable = new MethodSignatureBackedByPsiMethod[]{superMethodSignatures.get(0)};
        for (int i = 1; i < superMethodSignatures.size(); ++i) {
            PsiMethod currentMethod = returnTypeSubstitutable[0].getMethod();
            PsiType currentType = returnTypeSubstitutable[0].getSubstitutor().substitute(currentMethod.getReturnType());
            MethodSignatureBackedByPsiMethod otherSuperSignature = superMethodSignatures.get(i);
            PsiMethod otherSuperMethod = otherSuperSignature.getMethod();
            PsiSubstitutor otherSubstitutor = otherSuperSignature.getSubstitutor();
            PsiType otherSuperReturnType = otherSubstitutor.substitute(otherSuperMethod.getReturnType());
            PsiSubstitutor unifyingSubstitutor = MethodSignatureUtil.getSuperMethodSignatureSubstitutor((MethodSignature)returnTypeSubstitutable[0], (MethodSignature)otherSuperSignature);
            if (unifyingSubstitutor != null) {
                otherSuperReturnType = unifyingSubstitutor.substitute(otherSuperReturnType);
                currentType = unifyingSubstitutor.substitute(currentType);
            }
            if (otherSuperReturnType == null || currentType == null || otherSuperReturnType.equals(currentType)) continue;
            PsiType otherReturnType = otherSuperReturnType;
            PsiType curType = currentType;
            HighlightInfo info = (HighlightInfo)LambdaUtil.performWithSubstitutedParameterBounds((PsiTypeParameter[])otherSuperMethod.getTypeParameters(), (PsiSubstitutor)otherSubstitutor, () -> {
                if (languageLevel.isAtLeast(LanguageLevel.JDK_1_5)) {
                    if (!(otherReturnType instanceof PsiPrimitiveType) && !(curType instanceof PsiPrimitiveType)) {
                        if (otherReturnType.isAssignableFrom(curType)) {
                            return null;
                        }
                        if (curType.isAssignableFrom(otherReturnType)) {
                            returnTypeSubstitutable[0] = otherSuperSignature;
                            return null;
                        }
                    }
                    if (otherSuperMethod.getTypeParameters().length > 0 && JavaGenericsUtil.isRawToGeneric((PsiType)otherReturnType, (PsiType)curType)) {
                        return null;
                    }
                }
                return HighlightMethodUtil.createIncompatibleReturnTypeMessage(otherSuperMethod, currentMethod, curType, otherReturnType, JavaErrorBundle.message("unrelated.overriding.methods.return.types", new Object[0]), TextRange.EMPTY_RANGE);
            });
            if (info == null) continue;
            return info;
        }
        return null;
    }

    static HighlightInfo checkOverrideEquivalentInheritedMethods(@NotNull PsiClass aClass, @NotNull PsiFile containingFile, @NotNull LanguageLevel languageLevel) {
        String description = null;
        boolean appendImplementMethodFix = true;
        Collection visibleSignatures = aClass.getVisibleSignatures();
        PsiResolveHelper resolveHelper = JavaPsiFacade.getInstance((Project)aClass.getProject()).getResolveHelper();
        block0: for (HierarchicalMethodSignature signature : visibleSignatures) {
            HighlightInfo highlightInfo;
            PsiMethod method = signature.getMethod();
            if (!resolveHelper.isAccessible((PsiMember)method, (PsiElement)aClass, null)) continue;
            ArrayList<HierarchicalMethodSignature> superSignatures = signature.getSuperSignatures();
            boolean allAbstracts = method.hasModifierProperty("abstract");
            PsiClass containingClass = method.getContainingClass();
            if (containingClass == null || aClass.equals(containingClass) || aClass.isInterface() && !containingClass.isInterface()) continue;
            if (allAbstracts) {
                superSignatures = new ArrayList<HierarchicalMethodSignature>(superSignatures);
                superSignatures.add(0, signature);
                highlightInfo = HighlightMethodUtil.checkInterfaceInheritedMethodsReturnTypes(superSignatures, languageLevel);
            } else {
                highlightInfo = HighlightMethodUtil.checkMethodIncompatibleReturnType((MethodSignatureBackedByPsiMethod)signature, (List<? extends HierarchicalMethodSignature>)superSignatures, false);
            }
            if (highlightInfo != null) {
                description = highlightInfo.getDescription();
            }
            if (method.hasModifierProperty("static")) {
                for (HierarchicalMethodSignature superSignature : superSignatures) {
                    PsiMethod superMethod = superSignature.getMethod();
                    if (superMethod.hasModifierProperty("static")) continue;
                    PsiClass superClass = superMethod.getContainingClass();
                    description = JavaErrorBundle.message("static.method.cannot.override.instance.method", JavaHighlightUtil.formatMethod(method), HighlightUtil.formatClass(containingClass), JavaHighlightUtil.formatMethod(superMethod), superClass != null ? HighlightUtil.formatClass(superClass) : "<unknown>");
                    appendImplementMethodFix = false;
                    break block0;
                }
                continue;
            }
            if (description == null && (highlightInfo = HighlightMethodUtil.checkMethodIncompatibleThrows((MethodSignatureBackedByPsiMethod)signature, superSignatures, false, aClass)) != null) {
                description = highlightInfo.getDescription();
            }
            if (description == null && (highlightInfo = HighlightMethodUtil.checkMethodWeakerPrivileges((MethodSignatureBackedByPsiMethod)signature, superSignatures, false, containingFile)) != null) {
                description = highlightInfo.getDescription();
            }
            if (description == null) continue;
            break;
        }
        if (description != null) {
            TextRange textRange = HighlightNamesUtil.getClassDeclarationTextRange(aClass);
            HighlightInfo highlightInfo = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range(textRange).descriptionAndTooltip(description).create();
            if (appendImplementMethodFix) {
                QuickFixAction.registerQuickFixAction((HighlightInfo)highlightInfo, (IntentionAction)QUICK_FIX_FACTORY.createImplementMethodsFix(aClass));
            }
            return highlightInfo;
        }
        return null;
    }

    static HighlightInfo checkConstructorHandleSuperClassExceptions(@NotNull PsiMethod method) {
        PsiStatement[] statements;
        if (!method.isConstructor()) {
            return null;
        }
        PsiCodeBlock body2 = method.getBody();
        PsiStatement[] psiStatementArray = statements = body2 == null ? null : body2.getStatements();
        if (statements == null) {
            return null;
        }
        Collection<PsiClassType> unhandled = ExceptionUtil.collectUnhandledExceptions((PsiElement)method, (PsiElement)method.getContainingClass());
        if (unhandled.isEmpty()) {
            return null;
        }
        String description = HighlightUtil.getUnhandledExceptionsDescriptor(unhandled);
        TextRange textRange = HighlightNamesUtil.getMethodDeclarationTextRange(method);
        HighlightInfo highlightInfo = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range(textRange).descriptionAndTooltip(description).create();
        for (PsiClassType exception : unhandled) {
            QuickFixAction.registerQuickFixAction((HighlightInfo)highlightInfo, (IntentionAction)new LocalQuickFixOnPsiElementAsIntentionAdapter(QUICK_FIX_FACTORY.createMethodThrowsFix(method, exception, true, false)));
        }
        return highlightInfo;
    }

    static HighlightInfo checkRecursiveConstructorInvocation(@NotNull PsiMethod method) {
        if (HighlightControlFlowUtil.isRecursivelyCalledConstructor(method)) {
            TextRange textRange = HighlightNamesUtil.getMethodDeclarationTextRange(method);
            String description = JavaErrorBundle.message("recursive.constructor.invocation", new Object[0]);
            return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range(textRange).descriptionAndTooltip(description).create();
        }
        return null;
    }

    @NotNull
    public static TextRange getFixRange(@NotNull PsiElement element) {
        TextRange range = element.getTextRange();
        int start = range.getStartOffset();
        int end = range.getEndOffset();
        PsiElement nextSibling = element.getNextSibling();
        if (PsiUtil.isJavaToken((PsiElement)nextSibling, (IElementType)JavaTokenType.SEMICOLON)) {
            return new TextRange(start, end + 1);
        }
        return range;
    }

    static void checkNewExpression(@NotNull PsiNewExpression expression2, @Nullable PsiType type2, @NotNull HighlightInfoHolder holder, @NotNull JavaSdkVersion javaSdkVersion) {
        if (!(type2 instanceof PsiClassType)) {
            return;
        }
        PsiClassType.ClassResolveResult typeResult = ((PsiClassType)type2).resolveGenerics();
        PsiClass aClass = typeResult.getElement();
        if (aClass == null) {
            return;
        }
        if (aClass instanceof PsiAnonymousClass && (aClass = (typeResult = ((PsiClassType)(type2 = ((PsiAnonymousClass)aClass).getBaseClassType())).resolveGenerics()).getElement()) == null) {
            return;
        }
        PsiJavaCodeReferenceElement classReference2 = expression2.getClassOrAnonymousClassReference();
        HighlightMethodUtil.checkConstructorCall(typeResult, (PsiConstructorCall)expression2, type2, classReference2, holder, javaSdkVersion);
    }

    static void checkConstructorCall(@NotNull PsiClassType.ClassResolveResult typeResolveResult, @NotNull PsiConstructorCall constructorCall, @NotNull PsiType type2, @Nullable PsiJavaCodeReferenceElement classReference2, @NotNull HighlightInfoHolder holder, @NotNull JavaSdkVersion javaSdkVersion) {
        PsiExpression qualifier;
        PsiExpressionList list = constructorCall.getArgumentList();
        if (list == null) {
            return;
        }
        PsiClass aClass = typeResolveResult.getElement();
        if (aClass == null) {
            return;
        }
        PsiResolveHelper resolveHelper = JavaPsiFacade.getInstance((Project)holder.getProject()).getResolveHelper();
        PsiClass accessObjectClass = null;
        if (constructorCall instanceof PsiNewExpression && (qualifier = ((PsiNewExpression)constructorCall).getQualifier()) != null) {
            accessObjectClass = (PsiClass)PsiUtil.getAccessObjectClass((PsiExpression)qualifier).getElement();
        }
        if (classReference2 != null && !resolveHelper.isAccessible((PsiMember)aClass, (PsiElement)constructorCall, accessObjectClass)) {
            String description = HighlightUtil.accessProblemDescription((PsiElement)classReference2, (PsiElement)aClass, (JavaResolveResult)typeResolveResult);
            PsiElement element = (PsiElement)ObjectUtils.notNull((Object)classReference2.getReferenceNameElement(), (Object)classReference2);
            HighlightInfo info = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range(element).descriptionAndTooltip(description).create();
            HighlightFixUtil.registerAccessQuickFixAction((PsiJvmMember)aClass, classReference2, info, null);
            holder.add(info);
            return;
        }
        PsiMethod[] constructors = aClass.getConstructors();
        if (constructors.length == 0) {
            PsiReferenceParameterList typeArgumentList;
            if (!list.isEmpty()) {
                String constructorName = aClass.getName();
                String argTypes = HighlightMethodUtil.buildArgTypesList(list);
                String description = JavaErrorBundle.message("wrong.constructor.arguments", constructorName + "()", argTypes);
                String tooltip = HighlightMethodUtil.createMismatchedArgumentsHtmlTooltip(list, null, PsiParameter.EMPTY_ARRAY, PsiSubstitutor.EMPTY);
                HighlightInfo info = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)list).description(description).escapedToolTip(tooltip).navigationShift(1).create();
                QuickFixAction.registerQuickFixActions((HighlightInfo)info, (TextRange)constructorCall.getTextRange(), (Iterable)QUICK_FIX_FACTORY.createCreateConstructorFromUsageFixes(constructorCall));
                if (classReference2 != null && info != null) {
                    ConstructorParametersFixer.registerFixActions(classReference2, constructorCall, info, HighlightMethodUtil.getFixRange((PsiElement)list));
                }
                holder.add(info);
                return;
            }
            if (classReference2 != null && aClass.hasModifierProperty("protected") && HighlightMethodUtil.callingProtectedConstructorFromDerivedClass(constructorCall, aClass)) {
                holder.add(HighlightMethodUtil.buildAccessProblem(classReference2, (PsiJvmMember)aClass, (JavaResolveResult)typeResolveResult));
            } else if (aClass.isInterface() && constructorCall instanceof PsiNewExpression && (typeArgumentList = ((PsiNewExpression)constructorCall).getTypeArgumentList()).getTypeArguments().length > 0) {
                holder.add(HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)typeArgumentList).descriptionAndTooltip(JavaErrorBundle.message("anonymous.class.implements.interface.cannot.have.type.arguments", new Object[0])).create());
            }
        } else {
            PsiReferenceParameterList typeArgumentList;
            HighlightInfo info;
            PsiExpressionList infoElement;
            PsiAnonymousClass anonymousClass;
            PsiExpressionList place = list;
            if (constructorCall instanceof PsiNewExpression && (anonymousClass = ((PsiNewExpression)constructorCall).getAnonymousClass()) != null) {
                place = anonymousClass;
            }
            JavaResolveResult[] results = resolveHelper.multiResolveConstructor((PsiClassType)type2, list, (PsiElement)place);
            MethodCandidateInfo result = null;
            if (results.length == 1) {
                result = (MethodCandidateInfo)results[0];
            }
            PsiMethod constructor = result == null ? null : result.getElement();
            boolean applicable = true;
            try {
                JavaResolveResult staticFactory;
                PsiDiamondType diamondType = constructorCall instanceof PsiNewExpression ? PsiDiamondType.getDiamondType((PsiNewExpression)((PsiNewExpression)constructorCall)) : null;
                JavaResolveResult javaResolveResult = staticFactory = diamondType != null ? diamondType.getStaticFactory() : null;
                if (staticFactory instanceof MethodCandidateInfo) {
                    if (((MethodCandidateInfo)staticFactory).isApplicable()) {
                        result = (MethodCandidateInfo)staticFactory;
                        if (constructor == null) {
                            constructor = ((MethodCandidateInfo)staticFactory).getElement();
                        }
                    } else {
                        applicable = false;
                    }
                } else {
                    applicable = result != null && result.isApplicable();
                }
            }
            catch (IndexNotReadyException diamondType) {
                // empty catch block
            }
            Object object = infoElement = list.getTextLength() > 0 ? list : constructorCall;
            if (constructor == null) {
                String name2 = aClass.getName();
                name2 = name2 + HighlightMethodUtil.buildArgTypesList(list);
                String description = JavaErrorBundle.message("cannot.resolve.constructor", name2);
                HighlightInfo info2 = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)list).descriptionAndTooltip(description).navigationShift(1).create();
                if (info2 != null) {
                    WrapExpressionFix.registerWrapAction(results, list.getExpressions(), info2, HighlightMethodUtil.getFixRange((PsiElement)list));
                    HighlightMethodUtil.registerFixesOnInvalidConstructorCall(constructorCall, classReference2, list, aClass, constructors, results, (PsiElement)infoElement, info2);
                    holder.add(info2);
                }
            } else if (classReference2 != null && (!result.isAccessible() || constructor.hasModifierProperty("protected") && HighlightMethodUtil.callingProtectedConstructorFromDerivedClass(constructorCall, aClass))) {
                holder.add(HighlightMethodUtil.buildAccessProblem(classReference2, (PsiJvmMember)constructor, (JavaResolveResult)result));
            } else if (!applicable) {
                HighlightInfo info3 = HighlightMethodUtil.createIncompatibleCallHighlightInfo(holder, list, result);
                if (info3 != null) {
                    JavaResolveResult[] methodCandidates = results;
                    if (constructorCall instanceof PsiNewExpression) {
                        methodCandidates = resolveHelper.getReferencedMethodCandidates((PsiCallExpression)constructorCall, true);
                    }
                    HighlightMethodUtil.registerFixesOnInvalidConstructorCall(constructorCall, classReference2, list, aClass, constructors, methodCandidates, (PsiElement)infoElement, info3);
                    HighlightMethodUtil.registerMethodReturnFixAction(info3, result, (PsiCall)constructorCall);
                    holder.add(info3);
                }
            } else if (constructorCall instanceof PsiNewExpression && (info = GenericsHighlightUtil.checkReferenceTypeArgumentList((PsiTypeParameterListOwner)constructor, typeArgumentList = ((PsiNewExpression)constructorCall).getTypeArgumentList(), result.getSubstitutor(), false, javaSdkVersion)) != null) {
                holder.add(info);
            }
            if (result != null && !holder.hasErrorResults()) {
                holder.add(HighlightMethodUtil.checkVarargParameterErasureToBeAccessible(result, (PsiCall)constructorCall));
            }
        }
    }

    private static HighlightInfo checkVarargParameterErasureToBeAccessible(@NotNull MethodCandidateInfo info, @NotNull PsiCall place) {
        PsiMethod method = info.getElement();
        if (info.isVarargs() || method.isVarArgs() && !PsiUtil.isLanguageLevel8OrHigher((PsiElement)place)) {
            PsiParameter[] parameters2 = method.getParameterList().getParameters();
            PsiType componentType = ((PsiEllipsisType)parameters2[parameters2.length - 1].getType()).getComponentType();
            PsiType substitutedTypeErasure = TypeConversionUtil.erasure((PsiType)info.getSubstitutor().substitute(componentType));
            PsiClass targetClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)substitutedTypeErasure);
            if (targetClass != null && !PsiUtil.isAccessible((PsiMember)targetClass, (PsiElement)place, null)) {
                PsiExpressionList argumentList = place.getArgumentList();
                return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).descriptionAndTooltip(JavaErrorBundle.message("formal.varargs.element.type.inaccessible.here", PsiFormatUtil.formatClass((PsiClass)targetClass, (int)2048))).range((PsiElement)(argumentList != null ? argumentList : place)).create();
            }
        }
        return null;
    }

    private static void registerFixesOnInvalidConstructorCall(@NotNull PsiConstructorCall constructorCall, @Nullable PsiJavaCodeReferenceElement classReference2, @NotNull PsiExpressionList list, @NotNull PsiClass aClass, PsiMethod @NotNull [] constructors, JavaResolveResult @NotNull [] results, @NotNull PsiElement infoElement, @NotNull HighlightInfo info) {
        QuickFixAction.registerQuickFixActions((HighlightInfo)info, (TextRange)constructorCall.getTextRange(), (Iterable)QUICK_FIX_FACTORY.createCreateConstructorFromUsageFixes(constructorCall));
        if (classReference2 != null) {
            ConstructorParametersFixer.registerFixActions(classReference2, constructorCall, info, HighlightMethodUtil.getFixRange(infoElement));
            ChangeTypeArgumentsFix.registerIntentions(results, list, info, aClass);
            ConvertDoubleToFloatFix.registerIntentions(results, list, info, null);
        }
        if (!PermuteArgumentsFix.registerFix(info, (PsiCall)constructorCall, (CandidateInfo[])HighlightMethodUtil.toMethodCandidates(results), HighlightMethodUtil.getFixRange((PsiElement)list))) {
            HighlightMethodUtil.registerChangeMethodSignatureFromUsageIntentions(results, list, info, null);
        }
        HighlightMethodUtil.registerChangeParameterClassFix((PsiCall)constructorCall, list, info);
        QuickFixAction.registerQuickFixAction((HighlightInfo)info, (TextRange)HighlightMethodUtil.getFixRange((PsiElement)list), (IntentionAction)QUICK_FIX_FACTORY.createSurroundWithArrayFix((PsiCall)constructorCall, null));
        ChangeStringLiteralToCharInMethodCallFix.registerFixes(constructors, constructorCall, info);
    }

    private static HighlightInfo buildAccessProblem(@NotNull PsiJavaCodeReferenceElement ref, @NotNull PsiJvmMember resolved, @NotNull JavaResolveResult result) {
        String description = HighlightUtil.accessProblemDescription((PsiElement)ref, (PsiElement)resolved, result);
        HighlightInfo info = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)ref).descriptionAndTooltip(description).navigationShift(1).create();
        if (result.isStaticsScopeCorrect()) {
            HighlightFixUtil.registerAccessQuickFixAction(resolved, ref, info, result.getCurrentFileResolveScope());
        }
        return info;
    }

    private static boolean callingProtectedConstructorFromDerivedClass(@NotNull PsiConstructorCall place, @NotNull PsiClass constructorClass) {
        PsiClass aClass;
        if (place instanceof PsiNewExpression && ((PsiNewExpression)place).getAnonymousClass() != null) {
            return false;
        }
        PsiConstructorCall curElement = place;
        PsiClass containingClass = constructorClass.getContainingClass();
        do {
            if ((aClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)curElement, PsiClass.class)) == null) {
                return false;
            }
            curElement = aClass;
        } while (!aClass.isInheritor(constructorClass, true) && (containingClass == null || !aClass.isInheritor(containingClass, true)) || JavaPsiFacade.getInstance((Project)aClass.getProject()).arePackagesTheSame((PsiElement)aClass, (PsiElement)constructorClass));
        return true;
    }

    @NotNull
    private static String buildArgTypesList(@NotNull PsiExpressionList list) {
        StringBuilder builder = new StringBuilder();
        builder.append("(");
        PsiExpression[] args = list.getExpressions();
        for (int i = 0; i < args.length; ++i) {
            PsiType argType;
            if (i > 0) {
                builder.append(", ");
            }
            builder.append((argType = args[i].getType()) != null ? JavaHighlightUtil.formatType(argType) : "?");
        }
        builder.append(")");
        return builder.toString();
    }

    private static void registerChangeParameterClassFix(@NotNull PsiCall methodCall, @NotNull PsiExpressionList list, @Nullable HighlightInfo highlightInfo) {
        JavaResolveResult result = methodCall.resolveMethodGenerics();
        PsiMethod method = (PsiMethod)result.getElement();
        PsiSubstitutor substitutor = result.getSubstitutor();
        PsiExpression[] expressions2 = list.getExpressions();
        if (method == null) {
            return;
        }
        PsiParameter[] parameters2 = method.getParameterList().getParameters();
        if (parameters2.length != expressions2.length) {
            return;
        }
        for (int i = 0; i < expressions2.length; ++i) {
            PsiExpression expression2 = expressions2[i];
            PsiParameter parameter2 = parameters2[i];
            PsiType expressionType = expression2.getType();
            PsiType parameterType = substitutor.substitute(parameter2.getType());
            if (expressionType == null || expressionType instanceof PsiPrimitiveType || TypeConversionUtil.isNullType((PsiType)expressionType) || expressionType instanceof PsiArrayType || parameterType instanceof PsiPrimitiveType || TypeConversionUtil.isNullType((PsiType)parameterType) || parameterType instanceof PsiArrayType || parameterType.isAssignableFrom(expressionType)) continue;
            PsiClass parameterClass = PsiUtil.resolveClassInType((PsiType)parameterType);
            PsiClass expressionClass = PsiUtil.resolveClassInType((PsiType)expressionType);
            if (parameterClass == null || expressionClass == null || expressionClass instanceof PsiAnonymousClass || parameterClass.isInheritor(expressionClass, true)) continue;
            QuickFixAction.registerQuickFixAction((HighlightInfo)highlightInfo, (IntentionAction)QUICK_FIX_FACTORY.createChangeParameterClassFix(expressionClass, (PsiClassType)parameterType));
        }
    }

    private static void registerChangeMethodSignatureFromUsageIntentions(JavaResolveResult @NotNull [] candidates, @NotNull PsiExpressionList list, @Nullable HighlightInfo highlightInfo, @Nullable TextRange fixRange) {
        if (candidates.length == 0) {
            return;
        }
        PsiExpression[] expressions2 = list.getExpressions();
        for (JavaResolveResult candidate : candidates) {
            HighlightMethodUtil.registerChangeMethodSignatureFromUsageIntention(expressions2, highlightInfo, fixRange, candidate, (PsiElement)list);
        }
    }

    private static void registerChangeMethodSignatureFromUsageIntention(PsiExpression @NotNull [] expressions2, @Nullable HighlightInfo highlightInfo, @Nullable TextRange fixRange, @NotNull JavaResolveResult candidate, @NotNull PsiElement context) {
        if (!candidate.isStaticsScopeCorrect()) {
            return;
        }
        PsiMethod method = (PsiMethod)candidate.getElement();
        PsiSubstitutor substitutor = candidate.getSubstitutor();
        if (method != null && context.getManager().isInProject((PsiElement)method)) {
            IntentionAction fix = QUICK_FIX_FACTORY.createChangeMethodSignatureFromUsageFix(method, expressions2, substitutor, context, false, 2);
            QuickFixAction.registerQuickFixAction((HighlightInfo)highlightInfo, (TextRange)fixRange, (IntentionAction)fix);
            IntentionAction f2 = QUICK_FIX_FACTORY.createChangeMethodSignatureFromUsageReverseOrderFix(method, expressions2, substitutor, context, false, 2);
            QuickFixAction.registerQuickFixAction((HighlightInfo)highlightInfo, (TextRange)fixRange, (IntentionAction)f2);
        }
    }

    static PsiType determineReturnType(@NotNull PsiMethod method) {
        PsiManager manager = method.getManager();
        PsiReturnStatement[] returnStatements = PsiUtil.findReturnStatements((PsiMethod)method);
        if (returnStatements.length == 0) {
            return PsiType.VOID;
        }
        PsiType expectedType = null;
        for (PsiReturnStatement returnStatement : returnStatements) {
            ReturnModel returnModel = ReturnModel.create(returnStatement);
            if (returnModel == null) {
                return null;
            }
            expectedType = HighlightMethodUtil.lub(expectedType, returnModel.myLeastType, returnModel.myType, method, manager);
        }
        return expectedType;
    }

    @NotNull
    private static PsiType lub(@Nullable PsiType currentType, @NotNull PsiType leastValueType, @NotNull PsiType valueType, @NotNull PsiMethod method, @NotNull PsiManager manager) {
        if (currentType == null || PsiType.VOID.equals((Object)currentType)) {
            return valueType;
        }
        if (currentType == valueType) {
            return currentType;
        }
        if (TypeConversionUtil.isPrimitiveAndNotNull((PsiType)valueType)) {
            if (TypeConversionUtil.isPrimitiveAndNotNull((PsiType)currentType)) {
                int r2;
                int r1 = TypeConversionUtil.getTypeRank((PsiType)currentType);
                return r1 >= (r2 = TypeConversionUtil.getTypeRank((PsiType)leastValueType)) ? currentType : valueType;
            }
            PsiPrimitiveType unboxedType = PsiPrimitiveType.getUnboxedType((PsiType)currentType);
            if (valueType.equals(unboxedType)) {
                return currentType;
            }
            PsiClassType boxedType = ((PsiPrimitiveType)valueType).getBoxedType((PsiElement)method);
            if (boxedType == null) {
                return valueType;
            }
            valueType = boxedType;
        }
        if (TypeConversionUtil.isPrimitiveAndNotNull((PsiType)currentType)) {
            currentType = ((PsiPrimitiveType)currentType).getBoxedType((PsiElement)method);
        }
        return Objects.requireNonNull(GenericsUtil.getLeastUpperBound((PsiType)currentType, (PsiType)valueType, (PsiManager)manager));
    }

    static HighlightInfo checkRecordAccessorDeclaration(PsiMethod method) {
        PsiRecordComponent component = JavaPsiRecordUtil.getRecordComponentForAccessor(method);
        if (component == null) {
            return null;
        }
        PsiIdentifier identifier = method.getNameIdentifier();
        if (identifier == null) {
            return null;
        }
        PsiType componentType = component.getType();
        PsiType methodType = method.getReturnType();
        if (methodType == null) {
            return null;
        }
        if (componentType instanceof PsiEllipsisType) {
            componentType = ((PsiEllipsisType)componentType).getComponentType().createArrayType();
        }
        if (!componentType.equals(methodType)) {
            String message2 = JavaErrorBundle.message("record.accessor.wrong.return.type", componentType.getPresentableText(), methodType.getPresentableText());
            HighlightInfo info = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)Objects.requireNonNull(method.getReturnTypeElement())).descriptionAndTooltip(message2).create();
            QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)QUICK_FIX_FACTORY.createMethodReturnFix(method, componentType, false));
            return info;
        }
        return HighlightMethodUtil.checkRecordSpecialMethodDeclaration(method, JavaErrorBundle.message("record.accessor", new Object[0]));
    }

    @NotNull
    static List<HighlightInfo> checkRecordConstructorDeclaration(@NotNull PsiMethod method) {
        if (!method.isConstructor()) {
            return Collections.emptyList();
        }
        PsiClass aClass = method.getContainingClass();
        if (aClass == null) {
            return Collections.emptyList();
        }
        PsiIdentifier identifier = method.getNameIdentifier();
        if (identifier == null) {
            return Collections.emptyList();
        }
        if (!aClass.isRecord()) {
            if (JavaPsiRecordUtil.isCompactConstructor(method)) {
                HighlightInfo info = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)identifier).descriptionAndTooltip(JavaErrorBundle.message("compact.constructor.in.regular.class", new Object[0])).create();
                QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)QUICK_FIX_FACTORY.createAddParameterListFix(method));
                return Collections.singletonList(info);
            }
            return Collections.emptyList();
        }
        if (JavaPsiRecordUtil.isExplicitCanonicalConstructor(method)) {
            PsiParameter[] parameters2 = method.getParameterList().getParameters();
            PsiRecordComponent[] components = aClass.getRecordComponents();
            ArrayList<HighlightInfo> problems = new ArrayList<HighlightInfo>();
            assert (parameters2.length == components.length);
            for (int i = 0; i < parameters2.length; ++i) {
                HighlightInfo info;
                String message2;
                PsiType componentType = components[i].getType();
                PsiType parameterType = parameters2[i].getType();
                String componentName = components[i].getName();
                String parameterName = parameters2[i].getName();
                if (!parameterType.equals(componentType)) {
                    message2 = JavaErrorBundle.message("record.canonical.constructor.wrong.parameter.type", componentName, componentType.getPresentableText(), parameterType.getPresentableText());
                    info = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)Objects.requireNonNull(parameters2[i].getTypeElement())).descriptionAndTooltip(message2).create();
                    QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)QUICK_FIX_FACTORY.createMethodParameterTypeFix(method, i, componentType, false));
                    problems.add(info);
                }
                if (componentName == null || parameterName.equals(componentName)) continue;
                message2 = JavaErrorBundle.message("record.canonical.constructor.wrong.parameter.name", componentName, parameterName);
                info = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)Objects.requireNonNull(parameters2[i].getNameIdentifier())).descriptionAndTooltip(message2).create();
                if (Arrays.stream(parameters2).map(PsiParameter::getName).noneMatch(Predicate.isEqual(componentName))) {
                    QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)QUICK_FIX_FACTORY.createRenameElementFix((PsiNamedElement)parameters2[i], componentName));
                }
                problems.add(info);
            }
            ContainerUtil.addIfNotNull(problems, (Object)HighlightMethodUtil.checkRecordSpecialMethodDeclaration(method, JavaErrorBundle.message("record.canonical.constructor", new Object[0])));
            return problems;
        }
        if (JavaPsiRecordUtil.isCompactConstructor(method)) {
            return Collections.singletonList(HighlightMethodUtil.checkRecordSpecialMethodDeclaration(method, JavaErrorBundle.message("record.compact.constructor", new Object[0])));
        }
        PsiMethodCallExpression call = JavaPsiConstructorUtil.findThisOrSuperCallInConstructor((PsiMethod)method);
        if (call == null || JavaPsiConstructorUtil.isSuperConstructorCall((PsiElement)call)) {
            String message3 = JavaErrorBundle.message("record.no.constructor.call.in.non.canonical", new Object[0]);
            return Collections.singletonList(HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)identifier).descriptionAndTooltip(message3).create());
        }
        return Collections.emptyList();
    }

    @Nullable
    private static HighlightInfo checkRecordSpecialMethodDeclaration(PsiMethod method, String methodTitle) {
        PsiReferenceList throwsList;
        PsiIdentifier identifier = method.getNameIdentifier();
        if (identifier == null) {
            return null;
        }
        PsiTypeParameterList typeParameterList = method.getTypeParameterList();
        if (typeParameterList != null && typeParameterList.getTypeParameters().length > 0) {
            HighlightInfo info = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)typeParameterList).descriptionAndTooltip(JavaErrorBundle.message("record.special.method.type.parameters", methodTitle)).create();
            QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)QUICK_FIX_FACTORY.createDeleteFix((PsiElement[])typeParameterList.getTypeParameters()));
            return info;
        }
        if (method.isConstructor() && PsiUtil.getLanguageLevel((PsiElement)method) != LanguageLevel.JDK_14_PREVIEW) {
            AccessModifier classModifier;
            AccessModifier modifier = AccessModifier.fromModifierList(method.getModifierList());
            PsiModifierList classModifierList = Objects.requireNonNull(method.getContainingClass()).getModifierList();
            if (classModifierList != null && (classModifier = AccessModifier.fromModifierList(classModifierList)).isWeaker(modifier)) {
                HighlightInfo info = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)identifier).descriptionAndTooltip(JavaErrorBundle.message("record.special.method.stronger.access", new Object[]{methodTitle, classModifier})).create();
                QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)QUICK_FIX_FACTORY.createModifierListFix((PsiModifierListOwner)method, classModifier.toPsiModifier(), true, false));
                return info;
            }
        } else if (!method.hasModifierProperty("public")) {
            HighlightInfo info = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)identifier).descriptionAndTooltip(JavaErrorBundle.message("record.special.method.non.public", methodTitle)).create();
            QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)QUICK_FIX_FACTORY.createModifierListFix((PsiModifierListOwner)method, "public", true, false));
            return info;
        }
        if ((throwsList = method.getThrowsList()).getReferenceElements().length > 0) {
            HighlightInfo info = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.ERROR).range((PsiElement)throwsList).descriptionAndTooltip(JavaErrorBundle.message("record.special.method.throws", methodTitle)).create();
            QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)QUICK_FIX_FACTORY.createDeleteFix((PsiElement[])throwsList.getReferenceElements()));
            return info;
        }
        return null;
    }

    private static class ReturnModel {
        final PsiReturnStatement myStatement;
        final PsiType myType;
        final PsiType myLeastType;

        @Contract(pure=true)
        private ReturnModel(@NotNull PsiReturnStatement statement, @NotNull PsiType type2) {
            this.myStatement = statement;
            this.myType = this.myLeastType = type2;
        }

        @Contract(pure=true)
        private ReturnModel(@NotNull PsiReturnStatement statement, @NotNull PsiType type2, @NotNull PsiType leastType) {
            this.myStatement = statement;
            this.myType = type2;
            this.myLeastType = leastType;
        }

        @Nullable
        private static ReturnModel create(@NotNull PsiReturnStatement statement) {
            PsiExpression value2 = statement.getReturnValue();
            if (value2 == null) {
                return new ReturnModel(statement, (PsiType)PsiType.VOID);
            }
            if (ExpressionUtils.nonStructuralChildren(value2).anyMatch(c -> c instanceof PsiFunctionalExpression)) {
                return null;
            }
            PsiType type2 = RefactoringChangeUtil.getTypeByExpression(value2);
            if (type2 == null || type2 instanceof PsiClassType && ((PsiClassType)type2).resolve() == null) {
                return null;
            }
            return new ReturnModel(statement, type2, ReturnModel.getLeastValueType(value2, type2));
        }

        @NotNull
        private static PsiType getLeastValueType(@NotNull PsiExpression returnValue, @NotNull PsiType type2) {
            if (type2 instanceof PsiPrimitiveType) {
                int rank = TypeConversionUtil.getTypeRank((PsiType)type2);
                if (rank < 1 || rank > 4) {
                    return type2;
                }
                PsiConstantEvaluationHelper evaluator = JavaPsiFacade.getInstance((Project)returnValue.getProject()).getConstantEvaluationHelper();
                Object res = evaluator.computeConstantExpression((PsiElement)returnValue);
                if (res instanceof Number) {
                    long value2 = ((Number)res).longValue();
                    if (-128L <= value2 && value2 <= 127L) {
                        return PsiType.BYTE;
                    }
                    if (-32768L <= value2 && value2 <= 32767L) {
                        return PsiType.SHORT;
                    }
                    if (0L <= value2 && value2 <= 65535L) {
                        return PsiType.CHAR;
                    }
                }
            }
            return type2;
        }
    }
}

