/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.daemon.DaemonBundle;
import com.intellij.codeInsight.daemon.GutterIconNavigationHandler;
import com.intellij.codeInsight.daemon.impl.GutterTooltipHelper;
import com.intellij.codeInsight.daemon.impl.LineMarkerNavigator;
import com.intellij.codeInsight.daemon.impl.PsiElementListNavigator;
import com.intellij.codeInsight.navigation.BackgroundUpdaterTask;
import com.intellij.ide.util.MethodCellRenderer;
import com.intellij.ide.util.MethodOrFunctionalExpressionCellRenderer;
import com.intellij.ide.util.PsiClassListCellRenderer;
import com.intellij.ide.util.PsiClassOrFunctionalExpressionListCellRenderer;
import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.java.JavaBundle;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.impl.FindSuperElementsHelper;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.search.PsiElementProcessorAdapter;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.search.searches.FunctionalExpressionSearch;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ArrayUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JComponent;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MarkerType {
    private final GutterIconNavigationHandler<PsiElement> handler;
    private final Function<PsiElement, String> myTooltip;
    @NotNull
    private final String myDebugName;
    public static final MarkerType OVERRIDING_METHOD = new MarkerType("OVERRIDING_METHOD", (Function<PsiElement, String>)((NullableFunction)element -> {
        PsiMethod method;
        PsiElement parent = MarkerType.getParentMethod(element);
        if (!(parent instanceof PsiMethod)) {
            return null;
        }
        return MarkerType.calculateOverridingMethodTooltip(method, (method = (PsiMethod)parent) != element.getParent());
    }), new LineMarkerNavigator(){

        @Override
        public void browse(MouseEvent e, PsiElement element) {
            PsiMethod method;
            PsiElement parent = MarkerType.getParentMethod(element);
            if (!(parent instanceof PsiMethod)) {
                return;
            }
            MarkerType.navigateToOverridingMethod(e, method, (method = (PsiMethod)parent) != element.getParent());
        }
    });
    public static final MarkerType SIBLING_OVERRIDING_METHOD = new MarkerType("SIBLING_OVERRIDING_METHOD", (Function<PsiElement, String>)((NullableFunction)element -> {
        PsiElement parent = MarkerType.getParentMethod(element);
        if (!(parent instanceof PsiMethod)) {
            return null;
        }
        PsiMethod method = (PsiMethod)parent;
        return MarkerType.calculateOverridingSiblingMethodTooltip(method);
    }), new LineMarkerNavigator(){

        @Override
        public void browse(MouseEvent e, PsiElement element) {
            PsiElement parent = MarkerType.getParentMethod(element);
            if (!(parent instanceof PsiMethod)) {
                return;
            }
            PsiMethod method = (PsiMethod)parent;
            MarkerType.navigateToSiblingOverridingMethod(e, method);
        }
    });
    public static final String SEARCHING_FOR_OVERRIDING_METHODS = "Searching for Overriding Methods";
    public static final MarkerType OVERRIDDEN_METHOD = new MarkerType("OVERRIDDEN_METHOD", (Function<PsiElement, String>)((NullableFunction)element -> {
        PsiElement parent = element.getParent();
        if (!(parent instanceof PsiMethod)) {
            return null;
        }
        PsiMethod method = (PsiMethod)parent;
        return MarkerType.getOverriddenMethodTooltip(method);
    }), new LineMarkerNavigator(){

        @Override
        public void browse(MouseEvent e, PsiElement element) {
            PsiElement parent = element.getParent();
            if (!(parent instanceof PsiMethod)) {
                return;
            }
            MarkerType.navigateToOverriddenMethod(e, (PsiMethod)parent);
        }
    });
    private static final String SEARCHING_FOR_OVERRIDDEN_METHODS = "Searching for Overridden Methods";
    public static final MarkerType SUBCLASSED_CLASS = new MarkerType("SUBCLASSED_CLASS", (Function<PsiElement, String>)((NullableFunction)element -> {
        PsiElement parent = element.getParent();
        if (!(parent instanceof PsiClass)) {
            return null;
        }
        PsiClass aClass = (PsiClass)parent;
        return MarkerType.getSubclassedClassTooltip(aClass);
    }), new LineMarkerNavigator(){

        @Override
        public void browse(MouseEvent e, PsiElement element) {
            PsiElement parent = element.getParent();
            if (!(parent instanceof PsiClass)) {
                return;
            }
            PsiClass aClass = (PsiClass)parent;
            MarkerType.navigateToSubclassedClass(e, aClass);
        }
    });

    @Deprecated
    public MarkerType(@NotNull Function<PsiElement, String> tooltip, @NotNull LineMarkerNavigator navigator) {
        this("Unknown", tooltip, navigator);
    }

    public MarkerType(@NotNull String debugName, @NotNull Function<PsiElement, String> tooltip, @NotNull LineMarkerNavigator navigator) {
        this.myTooltip = tooltip;
        this.myDebugName = debugName;
        this.handler = (e, elt) -> DumbService.getInstance((Project)elt.getProject()).withAlternativeResolveEnabled(() -> navigator.browse(e, elt));
    }

    public String toString() {
        return this.myDebugName;
    }

    @NotNull
    public GutterIconNavigationHandler<PsiElement> getNavigationHandler() {
        return this.handler;
    }

    @NotNull
    public Function<PsiElement, String> getTooltip() {
        return this.myTooltip;
    }

    @Nullable
    private static String calculateOverridingMethodTooltip(@NotNull PsiMethod method, boolean acceptSelf) {
        PsiMethod[] superMethods = MarkerType.composeSuperMethods(method, acceptSelf);
        if (superMethods.length == 0) {
            return null;
        }
        String divider = GutterTooltipHelper.getElementDivider(false, false, superMethods.length);
        AtomicReference<String> reference = new AtomicReference<String>("");
        return GutterTooltipHelper.getTooltipText(Arrays.asList(superMethods), superMethod -> MarkerType.getTooltipPrefix(method, superMethod, reference.getAndSet(divider)), superMethod -> MarkerType.isSameSignature(method, superMethod), "GotoSuperMethod");
    }

    @Nullable
    private static String calculateOverridingSiblingMethodTooltip(@NotNull PsiMethod method) {
        FindSuperElementsHelper.SiblingInfo pair2 = FindSuperElementsHelper.getSiblingInfoInheritedViaSubClass(method);
        if (pair2 == null) {
            return null;
        }
        return GutterTooltipHelper.getTooltipText(Arrays.asList(pair2.superMethod, pair2.subClass), element -> element instanceof PsiMethod ? MarkerType.getTooltipPrefix(method, (PsiMethod)element, "") : " via subclass ", element -> element instanceof PsiMethod && MarkerType.isSameSignature(method, (PsiMethod)element), "GotoSuperMethod");
    }

    @NotNull
    private static String getTooltipPrefix(@NotNull PsiMethod method, @NotNull PsiMethod superMethod, @NotNull String prefix) {
        StringBuilder sb = new StringBuilder(prefix);
        boolean isAbstract = method.hasModifierProperty("abstract");
        boolean isSuperAbstract = superMethod.hasModifierProperty("abstract");
        sb.append(isSuperAbstract && !isAbstract ? "Implements method " : "Overrides method ");
        if (MarkerType.isSameSignature(method, superMethod)) {
            sb.append("in ");
        }
        return sb.toString();
    }

    private static boolean isSameSignature(@NotNull PsiMethod method, @NotNull PsiMethod superMethod) {
        return method.getSignature(PsiSubstitutor.EMPTY).equals(superMethod.getSignature(PsiSubstitutor.EMPTY));
    }

    @NotNull
    private static <E extends PsiElement> PsiElementProcessor.CollectElementsWithLimit<E> getProcessor(int limit, boolean set) {
        return set ? new PsiElementProcessor.CollectElementsWithLimit(limit, (Collection)new THashSet()) : new PsiElementProcessor.CollectElementsWithLimit(limit);
    }

    private static String getFunctionalImplementationTooltip(@NotNull PsiClass psiClass) {
        PsiElementProcessor.CollectElementsWithLimit processor2 = MarkerType.getProcessor(5, true);
        FunctionalExpressionSearch.search((PsiClass)psiClass).forEach((Processor)new PsiElementProcessorAdapter(processor2));
        if (processor2.isOverflow()) {
            return MarkerType.getImplementationTooltip("Has several functional implementations", new PsiElement[0]);
        }
        if (processor2.getCollection().isEmpty()) {
            return null;
        }
        return MarkerType.getImplementationTooltip(processor2.getCollection(), "Is functionally implemented in");
    }

    @NotNull
    private static String getImplementationTooltip(@NotNull String prefix, PsiElement ... elements) {
        return MarkerType.getImplementationTooltip(Arrays.asList(elements), prefix);
    }

    @NotNull
    private static String getImplementationTooltip(@NotNull Collection<? extends PsiElement> elements, @NotNull String prefix) {
        return GutterTooltipHelper.getTooltipText(elements, prefix, true, "GotoImplementation");
    }

    private static void navigateToOverridingMethod(MouseEvent e, @NotNull PsiMethod method, boolean acceptSelf) {
        PsiMethod[] superMethods = MarkerType.composeSuperMethods(method, acceptSelf);
        if (superMethods.length == 0) {
            return;
        }
        boolean showMethodNames = !PsiUtil.allMethodsHaveSameSignature((PsiMethod[])superMethods);
        PsiElementListNavigator.openTargets((MouseEvent)e, (NavigatablePsiElement[])superMethods, (String)DaemonBundle.message((String)"navigation.title.super.method", (Object[])new Object[]{method.getName()}), (String)DaemonBundle.message((String)"navigation.findUsages.title.super.method", (Object[])new Object[]{method.getName()}), (ListCellRenderer)((Object)new MethodCellRenderer(showMethodNames)));
    }

    private static void navigateToSiblingOverridingMethod(MouseEvent e, @NotNull PsiMethod method) {
        PsiMethod superMethod = FindSuperElementsHelper.getSiblingInheritedViaSubClass(method);
        if (superMethod == null) {
            return;
        }
        PsiElementListNavigator.openTargets((MouseEvent)e, (NavigatablePsiElement[])new PsiMethod[]{superMethod}, (String)DaemonBundle.message((String)"navigation.title.super.method", (Object[])new Object[]{method.getName()}), (String)DaemonBundle.message((String)"navigation.findUsages.title.super.method", (Object[])new Object[]{method.getName()}), (ListCellRenderer)((Object)new MethodCellRenderer(false)));
    }

    private static PsiMethod @NotNull [] composeSuperMethods(@NotNull PsiMethod method, boolean acceptSelf) {
        Object[] superElements = FindSuperElementsHelper.findSuperElements((PsiElement)method);
        Object[] superMethods = (PsiMethod[])ContainerUtil.map((Object[])superElements, element -> (PsiMethod)element, (Object[])PsiMethod.EMPTY_ARRAY);
        if (acceptSelf) {
            superMethods = (PsiMethod[])ArrayUtil.prepend((Object)method, (Object[])superMethods);
        }
        return superMethods;
    }

    private static PsiElement getParentMethod(@NotNull PsiElement element) {
        PsiElement parent = element.getParent();
        PsiMethod interfaceMethod = LambdaUtil.getFunctionalInterfaceMethod((PsiElement)parent);
        return interfaceMethod != null ? interfaceMethod : parent;
    }

    private static String getOverriddenMethodTooltip(@NotNull PsiMethod method) {
        PsiClass aClass = method.getContainingClass();
        if (aClass != null && "java.lang.Object".equals(aClass.getQualifiedName())) {
            return MarkerType.getImplementationTooltip("Is implemented in several subclasses", new PsiElement[0]);
        }
        PsiElementProcessor.CollectElementsWithLimit processor2 = MarkerType.getProcessor(5, false);
        GlobalSearchScope scope = GlobalSearchScope.allScope((Project)PsiUtilCore.getProjectInReadAction((PsiElement)method));
        OverridingMethodsSearch.search((PsiMethod)method, (SearchScope)scope, (boolean)true).forEach((Processor)new PsiElementProcessorAdapter(processor2));
        boolean isAbstract = method.hasModifierProperty("abstract");
        if (processor2.isOverflow()) {
            return MarkerType.getImplementationTooltip(isAbstract ? "Is implemented in several subclasses" : "Is overridden in several subclasses", new PsiElement[0]);
        }
        PsiMethod[] overridings = (PsiMethod[])processor2.toArray((PsiElement[])PsiMethod.EMPTY_ARRAY);
        if (overridings.length == 0) {
            return !isAbstract || aClass == null ? null : MarkerType.getFunctionalImplementationTooltip(aClass);
        }
        Comparator comparator = new MethodCellRenderer(false).getComparator();
        Arrays.sort(overridings, comparator);
        return MarkerType.getImplementationTooltip(isAbstract ? "Is implemented in" : "Is overridden in", (PsiElement[])overridings);
    }

    private static void navigateToOverriddenMethod(MouseEvent e, @NotNull PsiMethod method) {
        if (DumbService.isDumb((Project)method.getProject())) {
            DumbService.getInstance((Project)method.getProject()).showDumbModeNotification(JavaBundle.message((String)"notification.navigation.to.overriding.classes", (Object[])new Object[0]));
            return;
        }
        PsiElementProcessor.CollectElementsWithLimit collectProcessor = MarkerType.getProcessor(2, true);
        PsiElementProcessor.CollectElementsWithLimit collectExprProcessor = MarkerType.getProcessor(2, true);
        boolean isAbstract = method.hasModifierProperty("abstract");
        if (!ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
            GlobalSearchScope scope = GlobalSearchScope.allScope((Project)PsiUtilCore.getProjectInReadAction((PsiElement)method));
            OverridingMethodsSearch.search((PsiMethod)method, (SearchScope)scope, (boolean)true).forEach((Processor)new PsiElementProcessorAdapter((PsiElementProcessor)collectProcessor));
            if (isAbstract && collectProcessor.getCollection().size() < 2) {
                PsiClass aClass = (PsiClass)ReadAction.compute(() -> ((PsiMethod)method).getContainingClass());
                if (aClass != null) {
                    FunctionalExpressionSearch.search((PsiClass)aClass).forEach((Processor)new PsiElementProcessorAdapter((PsiElementProcessor)collectExprProcessor));
                }
            }
        }, SEARCHING_FOR_OVERRIDING_METHODS, true, method.getProject(), (JComponent)e.getComponent())) {
            return;
        }
        PsiMethod[] methodOverriders = (PsiMethod[])collectProcessor.toArray((PsiElement[])PsiMethod.EMPTY_ARRAY);
        ArrayList overridings = new ArrayList();
        overridings.addAll(collectProcessor.getCollection());
        overridings.addAll(collectExprProcessor.getCollection());
        if (overridings.isEmpty()) {
            return;
        }
        boolean showMethodNames = !PsiUtil.allMethodsHaveSameSignature((PsiMethod[])methodOverriders);
        MethodOrFunctionalExpressionCellRenderer renderer = new MethodOrFunctionalExpressionCellRenderer(showMethodNames);
        overridings.sort(renderer.getComparator());
        OverridingMethodsUpdater methodsUpdater = new OverridingMethodsUpdater(method, renderer);
        PsiElementListNavigator.openTargets((MouseEvent)e, (NavigatablePsiElement[])overridings.toArray(NavigatablePsiElement.EMPTY_NAVIGATABLE_ELEMENT_ARRAY), (String)methodsUpdater.getCaption(overridings.size()), (String)("Overriding methods of " + method.getName()), (ListCellRenderer)((Object)renderer), (BackgroundUpdaterTask)methodsUpdater);
    }

    public static String getSubclassedClassTooltip(@NotNull PsiClass aClass) {
        PsiElementProcessor.CollectElementsWithLimit processor2 = MarkerType.getProcessor(5, true);
        ClassInheritorsSearch.search((PsiClass)aClass).forEach((Processor)new PsiElementProcessorAdapter(processor2));
        if (processor2.isOverflow()) {
            return MarkerType.getImplementationTooltip(aClass.isInterface() ? "Is implemented by several subclasses" : "Is overridden by several subclasses", new PsiElement[0]);
        }
        PsiClass[] subclasses = (PsiClass[])processor2.toArray((PsiElement[])PsiClass.EMPTY_ARRAY);
        if (subclasses.length == 0) {
            return MarkerType.getFunctionalImplementationTooltip(aClass);
        }
        Comparator comparator = new PsiClassListCellRenderer().getComparator();
        Arrays.sort(subclasses, comparator);
        return MarkerType.getImplementationTooltip(aClass.isInterface() ? "Is implemented by" : "Is subclassed by", (PsiElement[])subclasses);
    }

    public static void navigateToSubclassedClass(MouseEvent e, @NotNull PsiClass aClass) {
        MarkerType.navigateToSubclassedClass(e, aClass, new PsiClassOrFunctionalExpressionListCellRenderer());
    }

    public static void navigateToSubclassedClass(MouseEvent e, @NotNull PsiClass aClass, PsiElementListCellRenderer<NavigatablePsiElement> renderer) {
        if (DumbService.isDumb((Project)aClass.getProject())) {
            DumbService.getInstance((Project)aClass.getProject()).showDumbModeNotification(JavaBundle.message((String)"notification.navigation.to.overriding.methods", (Object[])new Object[0]));
            return;
        }
        PsiElementProcessor.FindElement collectProcessor = new PsiElementProcessor.FindElement();
        PsiElementProcessor.FindElement collectExprProcessor = new PsiElementProcessor.FindElement();
        if (!ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
            ClassInheritorsSearch.search((PsiClass)aClass).forEach((Processor)new PsiElementProcessorAdapter((PsiElementProcessor)collectProcessor));
            if (collectProcessor.getFoundElement() == null) {
                FunctionalExpressionSearch.search((PsiClass)aClass).forEach((Processor)new PsiElementProcessorAdapter((PsiElementProcessor)collectExprProcessor));
            }
        }, SEARCHING_FOR_OVERRIDDEN_METHODS, true, aClass.getProject(), (JComponent)e.getComponent())) {
            return;
        }
        ArrayList inheritors = new ArrayList();
        ContainerUtil.addIfNotNull(inheritors, (Object)collectProcessor.getFoundElement());
        ContainerUtil.addIfNotNull(inheritors, (Object)collectExprProcessor.getFoundElement());
        if (inheritors.isEmpty()) {
            return;
        }
        SubclassUpdater subclassUpdater = new SubclassUpdater(aClass, renderer);
        inheritors.sort(renderer.getComparator());
        PsiElementListNavigator.openTargets((MouseEvent)e, (NavigatablePsiElement[])inheritors.toArray(NavigatablePsiElement.EMPTY_NAVIGATABLE_ELEMENT_ARRAY), (String)subclassUpdater.getCaption(inheritors.size()), (String)CodeInsightBundle.message((String)"goto.implementation.findUsages.title", (Object[])new Object[]{aClass.getName()}), renderer, (BackgroundUpdaterTask)subclassUpdater);
    }

    private static class OverridingMethodsUpdater
    extends OverridingMembersUpdater {
        private final PsiMethod myMethod;

        private OverridingMethodsUpdater(@NotNull PsiMethod method, @NotNull PsiElementListCellRenderer<NavigatablePsiElement> renderer) {
            super(method.getProject(), MarkerType.SEARCHING_FOR_OVERRIDING_METHODS, renderer);
            this.myMethod = method;
        }

        public String getCaption(int size) {
            return DaemonBundle.message((String)(this.myMethod.hasModifierProperty("abstract") ? "navigation.title.implementation.method" : "navigation.title.overrider.method"), (Object[])new Object[]{this.myMethod.getName(), size});
        }

        public void onSuccess() {
            super.onSuccess();
            PsiElement oneElement = this.getTheOnlyOneElement();
            if (oneElement instanceof NavigatablePsiElement) {
                ((NavigatablePsiElement)oneElement).navigate(true);
                this.myPopup.cancel();
            }
        }

        public void run(final @NotNull ProgressIndicator indicator) {
            super.run(indicator);
            GlobalSearchScope scope = GlobalSearchScope.allScope((Project)PsiUtilCore.getProjectInReadAction((PsiElement)this.myMethod));
            OverridingMethodsSearch.search((PsiMethod)this.myMethod, (SearchScope)scope, (boolean)true).forEach((Processor)new CommonProcessors.CollectProcessor<PsiMethod>(){

                public boolean process(PsiMethod psiMethod) {
                    if (!this.updateComponent((PsiElement)psiMethod)) {
                        indicator.cancel();
                    }
                    ProgressManager.checkCanceled();
                    return super.process((Object)psiMethod);
                }
            });
            if (((Boolean)ReadAction.compute(() -> this.myMethod.hasModifierProperty("abstract"))).booleanValue()) {
                this.collectFunctionalInheritors(indicator, (PsiClass)ReadAction.compute(() -> ((PsiMethod)this.myMethod).getContainingClass()));
            }
        }
    }

    private static class SubclassUpdater
    extends OverridingMembersUpdater {
        private final PsiClass myClass;

        private SubclassUpdater(@NotNull PsiClass aClass, @NotNull PsiElementListCellRenderer<NavigatablePsiElement> renderer) {
            super(aClass.getProject(), MarkerType.SEARCHING_FOR_OVERRIDDEN_METHODS, renderer);
            this.myClass = aClass;
        }

        public String getCaption(int size) {
            String suffix = this.isFinished() ? "" : " so far";
            return this.myClass.isInterface() ? CodeInsightBundle.message((String)"goto.implementation.chooserTitle", (Object[])new Object[]{this.myClass.getName(), size, suffix}) : DaemonBundle.message((String)"navigation.title.subclass", (Object[])new Object[]{this.myClass.getName(), size, suffix});
        }

        public void onSuccess() {
            super.onSuccess();
            PsiElement oneElement = this.getTheOnlyOneElement();
            if (oneElement instanceof NavigatablePsiElement) {
                ((NavigatablePsiElement)oneElement).navigate(true);
                this.myPopup.cancel();
            }
        }

        public void run(final @NotNull ProgressIndicator indicator) {
            super.run(indicator);
            ClassInheritorsSearch.search((PsiClass)this.myClass, (SearchScope)((SearchScope)ReadAction.compute(() -> ((PsiClass)this.myClass).getUseScope())), (boolean)true).forEach((Processor)new CommonProcessors.CollectProcessor<PsiClass>(){

                public boolean process(PsiClass o) {
                    if (!this.updateComponent((PsiElement)o)) {
                        indicator.cancel();
                    }
                    ProgressManager.checkCanceled();
                    return super.process((Object)o);
                }
            });
            this.collectFunctionalInheritors(indicator, this.myClass);
        }
    }

    private static abstract class OverridingMembersUpdater
    extends BackgroundUpdaterTask {
        private OverridingMembersUpdater(@Nullable Project project, @NotNull String title, @NotNull PsiElementListCellRenderer<NavigatablePsiElement> renderer) {
            super(project, title, OverridingMembersUpdater.createComparatorWrapper((Comparator)renderer.getComparator()));
        }

        void collectFunctionalInheritors(@NotNull ProgressIndicator indicator, PsiClass psiClass) {
            FunctionalExpressionSearch.search((PsiClass)psiClass).forEach(expr2 -> {
                if (!this.updateComponent((PsiElement)expr2)) {
                    indicator.cancel();
                }
                ProgressManager.checkCanceled();
                return true;
            });
        }
    }
}

