/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.ProjectSdkSetupValidator;
import com.intellij.ide.JavaUiBundle;
import com.intellij.ide.highlighter.JavaClassFileType;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkType;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ui.configuration.SdkPopupBuilder;
import com.intellij.openapi.roots.ui.configuration.SdkPopupFactory;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.EditorNotificationPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaProjectSdkSetupValidator
implements ProjectSdkSetupValidator {
    public static final JavaProjectSdkSetupValidator INSTANCE = new JavaProjectSdkSetupValidator();

    public boolean isApplicableFor(@NotNull Project project, @NotNull VirtualFile file) {
        PsiFile psiFile;
        if (file.getFileType() != JavaClassFileType.INSTANCE && (psiFile = PsiManager.getInstance((Project)project).findFile(file)) != null) {
            return psiFile.getLanguage().isKindOf((Language)JavaLanguage.INSTANCE);
        }
        return false;
    }

    @Nullable
    public String getErrorMessage(@NotNull Project project, @NotNull VirtualFile file) {
        Sdk sdk;
        Module module = ModuleUtilCore.findModuleForFile((VirtualFile)file, (Project)project);
        if (module != null && !module.isDisposed() && (sdk = ModuleRootManager.getInstance((Module)module).getSdk()) == null) {
            if (ModuleRootManager.getInstance((Module)module).isSdkInherited()) {
                return JavaUiBundle.message("project.sdk.not.defined", new Object[0]);
            }
            return JavaUiBundle.message("module.sdk.not.defined", new Object[0]);
        }
        return null;
    }

    @NotNull
    private static SdkPopupBuilder preparePopup(@NotNull Project project, @NotNull VirtualFile file) {
        return SdkPopupFactory.newBuilder().withProject(project).withSdkTypeFilter(type2 -> type2 instanceof JavaSdkType).updateSdkForFile(file);
    }

    @NotNull
    public EditorNotificationPanel.ActionHandler getFixHandler(@NotNull Project project, @NotNull VirtualFile file) {
        return JavaProjectSdkSetupValidator.preparePopup(project, file).buildEditorNotificationPanelHandler();
    }

    @Deprecated
    public void doFix(@NotNull Project project, @NotNull VirtualFile file) {
        JavaProjectSdkSetupValidator.preparePopup(project, file).buildPopup().showInFocusCenter();
    }
}

