/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.GutterIconNavigationHandler;
import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.LineMarkerProviderDescriptor;
import com.intellij.java.JavaBundle;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.ProjectIconsAccessor;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UIdentifier;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.evaluation.UEvaluationContextKt;
import org.jetbrains.uast.values.UCallResultValue;
import org.jetbrains.uast.values.UConstant;
import org.jetbrains.uast.values.UStringConstant;
import org.jetbrains.uast.values.UValue;
import org.jetbrains.uast.values.UValueKt;

public class IconLineMarkerProvider
extends LineMarkerProviderDescriptor {
    public LineMarkerInfo<?> getLineMarkerInfo(@NotNull PsiElement element) {
        UIdentifier identifier;
        Collection constants;
        List arguments;
        UCallExpression expression2 = (UCallExpression)UastContextKt.toUElement((PsiElement)element, UCallExpression.class);
        if (expression2 == null) {
            return null;
        }
        if (!ProjectIconsAccessor.isIconClassType(expression2.getExpressionType())) {
            return null;
        }
        UValue uValue = UEvaluationContextKt.uValueOf((UExpression)expression2);
        if (uValue instanceof UCallResultValue && !(arguments = ((UCallResultValue)uValue).getArguments()).isEmpty() && !(constants = (Collection)UValueKt.toPossibleConstants((UValue)((UValue)arguments.get(0))).stream().filter(constant -> constant instanceof UStringConstant).map(UConstant::getSource).collect(Collectors.toList())).isEmpty() && (identifier = expression2.getMethodIdentifier()) != null) {
            return IconLineMarkerProvider.createIconLineMarker((UExpression)ContainerUtil.getFirstItem((Collection)constants), identifier.getPsi());
        }
        return null;
    }

    @Nullable
    private static LineMarkerInfo<PsiElement> createIconLineMarker(@Nullable UExpression initializer, PsiElement bindingElement) {
        if (initializer == null) {
            return null;
        }
        Project project = bindingElement.getProject();
        ProjectIconsAccessor iconsAccessor = ProjectIconsAccessor.getInstance(project);
        VirtualFile file = iconsAccessor.resolveIconFile((UElement)initializer);
        if (file == null) {
            return null;
        }
        Icon icon = iconsAccessor.getIcon(file);
        if (icon == null) {
            return null;
        }
        GutterIconNavigationHandler navHandler = (e, elt) -> FileEditorManager.getInstance((Project)project).openFile(file, true);
        return new LineMarkerInfo(bindingElement, bindingElement.getTextRange(), icon, null, navHandler, GutterIconRenderer.Alignment.LEFT);
    }

    @NotNull
    public String getName() {
        return JavaBundle.message((String)"icon.preview", (Object[])new Object[0]);
    }

    public boolean isEnabledByDefault() {
        return true;
    }
}

