/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.JavaClassNameCompletionContributor;
import com.intellij.codeInsight.completion.JavaClassReferenceCompletionContributor;
import com.intellij.codeInsight.completion.JavaCompletionContributor;
import com.intellij.codeInsight.completion.JavaPsiClassReferenceElement;
import com.intellij.codeInsight.completion.XmlCompletionContributor;
import com.intellij.codeInsight.lookup.AutoCompletionPolicy;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.Consumer;
import org.jetbrains.annotations.NotNull;

public class XmlBasicToClassNameDelegator
extends CompletionContributor {
    public void fillCompletionVariants(@NotNull CompletionParameters parameters2, @NotNull CompletionResultSet result) {
        PsiElement position = parameters2.getPosition();
        PsiFile file = position.getContainingFile();
        if (parameters2.getCompletionType() != CompletionType.BASIC || !JavaCompletionContributor.mayStartClassName(result)) {
            return;
        }
        boolean empty = result.runRemainingContributors(parameters2, true).isEmpty();
        if (!empty && parameters2.getInvocationCount() == 0) {
            result.restartCompletionWhenNothingMatches();
        }
        if (empty && JavaClassReferenceCompletionContributor.findJavaClassReference(file, parameters2.getOffset()) != null || parameters2.isExtendedCompletion()) {
            JavaClassNameCompletionContributor.addAllClasses(parameters2, true, result.getPrefixMatcher(), (Consumer<? super LookupElement>)((Consumer)lookupElement -> {
                JavaPsiClassReferenceElement classElement = (JavaPsiClassReferenceElement)lookupElement.as(JavaPsiClassReferenceElement.CLASS_CONDITION_KEY);
                if (classElement != null) {
                    classElement.setAutoCompletionPolicy(AutoCompletionPolicy.NEVER_AUTOCOMPLETE);
                }
                lookupElement.putUserData(XmlCompletionContributor.WORD_COMPLETION_COMPATIBLE, (Object)Boolean.TRUE);
                result.addElement(lookupElement);
            }));
        }
    }
}

