/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.CompletionConfidence;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiJavaElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.psi.JavaDocTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.javadoc.PsiDocParamRef;
import com.intellij.psi.impl.source.resolve.reference.impl.PsiMultiReference;
import com.intellij.psi.javadoc.PsiDocTag;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavadocCompletionConfidence
extends CompletionConfidence {
    @NotNull
    public ThreeState shouldSkipAutopopup(@NotNull PsiElement contextElement, @NotNull PsiFile psiFile, int offset) {
        if (((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().inside(PsiDocTag.class)).accepts((Object)contextElement)) {
            if (JavadocCompletionConfidence.hasKnownReference(psiFile, offset - 1)) {
                return ThreeState.NO;
            }
            if (PlatformPatterns.psiElement((IElementType)JavaDocTokenType.DOC_TAG_NAME).accepts((Object)contextElement)) {
                return ThreeState.NO;
            }
            if (contextElement.textMatches((CharSequence)"#")) {
                return ThreeState.NO;
            }
        }
        return super.shouldSkipAutopopup(contextElement, psiFile, offset);
    }

    private static boolean hasKnownReference(PsiFile file, int offset) {
        PsiReference reference = file.findReferenceAt(offset);
        return reference instanceof PsiMultiReference ? ContainerUtil.exists((Object[])((PsiMultiReference)reference).getReferences(), JavadocCompletionConfidence::isKnownReference) : JavadocCompletionConfidence.isKnownReference(reference);
    }

    private static boolean isKnownReference(@Nullable PsiReference reference) {
        return reference instanceof PsiJavaReference || reference != null && reference.getElement() instanceof PsiDocParamRef;
    }
}

