/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.codeInsight.ExpectedTypeInfo;
import com.intellij.codeInsight.JavaProjectCodeInsightSettings;
import com.intellij.codeInsight.TailType;
import com.intellij.codeInsight.completion.CompletionLocation;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.JavaClassNameCompletionContributor;
import com.intellij.codeInsight.completion.JavaClassNameInsertHandler;
import com.intellij.codeInsight.completion.JavaConstructorCallElement;
import com.intellij.codeInsight.completion.JavaLookupElementBuilder;
import com.intellij.codeInsight.completion.JavaMemberNameCompletionContributor;
import com.intellij.codeInsight.completion.JavaMethodCallElement;
import com.intellij.codeInsight.completion.JavaMethodReferenceElement;
import com.intellij.codeInsight.completion.JavaPsiClassReferenceElement;
import com.intellij.codeInsight.completion.JavaSmartCompletionContributor;
import com.intellij.codeInsight.completion.JavaStaticMemberProcessor;
import com.intellij.codeInsight.completion.OffsetKey;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.completion.ReferenceExpressionCompletionContributor;
import com.intellij.codeInsight.completion.StaticMemberProcessor;
import com.intellij.codeInsight.completion.SuperCalls;
import com.intellij.codeInsight.completion.impl.CamelHumpMatcher;
import com.intellij.codeInsight.completion.scope.CompletionElement;
import com.intellij.codeInsight.completion.scope.JavaCompletionProcessor;
import com.intellij.codeInsight.completion.util.CompletionStyleUtil;
import com.intellij.codeInsight.completion.util.ParenthesesInsertHandler;
import com.intellij.codeInsight.daemon.impl.analysis.LambdaHighlightingUtil;
import com.intellij.codeInsight.editorActions.TabOutScopesTracker;
import com.intellij.codeInsight.guess.GuessManager;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementDecorator;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.lookup.LookupElementRenderer;
import com.intellij.codeInsight.lookup.LookupItem;
import com.intellij.codeInsight.lookup.LookupItemUtil;
import com.intellij.codeInsight.lookup.PackageLookupItem;
import com.intellij.codeInsight.lookup.PsiTypeLookupItem;
import com.intellij.codeInsight.lookup.TypedLookupItem;
import com.intellij.codeInsight.lookup.VariableLookupItem;
import com.intellij.codeInspection.java15api.Java15APIUsageInspection;
import com.intellij.lang.Language;
import com.intellij.lang.StdLanguages;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NullableLazyKey;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.patterns.PsiJavaElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.psi.HierarchicalMethodSignature;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDocCommentOwner;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiImportStaticReferenceElement;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaReference;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLambdaParameterType;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiPackageStatement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeMapper;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.impl.FakePsiElement;
import com.intellij.psi.impl.light.LightVariableBuilder;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.psi.impl.source.PsiImmediateClassType;
import com.intellij.psi.scope.ElementClassHint;
import com.intellij.psi.scope.NameHint;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.scope.util.PsiScopesUtil;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.psi.util.proximity.ReferenceListWeigher;
import com.intellij.ui.JBColor;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairConsumer;
import com.intellij.util.PairFunction;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.siyeh.ig.psiutils.SideEffectChecker;
import gnu.trove.THashSet;
import java.awt.Color;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaCompletionUtil {
    public static final Key<Boolean> FORCE_SHOW_SIGNATURE_ATTR = Key.create((String)"forceShowSignature");
    private static final Logger LOG = Logger.getInstance(JavaCompletionUtil.class);
    public static final Key<PairFunction<PsiExpression, CompletionParameters, PsiType>> DYNAMIC_TYPE_EVALUATOR = Key.create((String)"DYNAMIC_TYPE_EVALUATOR");
    private static final Key<PsiType> QUALIFIER_TYPE_ATTR = Key.create((String)"qualifierType");
    static final NullableLazyKey<ExpectedTypeInfo[], CompletionLocation> EXPECTED_TYPES = NullableLazyKey.create((String)"expectedTypes", location -> {
        if (((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().beforeLeaf((ElementPattern)PsiJavaPatterns.psiElement().withText("."))).accepts((Object)location.getCompletionParameters().getPosition())) {
            return ExpectedTypeInfo.EMPTY_ARRAY;
        }
        return JavaSmartCompletionContributor.getExpectedTypes(location.getCompletionParameters());
    });
    public static final Key<Boolean> SUPER_METHOD_PARAMETERS = Key.create((String)"SUPER_METHOD_PARAMETERS");
    private static final Key<List<SmartPsiElementPointer<PsiMethod>>> ALL_METHODS_ATTRIBUTE = Key.create((String)"allMethods");

    @Nullable
    public static Set<PsiType> getExpectedTypes(CompletionParameters parameters2) {
        PsiExpression expr2 = (PsiExpression)PsiTreeUtil.getContextOfType((PsiElement)parameters2.getPosition(), PsiExpression.class, (boolean)true);
        if (expr2 != null) {
            THashSet set = new THashSet();
            for (ExpectedTypeInfo expectedInfo : JavaSmartCompletionContributor.getExpectedTypes(parameters2)) {
                set.add(expectedInfo.getType());
            }
            return set;
        }
        return null;
    }

    public static PsiType getQualifierType(LookupElement item) {
        return (PsiType)item.getUserData(QUALIFIER_TYPE_ATTR);
    }

    public static void completeVariableNameForRefactoring(Project project, Set<LookupElement> set, String prefix, PsiType varType, VariableKind varKind) {
        CamelHumpMatcher camelHumpMatcher = new CamelHumpMatcher(prefix);
        JavaMemberNameCompletionContributor.completeVariableNameForRefactoring(project, set, (PrefixMatcher)camelHumpMatcher, varType, varKind, true, false);
    }

    public static void putAllMethods(LookupElement item, List<? extends PsiMethod> methods) {
        item.putUserData(ALL_METHODS_ATTRIBUTE, (Object)ContainerUtil.map(methods, method -> SmartPointerManager.getInstance((Project)method.getProject()).createSmartPsiElementPointer((PsiElement)method)));
    }

    public static List<PsiMethod> getAllMethods(LookupElement item) {
        List pointers = (List)item.getUserData(ALL_METHODS_ATTRIBUTE);
        if (pointers == null) {
            return null;
        }
        return ContainerUtil.mapNotNull((Collection)pointers, pointer -> (PsiMethod)pointer.getElement());
    }

    public static String[] completeVariableNameForRefactoring(JavaCodeStyleManager codeStyleManager, @Nullable PsiType varType, VariableKind varKind, SuggestedNameInfo suggestedNameInfo) {
        return JavaMemberNameCompletionContributor.completeVariableNameForRefactoring(codeStyleManager, (PrefixMatcher)new CamelHumpMatcher(""), varType, varKind, suggestedNameInfo, true, false);
    }

    public static boolean isInExcludedPackage(@NotNull PsiMember member, boolean allowInstanceInnerClasses) {
        String name2 = PsiUtil.getMemberQualifiedName((PsiMember)member);
        if (name2 == null) {
            return false;
        }
        if (!member.hasModifierProperty("static")) {
            if (member instanceof PsiMethod || member instanceof PsiField) {
                return false;
            }
            if (allowInstanceInnerClasses && member instanceof PsiClass && member.getContainingClass() != null) {
                return false;
            }
        }
        return JavaProjectCodeInsightSettings.getSettings(member.getProject()).isExcluded(name2);
    }

    @NotNull
    public static <T extends PsiType> T originalize(@NotNull T type2) {
        if (!type2.isValid()) {
            return type2;
        }
        T result = new PsiTypeMapper(){
            private final Set<PsiClassType> myVisited = ContainerUtil.newIdentityTroveSet();

            @Override
            public PsiType visitClassType(@NotNull PsiClassType classType) {
                if (!this.myVisited.add(classType)) {
                    return classType;
                }
                PsiClassType.ClassResolveResult classResolveResult = classType.resolveGenerics();
                PsiClass psiClass = classResolveResult.getElement();
                PsiSubstitutor substitutor = classResolveResult.getSubstitutor();
                if (psiClass == null) {
                    return classType;
                }
                return new PsiImmediateClassType((PsiClass)CompletionUtil.getOriginalOrSelf((PsiElement)psiClass), this.originalizeSubstitutor(substitutor));
            }

            private PsiSubstitutor originalizeSubstitutor(PsiSubstitutor substitutor) {
                PsiSubstitutor originalSubstitutor = PsiSubstitutor.EMPTY;
                for (Map.Entry entry : substitutor.getSubstitutionMap().entrySet()) {
                    PsiType value2 = (PsiType)entry.getValue();
                    originalSubstitutor = originalSubstitutor.put((PsiTypeParameter)CompletionUtil.getOriginalOrSelf((PsiElement)((PsiElement)entry.getKey())), value2 == null ? null : this.mapType(value2));
                }
                return originalSubstitutor;
            }

            @Override
            public PsiType visitType(@NotNull PsiType type2) {
                return type2;
            }
        }.mapType(type2);
        if (result == null) {
            throw new AssertionError((Object)("Null result for type " + type2 + " of class " + type2.getClass()));
        }
        return result;
    }

    @Nullable
    public static List<? extends PsiElement> getAllPsiElements(LookupElement item) {
        List<PsiMethod> allMethods = JavaCompletionUtil.getAllMethods(item);
        if (allMethods != null) {
            return allMethods;
        }
        if (item.getObject() instanceof PsiElement) {
            return Collections.singletonList((PsiElement)item.getObject());
        }
        return null;
    }

    @Nullable
    public static PsiType getLookupElementType(LookupElement element) {
        TypedLookupItem typed = (TypedLookupItem)element.as(TypedLookupItem.CLASS_CONDITION_KEY);
        return typed != null ? typed.getType() : null;
    }

    @Nullable
    public static PsiType getQualifiedMemberReferenceType(@Nullable PsiType qualifierType, final @NotNull PsiMember member) {
        final Ref subst = Ref.create((Object)PsiSubstitutor.EMPTY);
        class MyProcessor
        implements PsiScopeProcessor,
        NameHint,
        ElementClassHint {
            MyProcessor() {
            }

            public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
                if (element == member) {
                    subst.set(state.get(PsiSubstitutor.KEY));
                }
                return true;
            }

            @Override
            public String getName(@NotNull ResolveState state) {
                return member.getName();
            }

            @Override
            public boolean shouldProcess(@NotNull ElementClassHint.DeclarationKind kind2) {
                return member instanceof PsiEnumConstant ? kind2 == ElementClassHint.DeclarationKind.ENUM_CONST : (member instanceof PsiField ? kind2 == ElementClassHint.DeclarationKind.FIELD : kind2 == ElementClassHint.DeclarationKind.METHOD);
            }

            public <T> T getHint(@NotNull Key<T> hintKey) {
                return (T)(hintKey == NameHint.KEY || hintKey == ElementClassHint.KEY ? this : null);
            }
        }
        PsiScopesUtil.processTypeDeclarations(qualifierType, (PsiElement)member, new MyProcessor());
        PsiType rawType = member instanceof PsiField ? ((PsiField)member).getType() : (member instanceof PsiMethod ? ((PsiMethod)member).getReturnType() : JavaPsiFacade.getElementFactory((Project)member.getProject()).createType((PsiClass)member));
        return ((PsiSubstitutor)subst.get()).substitute(rawType);
    }

    static Set<LookupElement> processJavaReference(PsiElement element, PsiJavaCodeReferenceElement javaReference, ElementFilter elementFilter, JavaCompletionProcessor.Options options, Condition<String> nameCondition, CompletionParameters parameters2) {
        PsiElement resolve2;
        PsiExpression qualifierExpression2;
        PsiElement elementParent = element.getContext();
        if (elementParent instanceof PsiReferenceExpression && (qualifierExpression2 = ((PsiReferenceExpression)elementParent).getQualifierExpression()) instanceof PsiReferenceExpression && (resolve2 = ((PsiReferenceExpression)qualifierExpression2).resolve()) instanceof PsiParameter) {
            LinkedHashSet<LookupElement> set;
            int parameterIndex;
            boolean overloadsFound;
            PsiLambdaExpression lambdaExpression;
            PsiElement declarationScope = ((PsiParameter)resolve2).getDeclarationScope();
            if (((PsiParameter)resolve2).getType() instanceof PsiLambdaParameterType && PsiTypesUtil.getExpectedTypeByParent((PsiElement)(lambdaExpression = (PsiLambdaExpression)declarationScope)) == null && (overloadsFound = LambdaUtil.processParentOverloads((PsiFunctionalExpression)lambdaExpression, arg_0 -> JavaCompletionUtil.lambda$processJavaReference$3(parameterIndex = lambdaExpression.getParameterList().getParameterIndex((PsiParameter)resolve2), element, set = new LinkedHashSet<LookupElement>(), elementFilter, options, nameCondition, parameters2, arg_0)))) {
                return set;
            }
        }
        return JavaCompletionUtil.processJavaQualifiedReference(element, javaReference, elementFilter, options, nameCondition, parameters2);
    }

    /*
     * WARNING - void declaration
     */
    private static Set<LookupElement> processJavaQualifiedReference(PsiElement element, PsiJavaCodeReferenceElement javaReference, ElementFilter elementFilter, JavaCompletionProcessor.Options options, Condition<String> nameCondition, CompletionParameters parameters2) {
        LinkedHashSet<LookupElement> set = new LinkedHashSet<LookupElement>();
        JavaCompletionProcessor processor2 = new JavaCompletionProcessor(element, elementFilter, options, nameCondition);
        PsiType plainQualifier = processor2.getQualifierType();
        List<PsiType> runtimeQualifiers = JavaCompletionUtil.getQualifierCastTypes((PsiJavaReference)javaReference, parameters2);
        if (!runtimeQualifiers.isEmpty()) {
            PsiType[] conjuncts = (PsiType[])JBIterable.of((Object)plainQualifier).append(runtimeQualifiers).toArray((Object[])PsiType.EMPTY_ARRAY);
            PsiType composite = PsiIntersectionType.createIntersection((boolean)false, (PsiType[])conjuncts);
            FakePsiElement ctx = JavaCompletionUtil.createContextWithXxxVariable(element, composite);
            javaReference = JavaCompletionUtil.createReference("xxx.xxx", (PsiElement)ctx);
            processor2.setQualifierType(composite);
        }
        javaReference.processVariants((PsiScopeProcessor)processor2);
        List castItems = ContainerUtil.map(runtimeQualifiers, q -> PsiTypeLookupItem.createLookupItem(q, element));
        boolean pkgContext = JavaCompletionUtil.inSomePackage(element);
        PsiClass qualifierClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)plainQualifier);
        boolean honorExcludes = qualifierClass == null || !JavaCompletionUtil.isInExcludedPackage((PsiMember)qualifierClass, false);
        Set expectedTypes = (Set)ObjectUtils.coalesce(JavaCompletionUtil.getExpectedTypes(parameters2), Collections.emptySet());
        THashSet mentioned = new THashSet();
        for (CompletionElement completionElement : processor2.getResults()) {
            for (LookupElement lookupElement : JavaCompletionUtil.createLookupElements(completionElement, (PsiJavaReference)javaReference)) {
                void var19_20;
                PsiTypeLookupItem qualifierCast;
                lookupElement.putUserData(QUALIFIER_TYPE_ATTR, (Object)plainQualifier);
                Object o = lookupElement.getObject();
                if (o instanceof PsiClass && !JavaCompletionUtil.isSourceLevelAccessible(element, (PsiClass)o, pkgContext)) continue;
                if (o instanceof PsiMember) {
                    if (honorExcludes && JavaCompletionUtil.isInExcludedPackage((PsiMember)o, true)) continue;
                    mentioned.add(CompletionUtil.getOriginalOrSelf((PsiElement)((PsiMember)o)));
                }
                if ((qualifierCast = JavaCompletionUtil.findQualifierCast(lookupElement, castItems, plainQualifier, processor2, expectedTypes)) != null) {
                    LookupElement lookupElement2 = JavaCompletionUtil.castQualifier(lookupElement, qualifierCast);
                }
                set.add(JavaCompletionUtil.highlightIfNeeded(qualifierCast != null ? qualifierCast.getType() : plainQualifier, (LookupElement)var19_20, o, element));
            }
        }
        PsiElement refQualifier = javaReference.getQualifier();
        if (refQualifier == null && PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{PsiPackageStatement.class, PsiImportStatementBase.class}) == null) {
            JavaStaticMemberProcessor memberProcessor = new JavaStaticMemberProcessor(parameters2);
            memberProcessor.processMembersOfRegisteredClasses(nameCondition, (PairConsumer<? super PsiMember, ? super PsiClass>)((PairConsumer)(arg_0, arg_1) -> JavaCompletionUtil.lambda$processJavaQualifiedReference$5((Set)mentioned, processor2, set, memberProcessor, arg_0, arg_1)));
        } else if (refQualifier instanceof PsiSuperExpression && ((PsiSuperExpression)refQualifier).getQualifier() == null) {
            set.addAll(SuperCalls.suggestQualifyingSuperCalls(element, (PsiJavaReference)javaReference, elementFilter, options, nameCondition));
        }
        return set;
    }

    @NotNull
    static PsiReferenceExpression createReference(@NotNull String text2, @NotNull PsiElement context) {
        return (PsiReferenceExpression)JavaPsiFacade.getElementFactory((Project)context.getProject()).createExpressionFromText(text2, context);
    }

    @NotNull
    private static List<PsiType> getQualifierCastTypes(PsiJavaReference javaReference, CompletionParameters parameters2) {
        PsiReferenceExpression refExpr;
        PsiExpression qualifier;
        if (javaReference instanceof PsiReferenceExpression && (qualifier = (refExpr = (PsiReferenceExpression)javaReference).getQualifierExpression()) != null) {
            PsiType type2;
            Project project = qualifier.getProject();
            PairFunction evaluator = (PairFunction)refExpr.getContainingFile().getCopyableUserData(DYNAMIC_TYPE_EVALUATOR);
            if (evaluator != null && (type2 = (PsiType)evaluator.fun((Object)qualifier, (Object)parameters2)) != null) {
                return Collections.singletonList(type2);
            }
            return GuessManager.getInstance(project).getControlFlowExpressionTypeConjuncts(qualifier, parameters2.getInvocationCount() > 1);
        }
        return Collections.emptyList();
    }

    private static boolean shouldCast(@NotNull LookupElement item, @NotNull PsiTypeLookupItem castTypeItem, @Nullable PsiType plainQualifier, @NotNull JavaCompletionProcessor processor2, @NotNull Set<? extends PsiType> expectedTypes) {
        PsiType castType = castTypeItem.getType();
        if (plainQualifier != null) {
            Object o = item.getObject();
            if (o instanceof PsiMethod && plainQualifier instanceof PsiClassType && castType instanceof PsiClassType) {
                PsiMethod plainMethod;
                PsiMethod method = (PsiMethod)o;
                PsiClassType.ClassResolveResult plainResult = ((PsiClassType)plainQualifier).resolveGenerics();
                PsiClass plainClass = plainResult.getElement();
                HierarchicalMethodSignature signature = method.getHierarchicalMethodSignature();
                PsiMethod psiMethod = plainMethod = plainClass == null ? null : (PsiMethod)((StreamEx)StreamEx.ofTree((Object)signature, s -> StreamEx.of((Collection)s.getSuperSignatures())).map(sig -> MethodSignatureUtil.findMethodBySignature((PsiClass)plainClass, (MethodSignature)sig, (boolean)true)).filter(Objects::nonNull)).findFirst().orElse(null);
                if (plainMethod != null) {
                    PsiClassType.ClassResolveResult castResult = ((PsiClassType)castType).resolveGenerics();
                    PsiClass castClass = castResult.getElement();
                    if (castClass == null || !castClass.isInheritor(plainClass, true)) {
                        return false;
                    }
                    if (!processor2.isAccessible((PsiElement)plainMethod)) {
                        return true;
                    }
                    PsiSubstitutor castSub = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)plainClass, (PsiClassType)((PsiClassType)castType));
                    PsiType typeAfterCast = JavaCompletionUtil.toRaw(castSub.substitute(method.getReturnType()));
                    PsiType typeDeclared = JavaCompletionUtil.toRaw(plainResult.getSubstitutor().substitute(plainMethod.getReturnType()));
                    return typeAfterCast != null && typeDeclared != null && !typeAfterCast.equals(typeDeclared) && expectedTypes.stream().anyMatch(et -> et.isAssignableFrom(typeAfterCast) && !et.isAssignableFrom(typeDeclared));
                }
            }
            return JavaCompletionUtil.containsMember(castType, o, true) && !JavaCompletionUtil.containsMember(plainQualifier, o, true);
        }
        return false;
    }

    @NotNull
    private static LookupElement castQualifier(@NotNull LookupElement item, final @NotNull PsiTypeLookupItem castTypeItem) {
        return new LookupElementDecorator<LookupElement>(item){

            public void handleInsert(@NotNull InsertionContext context) {
                PsiElement qualifier;
                Document document = context.getEditor().getDocument();
                context.commitDocument();
                PsiFile file = context.getFile();
                PsiJavaCodeReferenceElement ref = (PsiJavaCodeReferenceElement)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)file, (int)context.getStartOffset(), PsiJavaCodeReferenceElement.class, (boolean)false);
                if (ref != null && (qualifier = ref.getQualifier()) != null) {
                    CommonCodeStyleSettings settings = CompletionStyleUtil.getCodeStyleSettings((InsertionContext)context);
                    String parenSpace = settings.SPACE_WITHIN_PARENTHESES ? " " : "";
                    document.insertString(qualifier.getTextRange().getEndOffset(), (CharSequence)(parenSpace + ")"));
                    String spaceWithin = settings.SPACE_WITHIN_CAST_PARENTHESES ? " " : "";
                    String prefix = "(" + parenSpace + "(" + spaceWithin;
                    String spaceAfter = settings.SPACE_AFTER_TYPE_CAST ? " " : "";
                    int exprStart = qualifier.getTextRange().getStartOffset();
                    document.insertString(exprStart, (CharSequence)(prefix + spaceWithin + ")" + spaceAfter));
                    CompletionUtil.emulateInsertion((InsertionContext)context, (int)(exprStart + prefix.length()), (LookupElement)castTypeItem);
                    PsiDocumentManager.getInstance((Project)file.getProject()).doPostponedOperationsAndUnblockDocument(document);
                    context.getEditor().getCaretModel().moveToOffset(context.getTailOffset());
                }
                super.handleInsert(context);
            }

            public void renderElement(LookupElementPresentation presentation) {
                super.renderElement(presentation);
                presentation.appendTailText(" on " + castTypeItem.getType().getPresentableText(), true);
            }
        };
    }

    private static PsiTypeLookupItem findQualifierCast(@NotNull LookupElement item, @NotNull List<? extends PsiTypeLookupItem> castTypeItems, @Nullable PsiType plainQualifier, JavaCompletionProcessor processor2, Set<? extends PsiType> expectedTypes) {
        return (PsiTypeLookupItem)ContainerUtil.find(castTypeItems, c -> JavaCompletionUtil.shouldCast(item, c, plainQualifier, processor2, expectedTypes));
    }

    @Nullable
    private static PsiType toRaw(@Nullable PsiType type2) {
        return type2 instanceof PsiClassType ? ((PsiClassType)type2).rawType() : type2;
    }

    @NotNull
    public static LookupElement highlightIfNeeded(@Nullable PsiType qualifierType, @NotNull LookupElement item, @NotNull Object object, @NotNull PsiElement place) {
        if (JavaCompletionUtil.shouldMarkRed(object, place)) {
            return PrioritizedLookupElement.withExplicitProximity((LookupElement)LookupElementDecorator.withRenderer((LookupElement)item, (LookupElementRenderer)new LookupElementRenderer<LookupElementDecorator<LookupElement>>(){

                public void renderElement(LookupElementDecorator<LookupElement> element, LookupElementPresentation presentation) {
                    element.getDelegate().renderElement(presentation);
                    presentation.setItemTextForeground((Color)JBColor.RED);
                }
            }), (int)-1);
        }
        if (JavaCompletionUtil.containsMember(qualifierType, object, false) && !qualifierType.equalsToText("java.lang.Object")) {
            LookupElementDecorator bold = LookupElementDecorator.withRenderer((LookupElement)item, (LookupElementRenderer)new LookupElementRenderer<LookupElementDecorator<LookupElement>>(){

                public void renderElement(LookupElementDecorator<LookupElement> element, LookupElementPresentation presentation) {
                    element.getDelegate().renderElement(presentation);
                    presentation.setItemTextBold(true);
                }
            });
            return object instanceof PsiField ? bold : PrioritizedLookupElement.withExplicitProximity((LookupElement)bold, (int)1);
        }
        return item;
    }

    private static boolean shouldMarkRed(@NotNull Object object, @NotNull PsiElement place) {
        if (!(object instanceof PsiMember)) {
            return false;
        }
        if (Java15APIUsageInspection.getLastIncompatibleLanguageLevel((PsiMember)object, PsiUtil.getLanguageLevel((PsiElement)place)) != null) {
            return true;
        }
        if (object instanceof PsiEnumConstant) {
            return ReferenceExpressionCompletionContributor.findConstantsUsedInSwitch(place).contains(CompletionUtil.getOriginalOrSelf((PsiElement)((PsiEnumConstant)object)));
        }
        return object instanceof PsiClass && ReferenceListWeigher.INSTANCE.getApplicability((PsiClass)object, place) == ReferenceListWeigher.ReferenceListApplicability.inapplicable;
    }

    @Contract(value="null, _, _ -> false")
    private static boolean containsMember(@Nullable PsiType qualifierType, @NotNull Object object, boolean checkBases) {
        if (!(object instanceof PsiMember)) {
            return false;
        }
        if (qualifierType instanceof PsiArrayType) {
            PsiFile file = ((PsiMember)object).getContainingFile();
            if (file == null || file.getVirtualFile() == null) {
                return true;
            }
        } else if (qualifierType instanceof PsiClassType) {
            PsiClass qualifierClass = ((PsiClassType)qualifierType).resolve();
            if (qualifierClass == null) {
                return false;
            }
            if (object instanceof PsiMethod && qualifierClass.findMethodBySignature((PsiMethod)object, checkBases) != null) {
                return true;
            }
            PsiClass memberClass = ((PsiMember)object).getContainingClass();
            return checkBases ? InheritanceUtil.isInheritorOrSelf((PsiClass)qualifierClass, (PsiClass)memberClass, (boolean)true) : qualifierClass.equals(memberClass);
        }
        return false;
    }

    static Iterable<? extends LookupElement> createLookupElements(CompletionElement completionElement, PsiJavaReference reference) {
        PsiSubstitutor substitutor;
        Object completion = completionElement.getElement();
        assert (!(completion instanceof LookupElement));
        if (reference instanceof PsiJavaCodeReferenceElement) {
            if (completion instanceof PsiMethod && ((PsiJavaCodeReferenceElement)reference).getParent() instanceof PsiImportStaticStatement) {
                return Collections.singletonList(JavaLookupElementBuilder.forMethod((PsiMethod)completion, PsiSubstitutor.EMPTY));
            }
            if (completion instanceof PsiClass) {
                List<JavaPsiClassReferenceElement> classItems = JavaClassNameCompletionContributor.createClassLookupItems((PsiClass)CompletionUtil.getOriginalOrSelf((PsiElement)((PsiClass)completion)), JavaClassNameCompletionContributor.AFTER_NEW.accepts((Object)reference), JavaClassNameInsertHandler.JAVA_CLASS_INSERT_HANDLER, (Condition<? super PsiClass>)Conditions.alwaysTrue());
                return JBIterable.from(classItems).flatMap(i -> JavaConstructorCallElement.wrap(i, reference.getElement()));
            }
        }
        if ((substitutor = completionElement.getSubstitutor()) == null) {
            substitutor = PsiSubstitutor.EMPTY;
        }
        if (completion instanceof PsiClass) {
            JavaPsiClassReferenceElement classItem = JavaClassNameCompletionContributor.createClassLookupItem((PsiClass)completion, true).setSubstitutor(substitutor);
            return JavaConstructorCallElement.wrap(classItem, reference.getElement());
        }
        if (completion instanceof PsiMethod) {
            if (reference instanceof PsiMethodReferenceExpression) {
                return Collections.singleton(new JavaMethodReferenceElement((PsiMethod)completion, (PsiElement)((PsiMethodReferenceExpression)reference), completionElement.getMethodRefType()));
            }
            JavaMethodCallElement item = new JavaMethodCallElement((PsiMethod)completion).setQualifierSubstitutor(substitutor);
            item.setForcedQualifier(completionElement.getQualifierText());
            return Collections.singletonList(item);
        }
        if (completion instanceof PsiVariable) {
            return Collections.singletonList(new VariableLookupItem((PsiVariable)completion).setSubstitutor(substitutor).qualifyIfNeeded((PsiReference)reference));
        }
        if (completion instanceof PsiPackage) {
            return Collections.singletonList(new PackageLookupItem((PsiPackage)completion, reference.getElement()));
        }
        return Collections.singletonList(LookupItemUtil.objectToLookupItem(completion));
    }

    public static boolean hasAccessibleConstructor(@NotNull PsiType type2, @NotNull PsiElement place) {
        if (type2 instanceof PsiArrayType) {
            return true;
        }
        PsiClass psiClass = PsiUtil.resolveClassInType((PsiType)type2);
        if (psiClass == null || psiClass.isEnum() || psiClass.isAnnotationType()) {
            return false;
        }
        PsiMethod[] methods = psiClass.getConstructors();
        return methods.length == 0 || Arrays.stream(methods).anyMatch(constructor -> JavaCompletionUtil.isConstructorCompletable(constructor, place));
    }

    private static boolean isConstructorCompletable(@NotNull PsiMethod constructor, @NotNull PsiElement place) {
        if (!(constructor instanceof PsiCompiledElement)) {
            return true;
        }
        if (constructor.hasModifierProperty("private")) {
            return false;
        }
        if (constructor.hasModifierProperty("packageLocal")) {
            return PsiUtil.isAccessible((PsiMember)constructor, (PsiElement)place, null);
        }
        return true;
    }

    public static LinkedHashSet<String> getAllLookupStrings(@NotNull PsiMember member) {
        String className2;
        LinkedHashSet<String> allLookupStrings = new LinkedHashSet<String>();
        String name2 = member.getName();
        allLookupStrings.add(name2);
        PsiClass containingClass = member.getContainingClass();
        while (containingClass != null && (className2 = containingClass.getName()) != null) {
            name2 = className2 + "." + name2;
            allLookupStrings.add(name2);
            PsiElement parent = containingClass.getParent();
            if (!(parent instanceof PsiClass)) break;
            containingClass = (PsiClass)parent;
        }
        return allLookupStrings;
    }

    public static boolean mayHaveSideEffects(@Nullable PsiElement element) {
        return element instanceof PsiExpression && SideEffectChecker.mayHaveSideEffects((PsiExpression)element);
    }

    public static void insertClassReference(@NotNull PsiClass psiClass, @NotNull PsiFile file, int offset) {
        JavaCompletionUtil.insertClassReference(psiClass, file, offset, offset);
    }

    public static int insertClassReference(PsiClass psiClass, PsiFile file, int startOffset, int endOffset) {
        PsiElement parent;
        PsiModifierListOwner enclosingStaticElement;
        PsiClass containingClass;
        Project project = file.getProject();
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
        documentManager.commitAllDocuments();
        PsiManager manager = file.getManager();
        Document document = FileDocumentManager.getInstance().getDocument(file.getViewProvider().getVirtualFile());
        PsiReference reference = file.findReferenceAt(startOffset);
        if (reference != null && manager.areElementsEquivalent((PsiElement)psiClass, reference.resolve())) {
            return endOffset;
        }
        String name2 = psiClass.getName();
        if (name2 == null) {
            return endOffset;
        }
        if (reference != null && !psiClass.hasModifierProperty("static") && (containingClass = psiClass.getContainingClass()) != null && containingClass.hasTypeParameters() && (enclosingStaticElement = PsiUtil.getEnclosingStaticElement((PsiElement)reference.getElement(), null)) != null && !PsiTreeUtil.isAncestor((PsiElement)enclosingStaticElement, (PsiElement)psiClass, (boolean)false)) {
            return endOffset;
        }
        assert (document != null);
        document.replaceString(startOffset, endOffset, (CharSequence)name2);
        int newEndOffset = startOffset + name2.length();
        RangeMarker toDelete = JavaCompletionUtil.insertTemporary(newEndOffset, document, " ");
        documentManager.commitAllDocuments();
        PsiElement element = file.findElementAt(startOffset);
        if (element instanceof PsiIdentifier && (parent = element.getParent()) instanceof PsiJavaCodeReferenceElement && !((PsiJavaCodeReferenceElement)parent).isQualified() && !(parent.getParent() instanceof PsiPackageStatement)) {
            PsiJavaCodeReferenceElement ref = (PsiJavaCodeReferenceElement)parent;
            if (psiClass.isValid() && !psiClass.getManager().areElementsEquivalent((PsiElement)psiClass, JavaCompletionUtil.resolveReference((PsiReference)ref))) {
                PsiElement newElement;
                boolean staticImport = ref instanceof PsiImportStaticReferenceElement;
                try {
                    newElement = staticImport ? ((PsiImportStaticReferenceElement)ref).bindToTargetClass(psiClass) : ref.bindToElement((PsiElement)psiClass);
                }
                catch (IncorrectOperationException e) {
                    return endOffset;
                }
                RangeMarker rangeMarker = document.createRangeMarker(newElement.getTextRange());
                documentManager.doPostponedOperationsAndUnblockDocument(document);
                documentManager.commitDocument(document);
                newElement = CodeInsightUtilCore.findElementInRange((PsiFile)file, (int)rangeMarker.getStartOffset(), (int)rangeMarker.getEndOffset(), PsiJavaCodeReferenceElement.class, (Language)JavaLanguage.INSTANCE);
                rangeMarker.dispose();
                if (newElement != null) {
                    String qName;
                    PsiReferenceParameterList parameterList;
                    newEndOffset = newElement.getTextRange().getEndOffset();
                    if (!(newElement instanceof PsiReferenceExpression) && (parameterList = ((PsiJavaCodeReferenceElement)newElement).getParameterList()) != null) {
                        newEndOffset = parameterList.getTextRange().getStartOffset();
                    }
                    if (!(staticImport || psiClass.getManager().areElementsEquivalent((PsiElement)psiClass, JavaCompletionUtil.resolveReference((PsiReference)newElement)) || PsiUtil.isInnerClass((PsiClass)psiClass) || (qName = psiClass.getQualifiedName()) == null)) {
                        document.replaceString(newElement.getTextRange().getStartOffset(), newEndOffset, (CharSequence)qName);
                        newEndOffset = newElement.getTextRange().getStartOffset() + qName.length();
                    }
                }
            }
        }
        if (toDelete != null && toDelete.isValid()) {
            document.deleteString(toDelete.getStartOffset(), toDelete.getEndOffset());
        }
        return newEndOffset;
    }

    @Nullable
    static PsiElement resolveReference(PsiReference psiReference) {
        ResolveResult[] results;
        if (psiReference instanceof PsiPolyVariantReference && (results = ((PsiPolyVariantReference)psiReference).multiResolve(true)).length == 1) {
            return results[0].getElement();
        }
        return psiReference.resolve();
    }

    @Nullable
    public static RangeMarker insertTemporary(int endOffset, Document document, String temporary) {
        CharSequence chars = document.getCharsSequence();
        if (endOffset < chars.length() && Character.isJavaIdentifierPart(chars.charAt(endOffset))) {
            document.insertString(endOffset, (CharSequence)temporary);
            RangeMarker toDelete = document.createRangeMarker(endOffset, endOffset + 1);
            toDelete.setGreedyToLeft(true);
            toDelete.setGreedyToRight(true);
            return toDelete;
        }
        return null;
    }

    public static void insertParentheses(@NotNull InsertionContext context, @NotNull LookupElement item, boolean overloadsMatter, boolean hasParams) {
        JavaCompletionUtil.insertParentheses(context, item, overloadsMatter, ThreeState.fromBoolean((boolean)hasParams), false);
    }

    public static void insertParentheses(@NotNull InsertionContext context, @NotNull LookupElement item, boolean overloadsMatter, ThreeState hasParams, boolean forceClosingParenthesis) {
        boolean smart;
        Editor editor = context.getEditor();
        char completionChar = context.getCompletionChar();
        PsiFile file = context.getFile();
        TailType tailType = completionChar == '(' ? TailType.NONE : (completionChar == ':' ? TailType.COND_EXPR_COLON : LookupItem.handleCompletionChar((Editor)context.getEditor(), (LookupElement)item, (char)completionChar));
        boolean hasTail = tailType != TailType.NONE && tailType != TailType.UNKNOWN;
        boolean bl = smart = completionChar == '\r';
        if (completionChar == '(' || completionChar == '.' || completionChar == ',' || completionChar == ';' || completionChar == ':' || completionChar == ' ') {
            context.setAddCompletionChar(false);
        }
        if (hasTail) {
            hasParams = ThreeState.NO;
        }
        boolean needRightParenth = forceClosingParenthesis || !smart && (CodeInsightSettings.getInstance().AUTOINSERT_PAIR_BRACKET || hasParams == ThreeState.NO && completionChar != '(');
        context.commitDocument();
        CommonCodeStyleSettings styleSettings = CompletionStyleUtil.getCodeStyleSettings((InsertionContext)context);
        PsiElement elementAt = file.findElementAt(context.getStartOffset());
        if (elementAt == null || !(elementAt.getParent() instanceof PsiMethodReferenceExpression)) {
            final ThreeState hasParameters = hasParams;
            boolean spaceBetweenParentheses = hasParams == ThreeState.YES && styleSettings.SPACE_WITHIN_METHOD_CALL_PARENTHESES || hasParams == ThreeState.UNSURE && styleSettings.SPACE_WITHIN_EMPTY_METHOD_CALL_PARENTHESES;
            new ParenthesesInsertHandler<LookupElement>(styleSettings.SPACE_BEFORE_METHOD_CALL_PARENTHESES, spaceBetweenParentheses, needRightParenth, styleSettings.METHOD_PARAMETERS_LPAREN_ON_NEXT_LINE){

                protected boolean placeCaretInsideParentheses(InsertionContext context1, LookupElement item1) {
                    return hasParameters != ThreeState.NO;
                }

                protected PsiElement findExistingLeftParenthesis(@NotNull InsertionContext context) {
                    PsiElement token = super.findExistingLeftParenthesis(context);
                    return this.isPartOfLambda(token) ? null : token;
                }

                private boolean isPartOfLambda(PsiElement token) {
                    return token != null && token.getParent() instanceof PsiExpressionList && PsiUtilCore.getElementType((PsiElement)PsiTreeUtil.nextVisibleLeaf((PsiElement)token.getParent())) == JavaTokenType.ARROW;
                }
            }.handleInsert(context, item);
        }
        if (hasParams != ThreeState.NO) {
            AutoPopupController.getInstance((Project)file.getProject()).autoPopupParameterInfo(editor, overloadsMatter ? null : (PsiElement)item.getObject());
        }
        if (smart || !needRightParenth || !JavaCompletionUtil.insertTail(context, item, tailType, hasTail)) {
            return;
        }
        if (completionChar == '.') {
            AutoPopupController.getInstance((Project)file.getProject()).autoPopupMemberLookup(context.getEditor(), null);
        } else if (completionChar == ',') {
            AutoPopupController.getInstance((Project)file.getProject()).autoPopupParameterInfo(context.getEditor(), null);
        }
    }

    private static boolean insertTail(InsertionContext context, LookupElement item, TailType tailType, boolean hasTail) {
        TailType toInsert = tailType;
        LookupItem lookupItem = (LookupItem)item.as(LookupItem.CLASS_CONDITION_KEY);
        if ((lookupItem == null || lookupItem.getAttribute(LookupItem.TAIL_TYPE_ATTR) != TailType.UNKNOWN) && !hasTail && item.getObject() instanceof PsiMethod && PsiType.VOID.equals((Object)((PsiMethod)item.getObject()).getReturnType())) {
            PsiElement composite;
            PsiDocumentManager.getInstance((Project)context.getProject()).commitAllDocuments();
            if (((PsiElementPattern.Capture)PlatformPatterns.psiElement().beforeLeaf((ElementPattern)PlatformPatterns.psiElement().withText("."))).accepts((Object)context.getFile().findElementAt(context.getTailOffset() - 1))) {
                return false;
            }
            boolean insertAdditionalSemicolon = true;
            PsiElement leaf = context.getFile().findElementAt(context.getStartOffset());
            PsiElement psiElement = composite = leaf == null ? null : leaf.getParent();
            if (composite instanceof PsiReferenceExpression) {
                PsiElement parent = composite.getParent();
                if (parent instanceof PsiMethodCallExpression) {
                    parent = parent.getParent();
                }
                if (parent instanceof PsiLambdaExpression && !LambdaHighlightingUtil.insertSemicolonAfter((PsiLambdaExpression)parent)) {
                    insertAdditionalSemicolon = false;
                }
            }
            if (insertAdditionalSemicolon) {
                toInsert = TailType.SEMICOLON;
            }
        }
        Editor editor = context.getEditor();
        int tailOffset = context.getTailOffset();
        int afterTailOffset = toInsert.processTail(editor, tailOffset);
        int caretOffset = editor.getCaretModel().getOffset();
        if (afterTailOffset > tailOffset && tailOffset > caretOffset && TabOutScopesTracker.getInstance().removeScopeEndingAt(editor, caretOffset) > 0) {
            TabOutScopesTracker.getInstance().registerEmptyScope(editor, caretOffset, afterTailOffset);
        }
        return true;
    }

    public static void shortenReference(PsiFile file, int offset) throws IncorrectOperationException {
        Project project = file.getProject();
        PsiDocumentManager manager = PsiDocumentManager.getInstance((Project)project);
        Document document = manager.getDocument(file);
        if (document == null) {
            PsiUtilCore.ensureValid((PsiElement)file);
            LOG.error("No document for " + file);
            return;
        }
        manager.commitDocument(document);
        PsiReference ref = file.findReferenceAt(offset);
        if (ref != null) {
            JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences(ref.getElement());
            PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(document);
        }
    }

    public static boolean inSomePackage(PsiElement context) {
        PsiFile contextFile = context.getContainingFile();
        return contextFile instanceof PsiClassOwner && StringUtil.isNotEmpty((String)((PsiClassOwner)contextFile).getPackageName());
    }

    public static boolean isSourceLevelAccessible(PsiElement context, PsiClass psiClass, boolean pkgContext) {
        String fqName;
        PsiClass topLevel;
        if (!JavaPsiFacade.getInstance((Project)psiClass.getProject()).getResolveHelper().isAccessible((PsiMember)psiClass, context, psiClass.getContainingClass())) {
            return false;
        }
        return !pkgContext || (topLevel = PsiUtil.getTopLevelClass((PsiElement)psiClass)) == null || (fqName = topLevel.getQualifiedName()) == null || !StringUtil.isEmpty((String)StringUtil.getPackageName((String)fqName));
    }

    public static boolean promptTypeArgs(InsertionContext context, int offset) {
        if (offset < 0) {
            return false;
        }
        OffsetKey key2 = context.trackOffset(offset, false);
        PostprocessReformattingAspect.getInstance((Project)context.getProject()).doPostponedFormatting();
        offset = context.getOffset(key2);
        if (offset < 0) {
            return false;
        }
        String open = JavaCompletionUtil.escapeXmlIfNeeded(context, "<");
        context.getDocument().insertString(offset, (CharSequence)open);
        context.getEditor().getCaretModel().moveToOffset(offset += open.length());
        if (CodeInsightSettings.getInstance().AUTOINSERT_PAIR_BRACKET) {
            context.getDocument().insertString(offset, (CharSequence)JavaCompletionUtil.escapeXmlIfNeeded(context, ">"));
            context.commitDocument();
            TabOutScopesTracker.getInstance().registerEmptyScope(context.getEditor(), offset, JavaCompletionUtil.getTabOutOffset(context, offset));
        }
        if (context.getCompletionChar() != '\r') {
            context.setAddCompletionChar(false);
        }
        return true;
    }

    private static int getTabOutOffset(@NotNull InsertionContext context, int offset) {
        PsiCall call = (PsiCall)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)context.getFile(), (int)offset, PsiCall.class, (boolean)false);
        if (call != null && call.getArgumentList() != null) {
            return call.getArgumentList().getTextRange().getEndOffset() - 1;
        }
        return offset + 2;
    }

    public static FakePsiElement createContextWithXxxVariable(final @NotNull PsiElement place, final @NotNull PsiType varType) {
        return new FakePsiElement(){

            public boolean processDeclarations(@NotNull PsiScopeProcessor processor2, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place2) {
                return processor2.execute(new LightVariableBuilder("xxx", varType, place2), ResolveState.initial());
            }

            public PsiElement getParent() {
                return place;
            }
        };
    }

    @NotNull
    public static String escapeXmlIfNeeded(InsertionContext context, @NotNull String generics) {
        if (context.getFile().getViewProvider().getBaseLanguage() == StdLanguages.JSPX) {
            return StringUtil.escapeXmlEntities((String)generics);
        }
        return generics;
    }

    public static boolean isEffectivelyDeprecated(PsiDocCommentOwner member) {
        if (member.isDeprecated()) {
            return true;
        }
        for (PsiClass aClass = member.getContainingClass(); aClass != null; aClass = aClass.getContainingClass()) {
            if (!aClass.isDeprecated()) continue;
            return true;
        }
        return false;
    }

    public static int findQualifiedNameStart(@NotNull InsertionContext context) {
        char ch;
        int start;
        for (start = context.getTailOffset() - 1; start >= 0 && (Character.isJavaIdentifierPart(ch = context.getDocument().getCharsSequence().charAt(start)) || ch == '.'); --start) {
        }
        return start + 1;
    }

    private static /* synthetic */ void lambda$processJavaQualifiedReference$5(Set mentioned, JavaCompletionProcessor processor2, Set set, StaticMemberProcessor memberProcessor, PsiMember member, PsiClass psiClass) {
        if (!mentioned.contains(member) && processor2.satisfies((PsiElement)member, ResolveState.initial())) {
            ContainerUtil.addIfNotNull((Collection)set, (Object)memberProcessor.createLookupElement(member, psiClass, true));
        }
    }

    private static /* synthetic */ void lambda$processJavaReference$3(int parameterIndex, PsiElement element, Set set, ElementFilter elementFilter, JavaCompletionProcessor.Options options, Condition nameCondition, CompletionParameters parameters2, PsiType functionalInterfaceType) {
        PsiType qualifierType = LambdaUtil.getLambdaParameterFromType((PsiType)functionalInterfaceType, (int)parameterIndex);
        if (qualifierType instanceof PsiWildcardType) {
            qualifierType = ((PsiWildcardType)qualifierType).getBound();
        }
        if (qualifierType == null) {
            return;
        }
        PsiReferenceExpression fakeRef = JavaCompletionUtil.createReference("xxx.xxx", (PsiElement)JavaCompletionUtil.createContextWithXxxVariable(element, qualifierType));
        set.addAll(JavaCompletionUtil.processJavaQualifiedReference(fakeRef.getReferenceNameElement(), (PsiJavaCodeReferenceElement)fakeRef, elementFilter, options, (Condition<String>)nameCondition, parameters2));
    }
}

