/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.ExpectedTypeInfo;
import com.intellij.codeInsight.ExpectedTypeInfoImpl;
import com.intellij.codeInsight.completion.AbstractExpectedTypeSkipper;
import com.intellij.codeInsight.completion.CompletionLocation;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionSorter;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.FunctionalExpressionCompletionProvider;
import com.intellij.codeInsight.completion.JavaCompletionUtil;
import com.intellij.codeInsight.completion.JavaConstructorCallElement;
import com.intellij.codeInsight.completion.JavaGenerateMemberCompletionContributor;
import com.intellij.codeInsight.completion.JavaMethodCallElement;
import com.intellij.codeInsight.completion.JavaSmartCompletionContributor;
import com.intellij.codeInsight.completion.PreferByKindWeigher;
import com.intellij.codeInsight.completion.PreferMostUsedWeigher;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.completion.RecursionWeigher;
import com.intellij.codeInsight.completion.SmartCastProvider;
import com.intellij.codeInsight.completion.TypeArgumentCompletionProvider;
import com.intellij.codeInsight.completion.impl.CompletionSorterImpl;
import com.intellij.codeInsight.completion.impl.LiftShorterItemsClassifier;
import com.intellij.codeInsight.lookup.Classifier;
import com.intellij.codeInsight.lookup.ClassifierFactory;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementWeigher;
import com.intellij.codeInsight.lookup.PsiTypeLookupItem;
import com.intellij.codeInsight.lookup.WeighingContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PsiJavaElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDocCommentOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.filters.getters.BuilderCompletionKt;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import gnu.trove.TObjectIntHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaCompletionSorting {
    private JavaCompletionSorting() {
    }

    public static CompletionResultSet addJavaSorting(CompletionParameters parameters2, CompletionResultSet result) {
        PsiElement position = parameters2.getPosition();
        Object[] expectedTypes = JavaCompletionSorting.getExpectedTypesWithDfa(parameters2, position);
        CompletionType type2 = parameters2.getCompletionType();
        boolean smart = type2 == CompletionType.SMART;
        boolean afterNew = JavaSmartCompletionContributor.AFTER_NEW.accepts((Object)position);
        ArrayList<LookupElementWeigher> afterProximity = new ArrayList<LookupElementWeigher>();
        ContainerUtil.addIfNotNull(afterProximity, (Object)((Object)PreferMostUsedWeigher.create(position)));
        afterProximity.add(new PreferContainingSameWords((ExpectedTypeInfo[])expectedTypes));
        afterProximity.add(new PreferShorter((ExpectedTypeInfo[])expectedTypes));
        afterProximity.add(new DispreferTechnicalOverloads(position));
        CompletionSorter sorter = CompletionSorter.defaultSorter((CompletionParameters)parameters2, (PrefixMatcher)result.getPrefixMatcher());
        if (!smart && afterNew) {
            sorter = sorter.weighBefore("liftShorter", new LookupElementWeigher[]{new PreferExpected(true, (ExpectedTypeInfo[])expectedTypes, position)});
        } else if (PsiTreeUtil.getParentOfType((PsiElement)position, PsiReferenceList.class) == null) {
            sorter = ((CompletionSorterImpl)sorter).withClassifier("liftShorterClasses", true, (ClassifierFactory)new LiftShorterClasses(position));
        }
        ArrayList<PreferDefaultTypeWeigher> afterPriority = new ArrayList<PreferDefaultTypeWeigher>();
        ContainerUtil.addIfNotNull(afterPriority, (Object)JavaCompletionSorting.dispreferPreviousChainCalls(position));
        if (smart) {
            afterPriority.add(new PreferDefaultTypeWeigher((ExpectedTypeInfo[])expectedTypes, parameters2, false));
        }
        sorter = sorter.weighAfter("priority", afterPriority.toArray(new LookupElementWeigher[0]));
        ArrayList<LookupElementWeigher> afterStats = new ArrayList<LookupElementWeigher>();
        afterStats.add(new PreferByKindWeigher(type2, position, (ExpectedTypeInfo[])expectedTypes));
        if (smart) {
            afterStats.add(new PreferDefaultTypeWeigher((ExpectedTypeInfo[])expectedTypes, parameters2, true));
        } else {
            if (!afterNew) {
                afterStats.add(new PreferExpected(false, (ExpectedTypeInfo[])expectedTypes, position));
            }
            ContainerUtil.addIfNotNull(afterStats, (Object)JavaCompletionSorting.preferStatics(position, (ExpectedTypeInfo[])expectedTypes));
        }
        ContainerUtil.addIfNotNull(afterStats, (Object)JavaCompletionSorting.recursion(parameters2, (ExpectedTypeInfo[])expectedTypes));
        afterStats.add(new PreferSimilarlyEnding((ExpectedTypeInfo[])expectedTypes));
        if (ContainerUtil.or((Object[])expectedTypes, info -> !info.getType().equals(PsiType.VOID))) {
            afterStats.add(new PreferNonGeneric());
        }
        Collections.addAll(afterStats, new LookupElementWeigher[]{new PreferAccessible(position), new PreferSimple()});
        sorter = sorter.weighAfter("stats", afterStats.toArray(new LookupElementWeigher[0]));
        sorter = sorter.weighAfter("proximity", afterProximity.toArray(new LookupElementWeigher[0]));
        return result.withRelevanceSorter(sorter);
    }

    @Nullable
    private static LookupElementWeigher dispreferPreviousChainCalls(PsiElement position) {
        final TObjectIntHashMap previousChainCalls = new TObjectIntHashMap();
        if (position.getParent() instanceof PsiReferenceExpression) {
            PsiClass qualifierClass;
            PsiReferenceExpression ref = (PsiReferenceExpression)position.getParent();
            PsiMethodCallExpression qualifier = JavaCompletionSorting.getCallQualifier(ref);
            PsiClass psiClass = qualifierClass = qualifier == null ? null : PsiUtil.resolveClassInClassTypeOnly((PsiType)qualifier.getType());
            if (BuilderCompletionKt.looksLikeBuilder(qualifierClass)) {
                while (qualifier != null) {
                    PsiMethod method = qualifier.resolveMethod();
                    if (method != null) {
                        boolean seemsLikeExpectsMultipleCalls;
                        String name2 = method.getName();
                        boolean bl = seemsLikeExpectsMultipleCalls = name2.startsWith("put") || name2.startsWith("add") || name2.startsWith("append") || name2.startsWith("get");
                        if (!seemsLikeExpectsMultipleCalls && qualifierClass == method.getContainingClass()) {
                            previousChainCalls.put((Object)method, previousChainCalls.get((Object)method) + 1);
                        }
                    }
                    qualifier = JavaCompletionSorting.getCallQualifier(qualifier.getMethodExpression());
                }
            }
        }
        return previousChainCalls.isEmpty() ? null : new LookupElementWeigher("dispreferPreviousChainCalls"){

            public Comparable weigh(@NotNull LookupElement element, @NotNull WeighingContext context) {
                PsiElement psi = element.getPsiElement();
                return Boolean.valueOf(psi instanceof PsiMethod && previousChainCalls.get((Object)((PsiMethod)psi)) == 1);
            }
        };
    }

    @Nullable
    private static PsiMethodCallExpression getCallQualifier(PsiReferenceExpression ref) {
        return (PsiMethodCallExpression)ObjectUtils.tryCast((Object)ref.getQualifier(), PsiMethodCallExpression.class);
    }

    private static ExpectedTypeInfo @NotNull [] getExpectedTypesWithDfa(CompletionParameters parameters2, PsiElement position) {
        if (((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().beforeLeaf((ElementPattern)PsiJavaPatterns.psiElement().withText("."))).accepts((Object)position)) {
            return ExpectedTypeInfo.EMPTY_ARRAY;
        }
        List<ExpectedTypeInfo> castExpectation = SmartCastProvider.getParenthesizedCastExpectationByOperandType(position);
        if (!castExpectation.isEmpty()) {
            return castExpectation.toArray(ExpectedTypeInfo.EMPTY_ARRAY);
        }
        return JavaSmartCompletionContributor.getExpectedTypes(parameters2);
    }

    @Nullable
    private static LookupElementWeigher recursion(CompletionParameters parameters2, ExpectedTypeInfo[] expectedInfos) {
        PsiReferenceExpression reference;
        PsiElement position = parameters2.getPosition();
        PsiMethodCallExpression expression2 = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)position, PsiMethodCallExpression.class, (boolean)true, (Class[])new Class[]{PsiClass.class});
        PsiReferenceExpression psiReferenceExpression = reference = expression2 != null ? expression2.getMethodExpression() : (PsiReferenceExpression)PsiTreeUtil.getParentOfType((PsiElement)position, PsiReferenceExpression.class);
        if (reference == null) {
            return null;
        }
        return new RecursionWeigher(position, parameters2.getCompletionType(), reference, expression2, expectedInfos);
    }

    @Nullable
    private static LookupElementWeigher preferStatics(PsiElement position, final ExpectedTypeInfo[] infos) {
        if (PsiTreeUtil.getParentOfType((PsiElement)position, PsiDocComment.class) != null) {
            return null;
        }
        if (position.getParent() instanceof PsiReferenceExpression) {
            PsiReferenceExpression refExpr = (PsiReferenceExpression)position.getParent();
            PsiElement qualifier = refExpr.getQualifier();
            if (qualifier == null) {
                return null;
            }
            if (!(qualifier instanceof PsiJavaCodeReferenceElement) || !(((PsiJavaCodeReferenceElement)qualifier).resolve() instanceof PsiClass)) {
                return null;
            }
        }
        return new LookupElementWeigher("statics"){

            @NotNull
            public Comparable weigh(@NotNull LookupElement element) {
                Object o;
                JavaConstructorCallElement call = (JavaConstructorCallElement)element.as(JavaConstructorCallElement.class);
                Object object = o = call != null ? call.getConstructedClass() : element.getObject();
                if (o instanceof PsiKeyword) {
                    return Integer.valueOf(-3);
                }
                if (!(o instanceof PsiMember) || element.getUserData(JavaGenerateMemberCompletionContributor.GENERATE_ELEMENT) != null) {
                    return Integer.valueOf(0);
                }
                if (((PsiMember)o).hasModifierProperty("static") && !JavaCompletionSorting.hasNonVoid(infos)) {
                    if (o instanceof PsiMethod) {
                        return Integer.valueOf(-5);
                    }
                    if (o instanceof PsiField) {
                        return Integer.valueOf(-4);
                    }
                }
                if (o instanceof PsiClass) {
                    return Integer.valueOf(-3);
                }
                return Integer.valueOf(-5);
            }
        };
    }

    private static ExpectedTypeMatching getExpectedTypeMatching(LookupElement item, ExpectedTypeInfo[] expectedInfos, @Nullable String expectedMemberName, @NotNull PsiElement position) {
        PsiType itemType = JavaCompletionUtil.getLookupElementType(item);
        if (itemType != null) {
            PsiUtil.ensureValidType((PsiType)itemType);
            for (ExpectedTypeInfo expectedInfo : expectedInfos) {
                PsiType expectedType = expectedInfo.getType();
                if (expectedInfo.getKind() == 2) {
                    if (!itemType.isAssignableFrom(expectedType)) continue;
                    return ExpectedTypeMatching.expected;
                }
                PsiType defaultType = expectedInfo.getDefaultType();
                if (defaultType != expectedType && defaultType.isAssignableFrom(itemType)) {
                    return ExpectedTypeMatching.ofDefaultType;
                }
                if (!expectedType.isAssignableFrom(itemType)) continue;
                return ExpectedTypeMatching.expected;
            }
        }
        if (JavaCompletionSorting.hasNonVoid(expectedInfos)) {
            String keyword;
            if (item.getObject() instanceof PsiKeyword && ("new".equals(keyword = ((PsiKeyword)item.getObject()).getText()) && !(position.getParent() instanceof PsiMethodReferenceExpression) || "null".equals(keyword))) {
                return ExpectedTypeMatching.maybeExpected;
            }
        } else if (expectedInfos.length > 0) {
            return ExpectedTypeMatching.unexpected;
        }
        return JavaCompletionSorting.preferByMemberName(expectedMemberName, itemType);
    }

    @NotNull
    private static ExpectedTypeMatching preferByMemberName(@Nullable String expectedMemberName, @Nullable PsiType itemType) {
        PsiClass itemClass;
        if (expectedMemberName != null && (itemClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)itemType)) != null && (itemClass.findMethodsByName(expectedMemberName, true).length > 0 || itemClass.findFieldByName(expectedMemberName, true) != null || itemClass.findInnerClassByName(expectedMemberName, true) != null)) {
            return ExpectedTypeMatching.expected;
        }
        return ExpectedTypeMatching.normal;
    }

    private static boolean hasNonVoid(ExpectedTypeInfo[] expectedInfos) {
        boolean hasNonVoid = false;
        for (ExpectedTypeInfo info : expectedInfos) {
            if (PsiType.VOID.equals((Object)info.getType())) continue;
            hasNonVoid = true;
        }
        return hasNonVoid;
    }

    @Nullable
    private static String getLookupObjectName(Object o) {
        if (o instanceof PsiVariable) {
            PsiVariable variable = (PsiVariable)o;
            JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)variable.getProject());
            VariableKind variableKind = codeStyleManager.getVariableKind(variable);
            return codeStyleManager.variableNameToPropertyName(variable.getName(), variableKind);
        }
        if (o instanceof PsiMethod) {
            return ((PsiMethod)o).getName();
        }
        return null;
    }

    private static int getNameEndMatchingDegree(String name2, ExpectedTypeInfo[] expectedInfos) {
        int res = 0;
        if (name2 != null && expectedInfos != null) {
            List words = NameUtil.nameToWordsLowerCase((String)name2);
            List wordsNoDigits = NameUtil.nameToWordsLowerCase((String)JavaCompletionSorting.truncDigits(name2));
            int max1 = JavaCompletionSorting.calcMatch(words, 0, expectedInfos);
            res = max1 = JavaCompletionSorting.calcMatch(wordsNoDigits, max1, expectedInfos);
        }
        return res;
    }

    private static String truncDigits(String name2) {
        char c;
        int count;
        for (count = name2.length() - 1; count >= 0 && Character.isDigit(c = name2.charAt(count)); --count) {
        }
        return name2.substring(0, count + 1);
    }

    private static int calcMatch(List<String> words, int max, ExpectedTypeInfo[] myExpectedInfos) {
        for (ExpectedTypeInfo myExpectedInfo : myExpectedInfos) {
            String expectedName = ((ExpectedTypeInfoImpl)myExpectedInfo).getExpectedName();
            if (expectedName == null) continue;
            max = JavaCompletionSorting.calcMatch(expectedName, words, max);
            max = JavaCompletionSorting.calcMatch(JavaCompletionSorting.truncDigits(expectedName), words, max);
        }
        return max;
    }

    private static int calcMatch(String expectedName, List<String> words, int max) {
        String expectedWord;
        String word;
        if (expectedName == null) {
            return max;
        }
        String[] expectedWords = NameUtil.nameToWords((String)expectedName);
        int limit = Math.min(words.size(), expectedWords.length);
        for (int i = 0; i < limit && ((word = words.get(words.size() - i - 1)).equalsIgnoreCase(expectedWord = expectedWords[expectedWords.length - i - 1]) || StringUtil.endsWithIgnoreCase((String)word, (String)expectedWord) || StringUtil.endsWithIgnoreCase((String)expectedWord, (String)word)); ++i) {
            max = Math.max(max, i + 1);
        }
        return max;
    }

    static boolean isTooGeneric(@NotNull LookupElement element, PsiMethod method) {
        PsiType type2 = method.getReturnType();
        JavaMethodCallElement callItem = (JavaMethodCallElement)element.as(JavaMethodCallElement.CLASS_CONDITION_KEY);
        if (callItem != null) {
            type2 = callItem.getSubstitutor().substitute(type2);
        }
        if (type2 instanceof PsiClassType) {
            PsiClass target = ((PsiClassType)type2).resolve();
            return target instanceof PsiTypeParameter && ((PsiTypeParameter)target).getOwner() instanceof PsiMethod;
        }
        return false;
    }

    private static class LiftShorterClasses
    extends ClassifierFactory<LookupElement> {
        final ProjectFileIndex fileIndex;
        private final PsiElement myPosition;

        LiftShorterClasses(PsiElement position) {
            super("liftShorterClasses");
            this.myPosition = position;
            this.fileIndex = ProjectRootManager.getInstance((Project)this.myPosition.getProject()).getFileIndex();
        }

        public Classifier<LookupElement> createClassifier(Classifier<LookupElement> next) {
            return new LiftShorterItemsClassifier("liftShorterClasses", next, new LiftShorterItemsClassifier.LiftingCondition(){

                public boolean shouldLift(LookupElement shorterElement, LookupElement longerElement) {
                    VirtualFile vFile;
                    PsiClass psiClass;
                    PsiFile file;
                    Object object = shorterElement.getObject();
                    return object instanceof PsiClass && longerElement.getObject() instanceof PsiClass && (file = (psiClass = (PsiClass)object).getContainingFile()) != null && (vFile = file.getOriginalFile().getVirtualFile()) != null && fileIndex.isInSource(vFile);
                }
            }, true);
        }
    }

    private static class DispreferTechnicalOverloads
    extends LookupElementWeigher {
        private final PsiElement myPlace;

        DispreferTechnicalOverloads(PsiElement place) {
            super("technicalOverloads");
            this.myPlace = place;
        }

        @NotNull
        public Comparable weigh(@NotNull LookupElement element) {
            Object object = element.getObject();
            if (object instanceof PsiMethod && element.getUserData(JavaCompletionUtil.FORCE_SHOW_SIGNATURE_ATTR) == null) {
                PsiMethod method = (PsiMethod)object;
                PsiClass containingClass = method.getContainingClass();
                if (!method.isVarArgs() && containingClass != null && ContainerUtil.exists((Object[])containingClass.findMethodsByName(method.getName(), false), m -> this.isPurelyVarargOverload(method, (PsiMethod)m))) {
                    return Boolean.valueOf(true);
                }
            }
            return Boolean.valueOf(false);
        }

        private boolean isPurelyVarargOverload(PsiMethod original, PsiMethod candidate) {
            return candidate.hasModifierProperty("static") == original.hasModifierProperty("static") && candidate.isVarArgs() && candidate.getParameterList().getParametersCount() == 1 && PsiResolveHelper.SERVICE.getInstance((Project)candidate.getProject()).isAccessible((PsiMember)candidate, this.myPlace, null);
        }
    }

    private static class PreferShorter
    extends LookupElementWeigher {
        private final ExpectedTypeInfo[] myExpectedTypes;

        PreferShorter(ExpectedTypeInfo[] expectedTypes) {
            super("shorter");
            this.myExpectedTypes = expectedTypes;
        }

        @NotNull
        public Comparable weigh(@NotNull LookupElement element) {
            Object object = element.getObject();
            String name2 = JavaCompletionSorting.getLookupObjectName(object);
            if (name2 != null && JavaCompletionSorting.getNameEndMatchingDegree(name2, this.myExpectedTypes) != 0) {
                return Integer.valueOf(NameUtil.nameToWords((String)name2).length - 1000);
            }
            return Integer.valueOf(0);
        }
    }

    private static class PreferContainingSameWords
    extends LookupElementWeigher {
        private final ExpectedTypeInfo[] myExpectedTypes;

        PreferContainingSameWords(ExpectedTypeInfo[] expectedTypes) {
            super("sameWords");
            this.myExpectedTypes = expectedTypes;
        }

        @NotNull
        public Comparable weigh(@NotNull LookupElement element) {
            Object object = element.getObject();
            String name2 = JavaCompletionSorting.getLookupObjectName(object);
            if (name2 != null) {
                int max = 0;
                List wordsNoDigits = NameUtil.nameToWordsLowerCase((String)JavaCompletionSorting.truncDigits(name2));
                for (ExpectedTypeInfo myExpectedInfo : this.myExpectedTypes) {
                    String expectedName = ((ExpectedTypeInfoImpl)myExpectedInfo).getExpectedName();
                    if (expectedName == null) continue;
                    THashSet set = new THashSet((Collection)NameUtil.nameToWordsLowerCase((String)JavaCompletionSorting.truncDigits(expectedName)));
                    set.retainAll((Collection)wordsNoDigits);
                    max = Math.max(max, set.size());
                }
                return Integer.valueOf(-max);
            }
            return Integer.valueOf(0);
        }
    }

    private static class PreferSimilarlyEnding
    extends LookupElementWeigher {
        private final ExpectedTypeInfo[] myExpectedTypes;

        PreferSimilarlyEnding(ExpectedTypeInfo[] expectedTypes) {
            super("nameEnd");
            this.myExpectedTypes = expectedTypes;
        }

        @NotNull
        public Comparable weigh(@NotNull LookupElement element) {
            String name2 = JavaCompletionSorting.getLookupObjectName(element.getObject());
            return Integer.valueOf(-JavaCompletionSorting.getNameEndMatchingDegree(name2, this.myExpectedTypes));
        }
    }

    private static class PreferExpected
    extends LookupElementWeigher {
        private final boolean myConstructorPossible;
        private final ExpectedTypeInfo[] myExpectedTypes;
        private final PsiElement myPosition;
        private final List<PsiType> myExpectedClasses = new SmartList();
        private final String myExpectedMemberName;

        PreferExpected(boolean constructorPossible, ExpectedTypeInfo[] expectedTypes, PsiElement position) {
            super("expectedType");
            this.myConstructorPossible = constructorPossible;
            this.myExpectedTypes = expectedTypes;
            this.myPosition = position;
            for (ExpectedTypeInfo info : expectedTypes) {
                ContainerUtil.addIfNotNull(this.myExpectedClasses, (Object)PsiUtil.substituteTypeParameter((PsiType)info.getDefaultType(), (String)"java.lang.Class", (int)0, (boolean)false));
            }
            this.myExpectedMemberName = PreferExpected.calcExpectedMemberNameByParentCall(position);
        }

        @Nullable
        private static String calcExpectedMemberNameByParentCall(PsiElement position) {
            PsiElement grand;
            if (position.getParent() instanceof PsiJavaCodeReferenceElement && (grand = position.getParent().getParent()) instanceof PsiJavaCodeReferenceElement && ((PsiJavaCodeReferenceElement)grand).getQualifier() == position.getParent()) {
                return ((PsiJavaCodeReferenceElement)grand).getReferenceName();
            }
            return null;
        }

        @NotNull
        public ExpectedTypeMatching weigh(@NotNull LookupElement item) {
            if (item.getObject() instanceof PsiClass && !this.myConstructorPossible) {
                ExpectedTypeMatching byName;
                PsiType itemType = JavaCompletionUtil.getLookupElementType(item);
                if (itemType != null) {
                    for (PsiType expectedClass : this.myExpectedClasses) {
                        if (!expectedClass.isAssignableFrom(itemType)) continue;
                        return ExpectedTypeMatching.expected;
                    }
                }
                if ((byName = JavaCompletionSorting.preferByMemberName(this.myExpectedMemberName, itemType)) != ExpectedTypeMatching.normal) {
                    return byName;
                }
            }
            return JavaCompletionSorting.getExpectedTypeMatching(item, this.myExpectedTypes, this.myExpectedMemberName, this.myPosition);
        }
    }

    private static class PreferSimple
    extends LookupElementWeigher {
        PreferSimple() {
            super("simple");
        }

        @NotNull
        public Comparable weigh(@NotNull LookupElement element) {
            PsiTypeLookupItem lookupItem = (PsiTypeLookupItem)element.as(PsiTypeLookupItem.CLASS_CONDITION_KEY);
            if (lookupItem != null) {
                return Integer.valueOf(lookupItem.getBracketsCount() * 10 + (lookupItem.isAddArrayInitializer() ? 1 : 0));
            }
            return Integer.valueOf(0);
        }
    }

    private static class PreferNonGeneric
    extends LookupElementWeigher {
        PreferNonGeneric() {
            super("nonGeneric");
        }

        @NotNull
        public Integer weigh(@NotNull LookupElement element) {
            Object object = element.getObject();
            return object instanceof PsiMethod && !FunctionalExpressionCompletionProvider.isFunExprItem(element) && JavaCompletionSorting.isTooGeneric(element, (PsiMethod)object) ? 1 : 0;
        }
    }

    private static class PreferAccessible
    extends LookupElementWeigher {
        private final PsiElement myPosition;

        PreferAccessible(PsiElement position) {
            super("accessible");
            this.myPosition = position;
        }

        @NotNull
        public Comparable weigh(@NotNull LookupElement element) {
            Object object = element.getObject();
            if (object instanceof PsiDocCommentOwner) {
                PsiDocCommentOwner member = (PsiDocCommentOwner)object;
                if (!JavaPsiFacade.getInstance((Project)member.getProject()).getResolveHelper().isAccessible((PsiMember)member, this.myPosition, null)) {
                    return MyEnum.INACCESSIBLE;
                }
                if (JavaCompletionUtil.isEffectivelyDeprecated(member)) {
                    return MyEnum.DEPRECATED;
                }
            }
            return MyEnum.NORMAL;
        }

        private static enum MyEnum {
            NORMAL,
            DEPRECATED,
            INACCESSIBLE;

        }
    }

    private static enum ExpectedTypeMatching {
        ofDefaultType,
        expected,
        maybeExpected,
        normal,
        unexpected;

    }

    private static class PreferDefaultTypeWeigher
    extends LookupElementWeigher {
        private final PsiTypeParameter myTypeParameter;
        private final ExpectedTypeInfo[] myExpectedTypes;
        private final CompletionParameters myParameters;
        private final boolean myPreferExact;
        private final CompletionLocation myLocation;

        PreferDefaultTypeWeigher(ExpectedTypeInfo @NotNull [] expectedTypes, CompletionParameters parameters2, boolean preferExact) {
            super("defaultType" + (preferExact ? "Exact" : ""));
            this.myExpectedTypes = (ExpectedTypeInfo[])ContainerUtil.map2Array((Object[])expectedTypes, ExpectedTypeInfo.class, info -> {
                PsiType type2 = PreferDefaultTypeWeigher.removeClassWildcard(info.getType());
                PsiType defaultType = PreferDefaultTypeWeigher.removeClassWildcard(info.getDefaultType());
                if (type2 == info.getType() && defaultType == info.getDefaultType()) {
                    return info;
                }
                return new ExpectedTypeInfoImpl(type2, info.getKind(), defaultType, info.getTailType(), null, ExpectedTypeInfoImpl.NULL);
            });
            this.myParameters = parameters2;
            this.myPreferExact = preferExact;
            Pair<PsiTypeParameterListOwner, Integer> pair2 = TypeArgumentCompletionProvider.getTypeParameterInfo(parameters2.getPosition());
            this.myTypeParameter = pair2 == null ? null : ((PsiTypeParameterListOwner)pair2.first).getTypeParameters()[(Integer)pair2.second];
            this.myLocation = new CompletionLocation(this.myParameters);
        }

        @NotNull
        public MyResult weigh(@NotNull LookupElement item) {
            Object object = item.getObject();
            if (object instanceof PsiClass) {
                if (object instanceof PsiTypeParameter) {
                    return MyResult.typeParameter;
                }
                if (this.myTypeParameter != null && object.equals(PsiUtil.resolveClassInType((PsiType)TypeConversionUtil.typeParameterErasure((PsiTypeParameter)this.myTypeParameter)))) {
                    return MyResult.exactlyExpected;
                }
            }
            if (this.returnsUnboundType(item)) {
                return MyResult.normal;
            }
            PsiType itemType = JavaCompletionUtil.getLookupElementType(item);
            if ((this.myPreferExact || object instanceof PsiClass) && this.isExactlyExpected(item, itemType)) {
                return AbstractExpectedTypeSkipper.skips(item, this.myLocation) ? MyResult.expectedNoSelect : MyResult.exactlyExpected;
            }
            if (itemType == null) {
                return MyResult.normal;
            }
            for (ExpectedTypeInfo expectedInfo : this.myExpectedTypes) {
                PsiType expectedType;
                PsiType defaultType = expectedInfo.getDefaultType();
                if (defaultType != (expectedType = expectedInfo.getType())) {
                    if (this.myPreferExact && defaultType.equals(itemType)) {
                        return MyResult.exactlyDefault;
                    }
                    if (defaultType.isAssignableFrom(itemType)) {
                        return MyResult.ofDefaultType;
                    }
                }
                if (!PsiType.VOID.equals((Object)itemType) || !PsiType.VOID.equals((Object)expectedType)) continue;
                return MyResult.exactlyExpected;
            }
            return MyResult.normal;
        }

        private boolean isExactlyExpected(@NotNull LookupElement item, @Nullable PsiType itemType) {
            if (JavaCompletionUtil.SUPER_METHOD_PARAMETERS.get((UserDataHolder)item) != null) {
                return true;
            }
            if (itemType == null || itemType.equalsToText("java.lang.Object")) {
                return false;
            }
            return ContainerUtil.exists((Object[])this.myExpectedTypes, info -> this.box(info.getType().getDeepComponentType()).equals(this.box(itemType)));
        }

        private boolean returnsUnboundType(@NotNull LookupElement item) {
            JavaMethodCallElement call = (JavaMethodCallElement)item.as(JavaMethodCallElement.CLASS_CONDITION_KEY);
            if (call != null && !call.getInferenceSubstitutor().equals(PsiSubstitutor.EMPTY)) {
                PsiType callType = TypeConversionUtil.erasure((PsiType)call.getSubstitutor().substitute(((PsiMethod)call.getObject()).getReturnType()));
                return callType == null || Arrays.stream(this.myExpectedTypes).noneMatch(i -> PreferDefaultTypeWeigher.canBeExpected(callType, i));
            }
            return false;
        }

        private static boolean canBeExpected(PsiType callType, ExpectedTypeInfo info) {
            PsiType expectedType = TypeConversionUtil.erasure((PsiType)info.getType());
            return expectedType != null && TypeConversionUtil.isAssignable((PsiType)expectedType, (PsiType)callType);
        }

        private PsiType box(PsiType expectedType) {
            PsiType boxed = expectedType instanceof PsiPrimitiveType ? ((PsiPrimitiveType)expectedType).getBoxedType(this.myParameters.getPosition()) : null;
            return boxed != null ? boxed : expectedType;
        }

        private static PsiType removeClassWildcard(PsiType type2) {
            PsiClassType erased;
            PsiType[] parameters2;
            PsiClass psiClass;
            if (type2 instanceof PsiClassType && (psiClass = ((PsiClassType)type2).resolve()) != null && "java.lang.Class".equals(psiClass.getQualifiedName()) && (parameters2 = (erased = (PsiClassType)GenericsUtil.eliminateWildcards((PsiType)type2)).getParameters()).length == 1 && !parameters2[0].equalsToText("java.lang.Object")) {
                return erased;
            }
            return type2;
        }

        private static enum MyResult {
            expectedNoSelect,
            typeParameter,
            exactlyDefault,
            ofDefaultType,
            exactlyExpected,
            normal;

        }
    }
}

