/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.ExceptionUtil;
import com.intellij.codeInsight.TailType;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.JavaCompletionSession;
import com.intellij.codeInsight.completion.JavaInheritorsGetter;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.PsiTypeLookupItem;
import com.intellij.codeInsight.lookup.TailTypeDecorator;
import com.intellij.openapi.project.Project;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Consumer;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class CatchTypeProvider {
    static final ElementPattern<PsiElement> CATCH_CLAUSE_TYPE = PlatformPatterns.psiElement().insideStarting((ElementPattern)PlatformPatterns.psiElement(PsiTypeElement.class).withParent((ElementPattern)PlatformPatterns.psiElement(PsiCatchSection.class)));

    CatchTypeProvider() {
    }

    static void addCompletions(@NotNull CompletionParameters parameters2, @NotNull CompletionResultSet result) {
        PsiCodeBlock tryBlock;
        PsiTryStatement tryStatement = (PsiTryStatement)PsiTreeUtil.getParentOfType((PsiElement)parameters2.getPosition(), PsiTryStatement.class);
        PsiCodeBlock psiCodeBlock = tryBlock = tryStatement == null ? null : tryStatement.getTryBlock();
        if (tryBlock == null) {
            return;
        }
        JavaCompletionSession session = new JavaCompletionSession(result);
        for (PsiClassType type3 : ExceptionUtil.getThrownExceptions((PsiElement[])tryBlock.getStatements())) {
            PsiClass typeClass = type3.resolve();
            if (typeClass == null) continue;
            result.addElement(CatchTypeProvider.createCatchTypeVariant(tryBlock, type3));
            session.registerClass(typeClass);
        }
        List<PsiClassType> expectedClassTypes = Collections.singletonList(JavaPsiFacade.getElementFactory((Project)tryBlock.getProject()).createTypeByFQClassName("java.lang.Throwable"));
        JavaInheritorsGetter.processInheritors(parameters2, expectedClassTypes, result.getPrefixMatcher(), (Consumer<? super PsiType>)((Consumer)type2 -> {
            PsiClass psiClass;
            PsiClass psiClass2 = psiClass = type2 instanceof PsiClassType ? ((PsiClassType)type2).resolve() : null;
            if (psiClass == null || psiClass instanceof PsiTypeParameter) {
                return;
            }
            if (!session.alreadyProcessed(psiClass)) {
                result.addElement(CatchTypeProvider.createCatchTypeVariant(tryBlock, (PsiClassType)type2));
            }
        }));
    }

    @NotNull
    private static LookupElement createCatchTypeVariant(PsiCodeBlock tryBlock, PsiClassType type2) {
        return TailTypeDecorator.withTail((LookupElement)PsiTypeLookupItem.createLookupItem((PsiType)type2, (PsiElement)tryBlock), (TailType)TailType.HUMBLE_SPACE_BEFORE_WORD);
    }
}

