/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.BaseExternalAnnotationsManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.AnnotationOrderRootType;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReadableExternalAnnotationsManager
extends BaseExternalAnnotationsManager {
    @Nullable
    private Set<VirtualFile> myAnnotationsRoots;

    public ReadableExternalAnnotationsManager(PsiManager psiManager) {
        super(psiManager);
    }

    @Override
    protected boolean hasAnyAnnotationsRoots() {
        return !this.initRoots().isEmpty();
    }

    @NotNull
    private synchronized Set<VirtualFile> initRoots() {
        if (this.myAnnotationsRoots == null) {
            Module[] modules;
            this.myAnnotationsRoots = new HashSet<VirtualFile>();
            for (Module module : modules = ModuleManager.getInstance((Project)this.myPsiManager.getProject()).getModules()) {
                for (OrderEntry entry : ModuleRootManager.getInstance((Module)module).getOrderEntries()) {
                    VirtualFile[] files = AnnotationOrderRootType.getFiles((OrderEntry)entry);
                    if (files.length <= 0) continue;
                    Collections.addAll(this.myAnnotationsRoots, files);
                }
            }
        }
        return this.myAnnotationsRoots;
    }

    @Override
    @NotNull
    protected List<VirtualFile> getExternalAnnotationsRoots(@NotNull VirtualFile libraryFile) {
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)this.myPsiManager.getProject()).getFileIndex();
        LinkedHashSet result = new LinkedHashSet();
        for (OrderEntry entry : fileIndex.getOrderEntriesForFile(libraryFile)) {
            ProgressManager.checkCanceled();
            if (entry instanceof ModuleOrderEntry) continue;
            Collections.addAll(result, AnnotationOrderRootType.getFiles((OrderEntry)entry));
        }
        return new ArrayList<VirtualFile>(result);
    }

    @Override
    protected synchronized void dropCache() {
        this.myAnnotationsRoots = null;
        super.dropCache();
    }

    public boolean isUnderAnnotationRoot(VirtualFile file) {
        return VfsUtilCore.isUnder((VirtualFile)file, this.initRoots());
    }
}

