/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.BaseExternalAnnotationsManager;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import java.util.Arrays;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalAnnotation {
    @NotNull
    private final PsiModifierListOwner owner;
    @NotNull
    private final String annotationFQName;
    private final PsiNameValuePair @Nullable [] values;

    public ExternalAnnotation(@NotNull PsiModifierListOwner owner2, @NotNull String annotationFQName, PsiNameValuePair @Nullable [] values) {
        if (BaseExternalAnnotationsManager.getExternalName(owner2) == null) {
            throw new IllegalArgumentException("Unable to annotate externally element of type " + owner2.getClass());
        }
        this.owner = owner2;
        this.annotationFQName = annotationFQName;
        this.values = values;
    }

    @NotNull
    public PsiModifierListOwner getOwner() {
        return this.owner;
    }

    @NotNull
    public String getAnnotationFQName() {
        return this.annotationFQName;
    }

    public PsiNameValuePair[] getValues() {
        return this.values;
    }

    public String toString() {
        return "ExternalAnnotation{owner=" + this.owner + ", annotationFQName='" + this.annotationFQName + '\'' + ", values=" + Arrays.toString(this.values) + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExternalAnnotation that = (ExternalAnnotation)o;
        return Objects.equals(this.owner, that.owner) && Objects.equals(this.annotationFQName, that.annotationFQName) && Arrays.equals(this.values, that.values);
    }

    public int hashCode() {
        int result = Objects.hash(this.owner, this.annotationFQName);
        result = 31 * result + Arrays.hashCode(this.values);
        return result;
    }
}

