/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options;

import com.intellij.application.options.CodeStyleImportsPanelBase;
import com.intellij.application.options.FullyQualifiedNamesInJavadocOptionProvider;
import com.intellij.java.JavaBundle;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.JavaCodeStyleSettings;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.JBColor;
import com.intellij.ui.OptionGroup;
import com.intellij.ui.TableUtil;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.table.TableView;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.TableCellEditor;
import org.jetbrains.annotations.NotNull;

class JavaCodeStyleImportsPanel
extends CodeStyleImportsPanelBase {
    private FullyQualifiedNamesInJavadocOptionProvider myFqnInJavadocOption;
    private ListTableModel<InnerClassItem> doNotInsertInnerListModel;
    private static final ColumnInfo[] INNER_CLASS_COLUMNS = new ColumnInfo[]{new MyColumnInfo(JavaBundle.message((String)"do.not.import.inner.classes.for", (Object[])new Object[0])){

        public String valueOf(InnerClassItem innerClass) {
            return innerClass.getName();
        }

        public void setValue(InnerClassItem innerClass, String name2) {
            innerClass.setName(name2);
        }
    }};
    private TableView<InnerClassItem> mydoNotInsertInnerTable;

    JavaCodeStyleImportsPanel() {
    }

    @Override
    protected void fillCustomOptions(OptionGroup group) {
        this.myFqnInJavadocOption = new FullyQualifiedNamesInJavadocOptionProvider();
        group.add((JComponent)this.createDoNotImportInnerListControl(), true);
        group.add((JComponent)this.myFqnInJavadocOption.getPanel());
    }

    @Override
    public void apply(CodeStyleSettings settings) {
        JavaCodeStyleSettings javaSettings = JavaCodeStyleImportsPanel.getJavaSettings(settings);
        this.applyLayoutSettings(javaSettings);
        this.myFqnInJavadocOption.apply(settings);
        javaSettings.setDoNotImportInner(this.getInnerClassesNames());
    }

    @Override
    public void reset(CodeStyleSettings settings) {
        JavaCodeStyleSettings javaSettings = JavaCodeStyleImportsPanel.getJavaSettings(settings);
        this.resetLayoutSettings(javaSettings);
        this.myFqnInJavadocOption.reset(settings);
        for (String name2 : javaSettings.getDoNotImportInner()) {
            this.doNotInsertInnerListModel.addRow((Object)new InnerClassItem(name2));
        }
        this.mydoNotInsertInnerTable.setEnabled(this.myCbInsertInnerClassImports.getModel().isSelected());
    }

    @Override
    public boolean isModified(CodeStyleSettings settings) {
        JavaCodeStyleSettings javaSettings = JavaCodeStyleImportsPanel.getJavaSettings(settings);
        boolean isModified = this.isModifiedLayoutSettings(javaSettings);
        isModified |= this.myFqnInJavadocOption.isModified(settings);
        return isModified |= !javaSettings.getDoNotImportInner().equals(this.getInnerClassesNames());
    }

    private static JavaCodeStyleSettings getJavaSettings(@NotNull CodeStyleSettings settings) {
        return (JavaCodeStyleSettings)settings.getCustomSettings(JavaCodeStyleSettings.class);
    }

    public JPanel createDoNotImportInnerListControl() {
        JPanel panel2 = new JPanel();
        panel2.setLayout(new BorderLayout());
        panel2.setPreferredSize(new Dimension(100, 150));
        this.doNotInsertInnerListModel = new ListTableModel(INNER_CLASS_COLUMNS);
        this.mydoNotInsertInnerTable = new TableView(this.doNotInsertInnerListModel);
        this.mydoNotInsertInnerTable.getEmptyText().setText(JavaBundle.message((String)"do.not.import.inner.classes.no.classes", (Object[])new Object[0]));
        this.myCbInsertInnerClassImports.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                JavaCodeStyleImportsPanel.this.mydoNotInsertInnerTable.setEnabled(JavaCodeStyleImportsPanel.this.myCbInsertInnerClassImports.getModel().isSelected());
            }
        });
        panel2.add((Component)ToolbarDecorator.createDecorator(this.mydoNotInsertInnerTable).setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                JavaCodeStyleImportsPanel.this.addInnerClass();
            }
        }).setRemoveAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                JavaCodeStyleImportsPanel.this.removeInnerClass();
            }
        }).disableUpDownActions().createPanel(), "Center");
        return panel2;
    }

    private void addInnerClass() {
        ArrayList<InnerClassItem> newItems = new ArrayList<InnerClassItem>(this.doNotInsertInnerListModel.getItems());
        InnerClassItem parameter2 = new InnerClassItem("");
        newItems.add(parameter2);
        this.doNotInsertInnerListModel.setItems(newItems);
        int index = newItems.size() - 1;
        this.mydoNotInsertInnerTable.getSelectionModel().setSelectionInterval(index, index);
        this.mydoNotInsertInnerTable.scrollRectToVisible(this.mydoNotInsertInnerTable.getCellRect(index, 0, true));
    }

    private void removeInnerClass() {
        TableUtil.removeSelectedItems(this.mydoNotInsertInnerTable);
    }

    private List<String> getInnerClassesNames() {
        ArrayList<String> items = new ArrayList<String>();
        for (InnerClassItem item : this.doNotInsertInnerListModel.getItems()) {
            String name2 = item.getName().trim();
            if (name2.isEmpty()) continue;
            items.add(name2);
        }
        return items;
    }

    private static class InnerClassItem {
        private String myName;

        InnerClassItem(String name2) {
            this.myName = name2;
        }

        public String getName() {
            return this.myName;
        }

        public void setName(String name2) {
            this.myName = name2;
        }
    }

    private static abstract class MyColumnInfo
    extends ColumnInfo<InnerClassItem, String> {
        MyColumnInfo(String name2) {
            super(name2);
        }

        public TableCellEditor getEditor(InnerClassItem item) {
            JTextField textField = new JTextField();
            textField.setBorder(BorderFactory.createLineBorder((Color)JBColor.BLACK));
            return new DefaultCellEditor(textField);
        }

        public boolean isCellEditable(InnerClassItem innerClass) {
            return true;
        }
    }
}

