/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options;

import com.intellij.ide.highlighter.JavaHighlightingColors;
import com.intellij.java.JavaBundle;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.psi.codeStyle.PackageEntry;
import com.intellij.psi.codeStyle.PackageEntryTable;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.BooleanTableCellRenderer;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.DumbAwareActionButton;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TableUtil;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.table.JBTable;
import com.intellij.util.IconUtil;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import javax.swing.DefaultCellEditor;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ImportLayoutPanel
extends JPanel {
    private final JBCheckBox myCbLayoutStaticImportsSeparately = new JBCheckBox(JavaBundle.message((String)"import.layout.static.imports.separately", (Object[])new Object[0]));
    private final JBTable myImportLayoutTable;
    private final PackageEntryTable myImportLayoutList = new PackageEntryTable();

    public JBTable getImportLayoutTable() {
        return this.myImportLayoutTable;
    }

    public PackageEntryTable getImportLayoutList() {
        return this.myImportLayoutList;
    }

    public JBCheckBox getCbLayoutStaticImportsSeparately() {
        return this.myCbLayoutStaticImportsSeparately;
    }

    public ImportLayoutPanel() {
        super(new BorderLayout());
        this.setBorder((Border)IdeBorderFactory.createTitledBorder((String)JavaBundle.message((String)"title.import.layout", (Object[])new Object[0]), (boolean)false, (Insets)JBUI.emptyInsets()));
        this.myCbLayoutStaticImportsSeparately.addItemListener(e -> {
            if (this.areStaticImportsEnabled()) {
                boolean found = false;
                for (int i = this.myImportLayoutList.getEntryCount() - 1; i >= 0; --i) {
                    PackageEntry entry = this.myImportLayoutList.getEntryAt(i);
                    if (entry != PackageEntry.ALL_OTHER_STATIC_IMPORTS_ENTRY) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    int index = this.myImportLayoutList.getEntryCount();
                    if (index != 0 && this.myImportLayoutList.getEntryAt(index - 1) != PackageEntry.BLANK_LINE_ENTRY) {
                        this.myImportLayoutList.addEntry(PackageEntry.BLANK_LINE_ENTRY);
                    }
                    this.myImportLayoutList.addEntry(PackageEntry.ALL_OTHER_STATIC_IMPORTS_ENTRY);
                }
            } else {
                for (int i = this.myImportLayoutList.getEntryCount() - 1; i >= 0; --i) {
                    PackageEntry entry = this.myImportLayoutList.getEntryAt(i);
                    if (!entry.isStatic()) continue;
                    this.myImportLayoutList.removeEntryAt(i);
                }
            }
            this.refresh();
        });
        this.add((Component)this.myCbLayoutStaticImportsSeparately, "North");
        this.myImportLayoutTable = ImportLayoutPanel.createTableForPackageEntries(this.myImportLayoutList, this);
        JPanel importLayoutPanel = ToolbarDecorator.createDecorator((JTable)this.myImportLayoutTable).addExtraAction((AnActionButton)new DumbAwareActionButton(JavaBundle.messagePointer((String)"button.add.package", (Object[])new Object[0]), IconUtil.getAddPackageIcon()){

            public void actionPerformed(@NotNull AnActionEvent e) {
                ImportLayoutPanel.this.addPackageToImportLayouts();
            }

            public ShortcutSet getShortcut() {
                return CommonShortcuts.getNewForDialogs();
            }
        }).addExtraAction((AnActionButton)new DumbAwareActionButton(JavaBundle.messagePointer((String)"button.add.blank", (Object[])new Object[0]), IconUtil.getAddBlankLineIcon()){

            public void actionPerformed(@NotNull AnActionEvent e) {
                ImportLayoutPanel.this.addBlankLine();
            }
        }).setRemoveAction(button -> this.removeEntryFromImportLayouts()).setMoveUpAction(button -> this.moveRowUp()).setMoveDownAction(button -> this.moveRowDown()).setRemoveActionUpdater(e -> {
            int selectedImport = this.myImportLayoutTable.getSelectedRow();
            PackageEntry entry = selectedImport < 0 ? null : this.myImportLayoutList.getEntryAt(selectedImport);
            return entry != null && entry != PackageEntry.ALL_OTHER_STATIC_IMPORTS_ENTRY && entry != PackageEntry.ALL_OTHER_IMPORTS_ENTRY;
        }).setButtonComparator(new String[]{JavaBundle.message((String)"button.add.package", (Object[])new Object[0]), JavaBundle.message((String)"button.add.blank", (Object[])new Object[0]), "Remove", "Up", "Down"}).setPreferredSize(new Dimension(-1, 100)).createPanel();
        this.add((Component)importLayoutPanel, "Center");
    }

    public abstract void refresh();

    private void addPackageToImportLayouts() {
        int selected = this.myImportLayoutTable.getSelectedRow() + 1;
        if (selected < 0) {
            selected = this.myImportLayoutList.getEntryCount();
        }
        PackageEntry entry = new PackageEntry(false, "", true);
        this.myImportLayoutList.insertEntryAt(entry, selected);
        ImportLayoutPanel.refreshTableModel(selected, this.myImportLayoutTable);
    }

    private void addBlankLine() {
        int selected = this.myImportLayoutTable.getSelectedRow() + 1;
        if (selected < 0) {
            selected = this.myImportLayoutList.getEntryCount();
        }
        this.myImportLayoutList.insertEntryAt(PackageEntry.BLANK_LINE_ENTRY, selected);
        AbstractTableModel model = (AbstractTableModel)this.myImportLayoutTable.getModel();
        model.fireTableRowsInserted(selected, selected);
        this.myImportLayoutTable.setRowSelectionInterval(selected, selected);
    }

    private void removeEntryFromImportLayouts() {
        int selected = this.myImportLayoutTable.getSelectedRow();
        if (selected < 0) {
            return;
        }
        PackageEntry entry = this.myImportLayoutList.getEntryAt(selected);
        if (entry == PackageEntry.ALL_OTHER_STATIC_IMPORTS_ENTRY || entry == PackageEntry.ALL_OTHER_IMPORTS_ENTRY) {
            return;
        }
        TableUtil.stopEditing((JTable)this.myImportLayoutTable);
        this.myImportLayoutList.removeEntryAt(selected);
        AbstractTableModel model = (AbstractTableModel)this.myImportLayoutTable.getModel();
        model.fireTableRowsDeleted(selected, selected);
        if (selected >= this.myImportLayoutList.getEntryCount()) {
            --selected;
        }
        if (selected >= 0) {
            this.myImportLayoutTable.setRowSelectionInterval(selected, selected);
        }
    }

    private void moveRowUp() {
        int selected = this.myImportLayoutTable.getSelectedRow();
        if (selected < 1) {
            return;
        }
        TableUtil.stopEditing((JTable)this.myImportLayoutTable);
        PackageEntry entry = this.myImportLayoutList.getEntryAt(selected);
        PackageEntry previousEntry = this.myImportLayoutList.getEntryAt(selected - 1);
        this.myImportLayoutList.setEntryAt(previousEntry, selected);
        this.myImportLayoutList.setEntryAt(entry, selected - 1);
        AbstractTableModel model = (AbstractTableModel)this.myImportLayoutTable.getModel();
        model.fireTableRowsUpdated(selected - 1, selected);
        this.myImportLayoutTable.setRowSelectionInterval(selected - 1, selected - 1);
    }

    private void moveRowDown() {
        int selected = this.myImportLayoutTable.getSelectedRow();
        if (selected >= this.myImportLayoutList.getEntryCount() - 1) {
            return;
        }
        TableUtil.stopEditing((JTable)this.myImportLayoutTable);
        PackageEntry entry = this.myImportLayoutList.getEntryAt(selected);
        PackageEntry nextEntry = this.myImportLayoutList.getEntryAt(selected + 1);
        this.myImportLayoutList.setEntryAt(nextEntry, selected);
        this.myImportLayoutList.setEntryAt(entry, selected + 1);
        AbstractTableModel model = (AbstractTableModel)this.myImportLayoutTable.getModel();
        model.fireTableRowsUpdated(selected, selected + 1);
        this.myImportLayoutTable.setRowSelectionInterval(selected + 1, selected + 1);
    }

    public boolean areStaticImportsEnabled() {
        return this.myCbLayoutStaticImportsSeparately.isSelected();
    }

    public static JBTable createTableForPackageEntries(final PackageEntryTable packageTable, final ImportLayoutPanel panel2) {
        final String[] names2 = new String[]{JavaBundle.message((String)"listbox.import.package", (Object[])new Object[0]), JavaBundle.message((String)"listbox.import.with.subpackages", (Object[])new Object[0])};
        AbstractTableModel dataModel = new AbstractTableModel(){

            @Override
            public int getColumnCount() {
                return names2.length + (panel2.areStaticImportsEnabled() ? 1 : 0);
            }

            @Override
            public int getRowCount() {
                return packageTable.getEntryCount();
            }

            @Override
            @Nullable
            public Object getValueAt(int row, int col) {
                PackageEntry entry = packageTable.getEntryAt(row);
                if (entry == null || !this.isCellEditable(row, col)) {
                    return null;
                }
                if ((col += panel2.areStaticImportsEnabled() ? 0 : 1) == 0) {
                    return entry.isStatic();
                }
                if (col == 1) {
                    return entry.getPackageName();
                }
                if (col == 2) {
                    return entry.isWithSubpackages();
                }
                throw new IllegalArgumentException(String.valueOf(col));
            }

            @Override
            public String getColumnName(int column) {
                if (panel2.areStaticImportsEnabled() && column == 0) {
                    return JavaBundle.message((String)"listbox.import.static", (Object[])new Object[0]);
                }
                return names2[column -= panel2.areStaticImportsEnabled() ? 1 : 0];
            }

            public Class getColumnClass(int col) {
                if ((col += panel2.areStaticImportsEnabled() ? 0 : 1) == 0) {
                    return Boolean.class;
                }
                if (col == 1) {
                    return String.class;
                }
                if (col == 2) {
                    return Boolean.class;
                }
                throw new IllegalArgumentException(String.valueOf(col));
            }

            @Override
            public boolean isCellEditable(int row, int col) {
                PackageEntry packageEntry = packageTable.getEntryAt(row);
                return !packageEntry.isSpecial();
            }

            @Override
            public void setValueAt(Object aValue, int row, int col) {
                PackageEntry packageEntry = packageTable.getEntryAt(row);
                if ((col += panel2.areStaticImportsEnabled() ? 0 : 1) == 0) {
                    PackageEntry newPackageEntry = new PackageEntry(((Boolean)aValue).booleanValue(), packageEntry.getPackageName(), packageEntry.isWithSubpackages());
                    packageTable.setEntryAt(newPackageEntry, row);
                } else if (col == 1) {
                    PackageEntry newPackageEntry = new PackageEntry(packageEntry.isStatic(), ((String)aValue).trim(), packageEntry.isWithSubpackages());
                    packageTable.setEntryAt(newPackageEntry, row);
                } else if (col == 2) {
                    PackageEntry newPackageEntry = new PackageEntry(packageEntry.isStatic(), packageEntry.getPackageName(), ((Boolean)aValue).booleanValue());
                    packageTable.setEntryAt(newPackageEntry, row);
                } else {
                    throw new IllegalArgumentException(String.valueOf(col));
                }
            }
        };
        final JBTable result = new JBTable((TableModel)dataModel);
        result.getSelectionModel().setSelectionMode(0);
        ImportLayoutPanel.resizeColumns(packageTable, result, panel2.areStaticImportsEnabled());
        TableCellEditor editor = result.getDefaultEditor(String.class);
        if (editor instanceof DefaultCellEditor) {
            ((DefaultCellEditor)editor).setClickCountToStart(1);
        }
        TableCellEditor beditor = result.getDefaultEditor(Boolean.class);
        beditor.addCellEditorListener(new CellEditorListener(){

            @Override
            public void editingStopped(ChangeEvent e) {
                if (panel2.areStaticImportsEnabled()) {
                    result.repaint();
                }
            }

            @Override
            public void editingCanceled(ChangeEvent e) {
            }
        });
        return result;
    }

    public static void resizeColumns(final PackageEntryTable packageTable, JBTable result, boolean areStaticImportsEnabled) {
        ColoredTableCellRenderer packageRenderer = new ColoredTableCellRenderer(){

            protected void customizeCellRenderer(JTable table, Object value2, boolean selected, boolean hasFocus, int row, int column) {
                PackageEntry entry = packageTable.getEntryAt(row);
                if (entry == PackageEntry.BLANK_LINE_ENTRY) {
                    this.append("<blank line>", SimpleTextAttributes.GRAYED_ATTRIBUTES);
                } else {
                    TextAttributes attributes = JavaHighlightingColors.KEYWORD.getDefaultAttributes();
                    this.append("import", SimpleTextAttributes.fromTextAttributes((TextAttributes)attributes));
                    if (entry.isStatic()) {
                        this.append(" ", SimpleTextAttributes.REGULAR_ATTRIBUTES);
                        this.append("static", SimpleTextAttributes.fromTextAttributes((TextAttributes)attributes));
                    }
                    this.append(" ", SimpleTextAttributes.REGULAR_ATTRIBUTES);
                    if (entry == PackageEntry.ALL_OTHER_IMPORTS_ENTRY || entry == PackageEntry.ALL_OTHER_STATIC_IMPORTS_ENTRY) {
                        this.append("all other imports", SimpleTextAttributes.REGULAR_ATTRIBUTES);
                    } else {
                        this.append(entry.getPackageName() + ".*", SimpleTextAttributes.REGULAR_ATTRIBUTES);
                    }
                }
            }
        };
        if (areStaticImportsEnabled) {
            ImportLayoutPanel.fixColumnWidthToHeader(result, 0);
            ImportLayoutPanel.fixColumnWidthToHeader(result, 2);
            result.getColumnModel().getColumn(1).setCellRenderer((TableCellRenderer)packageRenderer);
            result.getColumnModel().getColumn(0).setCellRenderer((TableCellRenderer)new BooleanTableCellRenderer());
            result.getColumnModel().getColumn(2).setCellRenderer((TableCellRenderer)new BooleanTableCellRenderer());
        } else {
            ImportLayoutPanel.fixColumnWidthToHeader(result, 1);
            result.getColumnModel().getColumn(0).setCellRenderer((TableCellRenderer)packageRenderer);
            result.getColumnModel().getColumn(1).setCellRenderer((TableCellRenderer)new BooleanTableCellRenderer());
        }
    }

    private static void fixColumnWidthToHeader(JBTable result, int columnIdx) {
        TableColumn column = result.getColumnModel().getColumn(columnIdx);
        int width = 15 + result.getTableHeader().getFontMetrics(result.getTableHeader().getFont()).stringWidth(result.getColumnName(columnIdx));
        column.setMinWidth(width);
        column.setMaxWidth(width);
    }

    public static void refreshTableModel(int selectedRow, JBTable table) {
        AbstractTableModel model = (AbstractTableModel)table.getModel();
        model.fireTableRowsInserted(selectedRow, selectedRow);
        table.setRowSelectionInterval(selectedRow, selectedRow);
        TableUtil.editCellAt((JTable)table, (int)selectedRow, (int)0);
        Component editorComp = table.getEditorComponent();
        if (editorComp != null) {
            IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus(editorComp, true));
        }
    }
}

