/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.groovy;

import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.builders.BuildRootIndex;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.BuildTargetLoader;
import org.jetbrains.jps.builders.BuildTargetRegistry;
import org.jetbrains.jps.builders.BuildTargetType;
import org.jetbrains.jps.builders.TargetOutputIndex;
import org.jetbrains.jps.builders.java.JavaModuleBuildTargetType;
import org.jetbrains.jps.builders.java.ResourceRootDescriptor;
import org.jetbrains.jps.builders.java.ResourcesTargetType;
import org.jetbrains.jps.builders.storage.BuildDataPaths;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.ModuleBuildTarget;
import org.jetbrains.jps.incremental.ResourcesTarget;
import org.jetbrains.jps.incremental.groovy.GroovyResourceRootDescriptor;
import org.jetbrains.jps.indices.IgnoredFileIndex;
import org.jetbrains.jps.indices.ModuleExcludeIndex;
import org.jetbrains.jps.model.JpsModel;
import org.jetbrains.jps.model.module.JpsModule;

public class CheckResourcesTarget
extends BuildTarget<GroovyResourceRootDescriptor> {
    @NotNull
    private final JpsModule myModule;
    public static final Type PRODUCTION = new Type(false);
    public static final Type TESTS = new Type(true);
    static final List<Type> TARGET_TYPES = Arrays.asList(PRODUCTION, TESTS);

    CheckResourcesTarget(@NotNull JpsModule module, Type targetType) {
        super((BuildTargetType)targetType);
        this.myModule = module;
    }

    public String getId() {
        return this.myModule.getName();
    }

    @Nullable
    public GroovyResourceRootDescriptor findRootDescriptor(String rootId, BuildRootIndex rootIndex) {
        List descriptors = rootIndex.getRootDescriptors(new File(rootId), Collections.singletonList((Type)this.getTargetType()), null);
        return (GroovyResourceRootDescriptor)((Object)ContainerUtil.getFirstItem((List)descriptors));
    }

    boolean isTests() {
        return ((Type)this.getTargetType()).myTests;
    }

    @NotNull
    public String getPresentableName() {
        return "Check Groovy Resources for '" + this.myModule.getName() + "' " + (this.isTests() ? "tests" : "production");
    }

    public Collection<BuildTarget<?>> computeDependencies(BuildTargetRegistry targetRegistry, TargetOutputIndex outputIndex) {
        ArrayList result = new ArrayList();
        ModuleBuildTarget compileTarget = new ModuleBuildTarget(this.myModule, JavaModuleBuildTargetType.getInstance((boolean)this.isTests()));
        result.add((BuildTarget<?>)compileTarget);
        for (BuildTarget dep : compileTarget.computeDependencies(targetRegistry, outputIndex)) {
            if (!(dep instanceof ModuleBuildTarget)) continue;
            result.add(new CheckResourcesTarget(((ModuleBuildTarget)dep).getModule(), ((ModuleBuildTarget)dep).isTests() ? TESTS : PRODUCTION));
        }
        return result;
    }

    @NotNull
    public List<GroovyResourceRootDescriptor> computeRootDescriptors(JpsModel model, ModuleExcludeIndex index, IgnoredFileIndex ignoredFileIndex, BuildDataPaths dataPaths) {
        ResourcesTarget target = new ResourcesTarget(this.myModule, ResourcesTargetType.getInstance((boolean)this.isTests()));
        List resources = target.computeRootDescriptors(model, index, ignoredFileIndex, dataPaths);
        return ContainerUtil.map((Collection)resources, descriptor -> new GroovyResourceRootDescriptor((ResourceRootDescriptor)descriptor, this));
    }

    @NotNull
    public Collection<File> getOutputRoots(CompileContext context) {
        return Collections.singletonList(this.getOutputRoot(context));
    }

    @NotNull
    File getOutputRoot(CompileContext context) {
        File commonRoot = new File(context.getProjectDescriptor().dataManager.getDataPaths().getDataStorageRoot(), "groovyResources");
        return new File(commonRoot, this.myModule.getName() + File.separator + this.getTargetType().getTypeId());
    }

    @NotNull
    public JpsModule getModule() {
        return this.myModule;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CheckResourcesTarget)) {
            return false;
        }
        CheckResourcesTarget target = (CheckResourcesTarget)((Object)o);
        if (!this.myModule.equals(target.myModule)) {
            return false;
        }
        return this.getTargetType().equals((Object)target.getTargetType());
    }

    public int hashCode() {
        return this.myModule.hashCode() + 31 * this.getTargetType().hashCode();
    }

    public static class Type
    extends BuildTargetType<CheckResourcesTarget> {
        private final boolean myTests;

        protected Type(boolean tests) {
            super("groovy-check-resources" + (tests ? "_tests" : ""), true);
            this.myTests = tests;
        }

        @NotNull
        public List<CheckResourcesTarget> computeAllTargets(@NotNull JpsModel model) {
            return ContainerUtil.map((Collection)model.getProject().getModules(), module -> new CheckResourcesTarget((JpsModule)module, this));
        }

        @NotNull
        public BuildTargetLoader<CheckResourcesTarget> createLoader(@NotNull JpsModel model) {
            final HashMap<String, JpsModule> modules = new HashMap<String, JpsModule>();
            for (JpsModule module : model.getProject().getModules()) {
                modules.put(module.getName(), module);
            }
            return new BuildTargetLoader<CheckResourcesTarget>(){

                @Nullable
                public CheckResourcesTarget createTarget(@NotNull String targetId) {
                    JpsModule module = (JpsModule)modules.get(targetId);
                    return module != null ? new CheckResourcesTarget(module, this) : null;
                }
            };
        }
    }
}

