/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.breakpoints;

import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.PositionManagerImpl;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.ui.breakpoints.Breakpoint;
import com.intellij.debugger.ui.breakpoints.BreakpointManager;
import com.intellij.debugger.ui.breakpoints.JavaLineBreakpointType;
import com.intellij.debugger.ui.breakpoints.LineBreakpoint;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointProperties;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.impl.breakpoints.XLineBreakpointImpl;
import java.util.Collections;
import java.util.List;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.java.debugger.breakpoints.properties.JavaBreakpointProperties;
import org.jetbrains.java.debugger.breakpoints.properties.JavaLineBreakpointProperties;
import org.jetbrains.kotlin.idea.debugger.KotlinDebuggerCoreBundle;
import org.jetbrains.kotlin.idea.debugger.KotlinPositionManager;
import org.jetbrains.kotlin.idea.debugger.breakpoints.ApplicabilityResult;
import org.jetbrains.kotlin.idea.debugger.breakpoints.BreakpointTypeUtilsKt;
import org.jetbrains.kotlin.idea.debugger.breakpoints.KotlinBreakpointType;
import org.jetbrains.kotlin.idea.debugger.breakpoints.KotlinLineBreakpoint;
import org.jetbrains.kotlin.idea.debugger.breakpoints.LineBreakpointExpressionVisitor;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtClassInitializer;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtVisitor;

public class KotlinLineBreakpointType
extends JavaLineBreakpointType
implements KotlinBreakpointType {
    public KotlinLineBreakpointType() {
        super("kotlin-line", KotlinDebuggerCoreBundle.message("line.breakpoint.tab.title", new Object[0]));
    }

    @NotNull
    public Breakpoint<JavaLineBreakpointProperties> createJavaBreakpoint(Project project, XBreakpoint<JavaLineBreakpointProperties> breakpoint2) {
        return new KotlinLineBreakpoint(project, (XBreakpoint<? extends XBreakpointProperties<?>>)breakpoint2);
    }

    public boolean matchesPosition(@NotNull LineBreakpoint<?> breakpoint2, @NotNull SourcePosition position) {
        JavaBreakpointProperties properties;
        if (breakpoint2 == null) {
            KotlinLineBreakpointType.$$$reportNull$$$0(0);
        }
        if (position == null) {
            KotlinLineBreakpointType.$$$reportNull$$$0(1);
        }
        if ((properties = KotlinLineBreakpointType.getProperties(breakpoint2)) == null || properties instanceof JavaLineBreakpointProperties) {
            if (position instanceof KotlinPositionManager.KotlinReentrantSourcePosition) {
                return false;
            }
            if (properties != null && ((JavaLineBreakpointProperties)properties).getLambdaOrdinal() == null) {
                return true;
            }
            PsiElement containingMethod = this.getContainingMethod(breakpoint2);
            if (containingMethod == null) {
                return false;
            }
            return KotlinLineBreakpointType.inTheMethod(position, containingMethod);
        }
        return true;
    }

    @Nullable
    public PsiElement getContainingMethod(@NotNull LineBreakpoint<?> breakpoint2) {
        Integer ordinal;
        KtFunction lambda2;
        SourcePosition position;
        if (breakpoint2 == null) {
            KotlinLineBreakpointType.$$$reportNull$$$0(2);
        }
        if ((position = breakpoint2.getSourcePosition()) == null) {
            return null;
        }
        JavaBreakpointProperties properties = KotlinLineBreakpointType.getProperties(breakpoint2);
        if (properties instanceof JavaLineBreakpointProperties && (lambda2 = KotlinLineBreakpointType.getLambdaByOrdinal(position, ordinal = ((JavaLineBreakpointProperties)properties).getLambdaOrdinal())) != null) {
            return lambda2;
        }
        return KotlinLineBreakpointType.getContainingMethod(position.getElementAt());
    }

    @Nullable
    private static JavaBreakpointProperties getProperties(@NotNull LineBreakpoint<?> breakpoint2) {
        XBreakpoint xBreakpoint;
        if (breakpoint2 == null) {
            KotlinLineBreakpointType.$$$reportNull$$$0(3);
        }
        return (xBreakpoint = breakpoint2.getXBreakpoint()) != null ? (JavaBreakpointProperties)xBreakpoint.getProperties() : null;
    }

    @Nullable
    private static KtFunction getLambdaByOrdinal(SourcePosition position, Integer ordinal) {
        List lambdas;
        if (ordinal != null && ordinal >= 0 && (lambdas = (List)ReadAction.compute(() -> {
            PsiElement targetElement = position.getElementAt();
            if (targetElement == null || !targetElement.isValid()) {
                return Collections.emptyList();
            }
            return BreakpointTypeUtilsKt.getLambdasAtLineIfAny(position);
        })).size() > ordinal) {
            return (KtFunction)lambdas.get(ordinal);
        }
        return null;
    }

    @Nullable
    public static PsiElement getContainingMethod(@Nullable PsiElement elem) {
        return PsiTreeUtil.getParentOfType((PsiElement)elem, (Class[])new Class[]{KtFunction.class, KtClassInitializer.class});
    }

    public static boolean inTheMethod(@NotNull SourcePosition pos, @NotNull PsiElement method) {
        PsiElement elem;
        if (pos == null) {
            KotlinLineBreakpointType.$$$reportNull$$$0(4);
        }
        if (method == null) {
            KotlinLineBreakpointType.$$$reportNull$$$0(5);
        }
        if ((elem = pos.getElementAt()) == null) {
            return false;
        }
        return Comparing.equal((Object)KotlinLineBreakpointType.getContainingMethod(elem), (Object)method);
    }

    public boolean canPutAt(@NotNull VirtualFile file, int line, @NotNull Project project) {
        if (file == null) {
            KotlinLineBreakpointType.$$$reportNull$$$0(6);
        }
        if (project == null) {
            KotlinLineBreakpointType.$$$reportNull$$$0(7);
        }
        return BreakpointTypeUtilsKt.isBreakpointApplicable(file, line, project, (Function1<? super PsiElement, ApplicabilityResult>)((Function1)element -> {
            LineBreakpointExpressionVisitor visitor;
            KtCallableDeclaration callable;
            if (element instanceof KtDestructuringDeclaration) {
                return ApplicabilityResult.MAYBE_YES;
            }
            PsiElement containingMethod = KotlinLineBreakpointType.getContainingMethod(element);
            if (containingMethod instanceof KtCallableDeclaration && BreakpointTypeUtilsKt.isInlineOnly(callable = (KtCallableDeclaration)containingMethod)) {
                return ApplicabilityResult.DEFINITELY_NO;
            }
            if (KotlinLineBreakpointType.isClosingBraceInMethod(element)) {
                return ApplicabilityResult.MAYBE_YES;
            }
            if (element instanceof KtElement && (visitor = LineBreakpointExpressionVisitor.of(file, line)) != null) {
                ApplicabilityResult result2 = (ApplicabilityResult)((KtElement)element).accept((KtVisitor)visitor, null);
                if (result2 == null) {
                    return ApplicabilityResult.UNKNOWN;
                }
                return result2;
            }
            return ApplicabilityResult.UNKNOWN;
        }));
    }

    private static boolean isClosingBraceInMethod(PsiElement element) {
        if (element instanceof LeafPsiElement && element.getNode().getElementType() == KtTokens.RBRACE) {
            PsiElement owner;
            PsiElement blockExpression = element.getParent();
            if (blockExpression instanceof KtFunctionLiteral) {
                return true;
            }
            if (blockExpression instanceof KtBlockExpression && ((owner = blockExpression.getParent()) instanceof KtFunction || owner instanceof KtClassInitializer)) {
                return true;
            }
        }
        return false;
    }

    @NotNull
    public List<JavaLineBreakpointType.JavaBreakpointVariant> computeVariants(@NotNull Project project, @NotNull XSourcePosition position) {
        if (project == null) {
            KotlinLineBreakpointType.$$$reportNull$$$0(8);
        }
        if (position == null) {
            KotlinLineBreakpointType.$$$reportNull$$$0(9);
        }
        List<JavaLineBreakpointType.JavaBreakpointVariant> list = BreakpointTypeUtilsKt.computeLineBreakpointVariants(project, position, this);
        if (list == null) {
            KotlinLineBreakpointType.$$$reportNull$$$0(10);
        }
        return list;
    }

    @Nullable
    public TextRange getHighlightRange(XLineBreakpoint<JavaLineBreakpointProperties> breakpoint2) {
        KtFunction lambda2;
        SourcePosition position;
        Breakpoint javaBreakpoint;
        Integer ordinal;
        JavaLineBreakpointProperties properties = (JavaLineBreakpointProperties)breakpoint2.getProperties();
        if (properties != null && (ordinal = properties.getLambdaOrdinal()) != null && (javaBreakpoint = BreakpointManager.getJavaBreakpoint(breakpoint2)) instanceof LineBreakpoint && (position = ((LineBreakpoint)javaBreakpoint).getSourcePosition()) != null && (lambda2 = KotlinLineBreakpointType.getLambdaByOrdinal(position, ordinal)) != null) {
            return lambda2.getTextRange();
        }
        return null;
    }

    @Nullable
    private static SourcePosition createLineSourcePosition(@NotNull XLineBreakpointImpl breakpoint2) {
        PsiManager psiManager;
        PsiFile psiFile;
        VirtualFile file;
        if (breakpoint2 == null) {
            KotlinLineBreakpointType.$$$reportNull$$$0(11);
        }
        if ((file = breakpoint2.getFile()) != null && (psiFile = (PsiFile)ReadAction.compute(() -> KotlinLineBreakpointType.lambda$createLineSourcePosition$2(psiManager = PsiManager.getInstance((Project)breakpoint2.getProject()), file))) != null) {
            return SourcePosition.createFromLine((PsiFile)psiFile, (int)breakpoint2.getLine());
        }
        return null;
    }

    @Nullable
    public XSourcePosition getSourcePosition(@NotNull XBreakpoint<JavaLineBreakpointProperties> breakpoint2) {
        JavaBreakpointProperties javaBreakpointProperties;
        if (breakpoint2 == null) {
            KotlinLineBreakpointType.$$$reportNull$$$0(12);
        }
        if ((javaBreakpointProperties = (JavaBreakpointProperties)breakpoint2.getProperties()) != null) {
            KtExpression bodyElement;
            KtFunction function;
            Integer ordinal = ((JavaLineBreakpointProperties)javaBreakpointProperties).getLambdaOrdinal();
            SourcePosition sourcePosition2 = KotlinLineBreakpointType.createLineSourcePosition((XLineBreakpointImpl)breakpoint2);
            if (sourcePosition2 != null && (function = KotlinLineBreakpointType.getLambdaByOrdinal(sourcePosition2, ordinal)) != null && (bodyElement = function.getBodyExpression()) != null) {
                SourcePosition linePosition = SourcePosition.createFromElement((PsiElement)bodyElement);
                return (XSourcePosition)ReadAction.compute(() -> {
                    if (linePosition != null) {
                        return DebuggerUtilsEx.toXSourcePosition((SourcePosition)new PositionManagerImpl.JavaSourcePosition(linePosition, ordinal.intValue()));
                    }
                    return null;
                });
            }
        }
        return super.getSourcePosition(breakpoint2);
    }

    private static /* synthetic */ PsiFile lambda$createLineSourcePosition$2(PsiManager psiManager, VirtualFile file) throws RuntimeException {
        return psiManager.findFile(file);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "breakpoint";
                break;
            }
            case 1: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pos";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/idea/debugger/breakpoints/KotlinLineBreakpointType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/idea/debugger/breakpoints/KotlinLineBreakpointType";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "computeVariants";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "matchesPosition";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getContainingMethod";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getProperties";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "inTheMethod";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "canPutAt";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "computeVariants";
                break;
            }
            case 10: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createLineSourcePosition";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getSourcePosition";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public class KotlinBreakpointVariant
    extends JavaLineBreakpointType.JavaBreakpointVariant {
        private final int lambdaCount;

        public KotlinBreakpointVariant(XSourcePosition position, int lambdaCount) {
            if (position == null) {
                KotlinBreakpointVariant.$$$reportNull$$$0(0);
            }
            super((JavaLineBreakpointType)KotlinLineBreakpointType.this, position);
            this.lambdaCount = lambdaCount;
        }

        @NotNull
        public String getText() {
            String string = KotlinDebuggerCoreBundle.message("line.and.lambda.breakpoint", this.lambdaCount);
            if (string == null) {
                KotlinBreakpointVariant.$$$reportNull$$$0(1);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "position";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/kotlin/idea/debugger/breakpoints/KotlinLineBreakpointType$KotlinBreakpointVariant";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/kotlin/idea/debugger/breakpoints/KotlinLineBreakpointType$KotlinBreakpointVariant";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public class LineKotlinBreakpointVariant
    extends JavaLineBreakpointType.LineJavaBreakpointVariant {
        public LineKotlinBreakpointVariant(@Nullable XSourcePosition position, PsiElement element, Integer lambdaOrdinal) {
            if (position == null) {
                LineKotlinBreakpointVariant.$$$reportNull$$$0(0);
            }
            super((JavaLineBreakpointType)KotlinLineBreakpointType.this, position, element, lambdaOrdinal);
        }

        @NotNull
        public String getText() {
            String string = KotlinDebuggerCoreBundle.message("line.breakpoint", new Object[0]);
            if (string == null) {
                LineKotlinBreakpointVariant.$$$reportNull$$$0(1);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "position";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/kotlin/idea/debugger/breakpoints/KotlinLineBreakpointType$LineKotlinBreakpointVariant";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/kotlin/idea/debugger/breakpoints/KotlinLineBreakpointType$LineKotlinBreakpointVariant";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

