/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.KtCodeFragment;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.diagnostics.DiagnosticSuppressor;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/DiagnosticSuppressorForDebugger;", "Lorg/jetbrains/kotlin/resolve/diagnostics/DiagnosticSuppressor;", "()V", "isSuppressed", "", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "kotlin.jvm-debugger.core"})
public final class DiagnosticSuppressorForDebugger
implements DiagnosticSuppressor {
    public boolean isSuppressed(@NotNull Diagnostic diagnostic) {
        Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
        PsiElement element = diagnostic.getPsiElement();
        PsiFile containingFile = element.getContainingFile();
        if (containingFile instanceof KtCodeFragment) {
            DiagnosticFactory diagnosticFactory = diagnostic.getFactory();
            return Intrinsics.areEqual((Object)diagnosticFactory, (Object)Errors.UNSAFE_CALL);
        }
        return false;
    }

    public boolean isSuppressed(@NotNull Diagnostic diagnostic, @Nullable BindingContext bindingContext) {
        Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
        return DiagnosticSuppressor.DefaultImpls.isSuppressed((DiagnosticSuppressor)this, (Diagnostic)diagnostic, (BindingContext)bindingContext);
    }
}

