/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.settingsRepository.git;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.util.BuildNumber;
import java.net.InetAddress;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.eclipse.jgit.lib.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.settingsRepository.IcsManagerKt;
import org.jetbrains.settingsRepository.git.CommitMessageFormatter;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u00060\u0004j\u0002`\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\f\b\u0002\u0010\b\u001a\u00060\u0004j\u0002`\u0005J\u001e\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\rH\u0016J\u0010\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\nH\u0016J\u0018\u0010\u0011\u001a\u00060\u0004j\u0002`\u00052\n\u0010\b\u001a\u00060\u0004j\u0002`\u0005H\u0016J\u0010\u0010\u0012\u001a\u00020\u0013*\u00060\u0004j\u0002`\u0005H\u0002\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/settingsRepository/git/IdeaCommitMessageFormatter;", "Lorg/jetbrains/settingsRepository/git/CommitMessageFormatter;", "()V", "appendCommitOwnerInfo", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "avoidAppInfoInstantiation", "", "builder", "mergeMessage", "", "refsToMerge", "", "Lorg/eclipse/jgit/lib/Ref;", "target", "message", "text", "prependMessage", "appendAppName", "", "intellij.settingsRepository"})
public final class IdeaCommitMessageFormatter
implements CommitMessageFormatter {
    @Override
    @NotNull
    public String message(@NotNull String text) {
        return IdeaCommitMessageFormatter.appendCommitOwnerInfo$default(this, false, null, 3, null).append(text).toString();
    }

    @Override
    @NotNull
    public StringBuilder prependMessage(@NotNull StringBuilder builder) {
        return IdeaCommitMessageFormatter.appendCommitOwnerInfo$default(this, false, builder, 1, null);
    }

    @Override
    @NotNull
    public String mergeMessage(@NotNull List<? extends Ref> refsToMerge, @NotNull Ref target) {
        return IdeaCommitMessageFormatter.appendCommitOwnerInfo$default(this, false, null, 3, null).append(CommitMessageFormatter.DefaultImpls.mergeMessage(this, refsToMerge, target)).toString();
    }

    @NotNull
    public final StringBuilder appendCommitOwnerInfo(boolean avoidAppInfoInstantiation, @NotNull StringBuilder builder) {
        if (avoidAppInfoInstantiation) {
            builder.append(ApplicationNamesInfo.getInstance().getProductName());
        } else {
            this.appendAppName(builder);
        }
        Application application = ApplicationManager.getApplication();
        if (application == null) {
            Intrinsics.throwNpe();
        }
        if (!application.isUnitTestMode() && IcsManagerKt.getIcsManager().getSettings().getIncludeHostIntoCommitMessage()) {
            builder.append(' ').append('<').append(System.getProperty("user.name", "unknown-user"));
            builder.append('@').append(InetAddress.getLocalHost().getHostName());
        }
        builder.append(' ');
        return builder;
    }

    public static /* synthetic */ StringBuilder appendCommitOwnerInfo$default(IdeaCommitMessageFormatter ideaCommitMessageFormatter, boolean bl, StringBuilder stringBuilder, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        if ((n & 2) != 0) {
            stringBuilder = new StringBuilder();
        }
        return ideaCommitMessageFormatter.appendCommitOwnerInfo(bl, stringBuilder);
    }

    private final void appendAppName(StringBuilder $this$appendAppName) {
        ApplicationInfoEx appInfo = ApplicationInfoEx.getInstanceEx();
        if (appInfo != null) {
            BuildNumber build = appInfo.getBuild();
            $this$appendAppName.append(build.getProductCode()).append('-');
            if (appInfo.getMajorVersion() != null && !appInfo.isEAP()) {
                $this$appendAppName.append(appInfo.getFullVersion());
            } else {
                $this$appendAppName.append(build.asStringWithoutProductCodeAndSnapshot());
            }
        }
    }
}

