/*
 * Decompiled with CFR 0.152.
 */
package com.google.archivepatcher.generator;

import java.io.UnsupportedEncodingException;
import java.util.Arrays;

public class MinimalZipEntry {
    private final int compressionMethod;
    private final long crc32OfUncompressedData;
    private final long compressedSize;
    private final long uncompressedSize;
    private final byte[] fileNameBytes;
    private final boolean generalPurposeFlagBit11;
    private final long fileOffsetOfLocalEntry;
    private long fileOffsetOfCompressedData = -1L;

    public MinimalZipEntry(int compressionMethod, long crc32OfUncompressedData, long compressedSize, long uncompressedSize, byte[] fileNameBytes, boolean generalPurposeFlagBit11, long fileOffsetOfLocalEntry) {
        this.compressionMethod = compressionMethod;
        this.crc32OfUncompressedData = crc32OfUncompressedData;
        this.compressedSize = compressedSize;
        this.uncompressedSize = uncompressedSize;
        this.fileNameBytes = fileNameBytes == null ? null : (byte[])fileNameBytes.clone();
        this.generalPurposeFlagBit11 = generalPurposeFlagBit11;
        this.fileOffsetOfLocalEntry = fileOffsetOfLocalEntry;
    }

    public void setFileOffsetOfCompressedData(long offset) {
        this.fileOffsetOfCompressedData = offset;
    }

    public int getCompressionMethod() {
        return this.compressionMethod;
    }

    public long getCrc32OfUncompressedData() {
        return this.crc32OfUncompressedData;
    }

    public long getCompressedSize() {
        return this.compressedSize;
    }

    public long getUncompressedSize() {
        return this.uncompressedSize;
    }

    public byte[] getFileNameBytes() {
        return this.fileNameBytes == null ? null : (byte[])this.fileNameBytes.clone();
    }

    public String getFileName() {
        String charsetName = this.generalPurposeFlagBit11 ? "UTF8" : "Cp437";
        try {
            return new String(this.fileNameBytes, charsetName);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("System doesn't support " + charsetName, e);
        }
    }

    public boolean getGeneralPurposeFlagBit11() {
        return this.generalPurposeFlagBit11;
    }

    public long getFileOffsetOfLocalEntry() {
        return this.fileOffsetOfLocalEntry;
    }

    public long getFileOffsetOfCompressedData() {
        return this.fileOffsetOfCompressedData;
    }

    public boolean isDeflateCompressed() {
        if (this.getCompressionMethod() != 8) {
            return false;
        }
        return this.getCompressedSize() != this.getUncompressedSize();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.compressedSize ^ this.compressedSize >>> 32);
        result = 31 * result + this.compressionMethod;
        result = 31 * result + (int)(this.crc32OfUncompressedData ^ this.crc32OfUncompressedData >>> 32);
        result = 31 * result + Arrays.hashCode(this.fileNameBytes);
        result = 31 * result + (int)(this.fileOffsetOfCompressedData ^ this.fileOffsetOfCompressedData >>> 32);
        result = 31 * result + (int)(this.fileOffsetOfLocalEntry ^ this.fileOffsetOfLocalEntry >>> 32);
        result = 31 * result + (this.generalPurposeFlagBit11 ? 1231 : 1237);
        result = 31 * result + (int)(this.uncompressedSize ^ this.uncompressedSize >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MinimalZipEntry other = (MinimalZipEntry)obj;
        if (this.compressedSize != other.compressedSize) {
            return false;
        }
        if (this.compressionMethod != other.compressionMethod) {
            return false;
        }
        if (this.crc32OfUncompressedData != other.crc32OfUncompressedData) {
            return false;
        }
        if (!Arrays.equals(this.fileNameBytes, other.fileNameBytes)) {
            return false;
        }
        if (this.fileOffsetOfCompressedData != other.fileOffsetOfCompressedData) {
            return false;
        }
        if (this.fileOffsetOfLocalEntry != other.fileOffsetOfLocalEntry) {
            return false;
        }
        if (this.generalPurposeFlagBit11 != other.generalPurposeFlagBit11) {
            return false;
        }
        return this.uncompressedSize == other.uncompressedSize;
    }
}

