/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.android.inspection;

import com.android.ide.common.gradle.model.IdeSourceProvider;
import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.util.ModuleExtensionsKt;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootModificationTracker;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.KotlinLanguage;
import org.jetbrains.kotlin.idea.inspections.AbstractKotlinInspection;
import org.jetbrains.kotlin.idea.quickfix.RenameIdentifierFix;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.resolve.jvm.checkers.DalvikIdentifierUtils;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0013B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\f0\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/android/inspection/IllegalIdentifierInspection;", "Lorg/jetbrains/kotlin/idea/inspections/AbstractKotlinInspection;", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "getIoFile", "Ljava/io/File;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "getJunitTestPaths", "", "module", "Lcom/intellij/openapi/module/Module;", "JunitPaths", "intellij.android.kotlin.idea"})
public final class IllegalIdentifierInspection
extends AbstractKotlinInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        return (PsiElementVisitor)new KtVisitorVoid(this, holder){
            final /* synthetic */ IllegalIdentifierInspection this$0;
            final /* synthetic */ ProblemsHolder $holder;

            public void visitElement(@NotNull PsiElement element) {
                ASTNode aSTNode = element.getNode();
                if (Intrinsics.areEqual((Object)(aSTNode != null ? aSTNode.getElementType() : null), (Object)KtTokens.IDENTIFIER) ^ true) {
                    return;
                }
                String text = element.getText();
                if (!StringsKt.startsWith$default((CharSequence)text, (char)'`', (boolean)false, (int)2, null) || !StringsKt.endsWith$default((CharSequence)text, (char)'`', (boolean)false, (int)2, null)) {
                    return;
                }
                String unquotedName = KtPsiUtil.unquoteIdentifier((String)text);
                CharSequence charSequence = unquotedName;
                boolean bl = false;
                if (charSequence.length() == 0) {
                    return;
                }
                if (!DalvikIdentifierUtils.isValidDalvikIdentifier((String)unquotedName) && this.checkAndroidFacet(element)) {
                    if (this.isInUnitTests(element) || this.isInBuildKtsFile(element)) {
                        return;
                    }
                    this.$holder.registerProblem(element, "Identifier not allowed in Android projects", ProblemHighlightType.GENERIC_ERROR, new LocalQuickFix[]{(LocalQuickFix)new RenameIdentifierFix()});
                }
            }

            private final boolean isInBuildKtsFile(PsiElement $this$isInBuildKtsFile) {
                Object object;
                return Intrinsics.areEqual((Object)$this$isInBuildKtsFile.getLanguage(), (Object)KotlinLanguage.INSTANCE) && ((object = $this$isInBuildKtsFile.getContainingFile()) != null && (object = object.getName()) != null ? StringsKt.endsWith$default((String)object, (String)"gradle.kts", (boolean)false, (int)2, null) : false);
            }

            private final boolean isInUnitTests(PsiElement $this$isInUnitTests) {
                block11: {
                    boolean bl;
                    block10: {
                        JunitPaths junitPaths;
                        File containingFile;
                        block13: {
                            JunitPaths it;
                            boolean bl2;
                            boolean bl3;
                            JunitPaths junitPaths22;
                            long currentGenerationId;
                            Module module;
                            block12: {
                                File file;
                                PsiFile psiFile = $this$isInUnitTests.getContainingFile();
                                if (psiFile != null && (psiFile = psiFile.getVirtualFile()) != null) {
                                    PsiFile psiFile2 = psiFile;
                                    boolean bl4 = false;
                                    boolean bl5 = false;
                                    PsiFile it2 = psiFile2;
                                    boolean junitPaths22 = false;
                                    file = IllegalIdentifierInspection.access$getIoFile(this.this$0, (VirtualFile)it2);
                                } else {
                                    file = null;
                                }
                                containingFile = file;
                                module = AndroidPsiUtils.getModuleSafely((PsiElement)$this$isInUnitTests);
                                if (module == null || containingFile == null) break block11;
                                currentGenerationId = ProjectRootModificationTracker.getInstance((Project)module.getProject()).getModificationCount();
                                junitPaths = (JunitPaths)module.getUserData((Key)JunitPaths.Companion);
                                if (junitPaths == null) break block12;
                                junitPaths22 = junitPaths;
                                bl3 = false;
                                bl2 = false;
                                it = junitPaths22;
                                boolean bl6 = false;
                                junitPaths = it.getGenerationId() == currentGenerationId ? junitPaths22 : null;
                                if (junitPaths != null) break block13;
                            }
                            junitPaths22 = new JunitPaths(IllegalIdentifierInspection.access$getJunitTestPaths(this.this$0, module), currentGenerationId);
                            bl3 = false;
                            bl2 = false;
                            it = junitPaths22;
                            boolean bl7 = false;
                            module.putUserData((Key)JunitPaths.Companion, (Object)it);
                            junitPaths = junitPaths22;
                        }
                        JunitPaths junitTestPaths = junitPaths;
                        Iterable $this$any$iv = junitTestPaths.getPaths();
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl = false;
                        } else {
                            for (T element$iv : $this$any$iv) {
                                File it = (File)element$iv;
                                boolean bl8 = false;
                                if (!FilesKt.startsWith((File)containingFile, (File)it)) continue;
                                bl = true;
                                break block10;
                            }
                            bl = false;
                        }
                    }
                    if (bl) {
                        return true;
                    }
                }
                return false;
            }

            private final boolean checkAndroidFacet(PsiElement element) {
                return ModuleExtensionsKt.getAndroidFacet((PsiElement)element) != null || ApplicationManager.getApplication().isUnitTestMode();
            }
            {
                this.this$0 = this$0;
                this.$holder = $captured_local_variable$1;
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    private final List<File> getJunitTestPaths(Module module) {
        void $this$flatMapTo$iv$iv;
        AndroidFacet androidFacet = AndroidFacet.getInstance((Module)module);
        if (androidFacet == null) {
            return CollectionsKt.emptyList();
        }
        AndroidFacet androidFacet2 = androidFacet;
        AndroidModuleModel androidModuleModel = AndroidModuleModel.get((AndroidFacet)androidFacet2);
        if (androidModuleModel == null) {
            return CollectionsKt.emptyList();
        }
        AndroidModuleModel androidModuleModel2 = androidModuleModel;
        Iterable $this$flatMap$iv = androidModuleModel2.getTestSourceProviders("_unit_test_");
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            IdeSourceProvider it = (IdeSourceProvider)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.getJavaDirectories();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final File getIoFile(VirtualFile virtualFile) {
        String path = virtualFile.getPath();
        if (StringUtil.endsWithChar((CharSequence)path, (char)':') && path.length() == 2 && SystemInfo.isWindows) {
            path = path + "/";
        }
        File file = new File(path);
        boolean bl = false;
        boolean bl2 = false;
        File it = file;
        boolean bl3 = false;
        return it.exists() ? file : null;
    }

    public static final /* synthetic */ File access$getIoFile(IllegalIdentifierInspection $this, VirtualFile virtualFile) {
        return $this.getIoFile(virtualFile);
    }

    public static final /* synthetic */ List access$getJunitTestPaths(IllegalIdentifierInspection $this, Module module) {
        return $this.getJunitTestPaths(module);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0007\b\u0002\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u001b\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/android/inspection/IllegalIdentifierInspection$JunitPaths;", "", "paths", "", "Ljava/io/File;", "generationId", "", "(Ljava/util/List;J)V", "getGenerationId", "()J", "getPaths", "()Ljava/util/List;", "Companion", "intellij.android.kotlin.idea"})
    private static final class JunitPaths {
        @NotNull
        private final List<File> paths;
        private final long generationId;
        public static final Companion Companion = new Companion(null);

        @NotNull
        public final List<File> getPaths() {
            return this.paths;
        }

        public final long getGenerationId() {
            return this.generationId;
        }

        public JunitPaths(@NotNull List<? extends File> paths, long generationId) {
            this.paths = paths;
            this.generationId = generationId;
        }

        @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lorg/jetbrains/kotlin/android/inspection/IllegalIdentifierInspection$JunitPaths$Companion;", "Lcom/intellij/openapi/util/Key;", "Lorg/jetbrains/kotlin/android/inspection/IllegalIdentifierInspection$JunitPaths;", "()V", "intellij.android.kotlin.idea"})
        public static final class Companion
        extends Key<JunitPaths> {
            private Companion() {
                super("AndroidModuleJunitPaths");
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

