/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.state;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.spellchecker.dictionary.EditableDictionary;
import com.intellij.spellchecker.dictionary.UserDictionary;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.Transient;
import com.intellij.util.xmlb.annotations.XCollection;
import gnu.trove.THashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

@Tag(value="dictionary")
public class DictionaryState
implements PersistentStateComponent<DictionaryState> {
    public static final String NAME_ATTRIBUTE = "name";
    @XCollection(style=XCollection.Style.v2, elementName="w", valueAttributeName="")
    public Set<String> words = new THashSet();
    @Attribute(value="name")
    public String name;
    @Transient
    private EditableDictionary dictionary;

    public DictionaryState() {
    }

    public DictionaryState(@NotNull EditableDictionary dictionary) {
        this.setDictionary(dictionary);
    }

    @Transient
    public void setDictionary(@NotNull EditableDictionary dictionary) {
        this.dictionary = dictionary;
        this.name = dictionary.getName();
        this.synchronizeWords();
    }

    @Transient
    public EditableDictionary getDictionary() {
        return this.dictionary;
    }

    public DictionaryState getState() {
        this.synchronizeWords();
        return this;
    }

    private void synchronizeWords() {
        if (this.dictionary != null) {
            this.words = new THashSet(this.dictionary.getWords());
        }
    }

    public void loadState(@NotNull DictionaryState state) {
        if (state != null && state.name != null) {
            this.name = state.name;
            this.words = state.words;
        }
        this.retrieveDictionary();
    }

    private void retrieveDictionary() {
        assert (this.name != null);
        this.dictionary = new UserDictionary(this.name);
        this.dictionary.addToDictionary(this.words);
    }

    public String toString() {
        return "DictionaryState{dictionary=" + this.dictionary + '}';
    }
}

