/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.quickfixes;

import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemDescriptorUtil;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.Anchor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.spellchecker.SpellCheckerManager;
import com.intellij.spellchecker.quickfixes.SpellCheckerQuickFix;
import com.intellij.spellchecker.util.SpellCheckerBundle;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class AcceptWordAsCorrect
implements SpellCheckerQuickFix {
    private String myWord;

    public AcceptWordAsCorrect(String word) {
        this.myWord = word;
    }

    public AcceptWordAsCorrect() {
    }

    @NotNull
    public String getName() {
        return this.myWord != null ? SpellCheckerBundle.message("add.0.to.dictionary", this.myWord) : SpellCheckerBundle.message("add.to.dictionary", new Object[0]);
    }

    @NotNull
    public String getFamilyName() {
        return SpellCheckerBundle.message("add.to.dictionary", new Object[0]);
    }

    @Override
    @NotNull
    public Anchor getPopupActionAnchor() {
        return Anchor.LAST;
    }

    public boolean startInWriteAction() {
        return false;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        SpellCheckerManager manager = SpellCheckerManager.getInstance(project);
        if (this.myWord != null) {
            manager.acceptWordAsCorrect(this.myWord, project);
        } else {
            manager.acceptWordAsCorrect(ProblemDescriptorUtil.extractHighlightedText((CommonProblemDescriptor)descriptor, (PsiElement)descriptor.getPsiElement()), project);
        }
    }

    public Icon getIcon(int flags) {
        return AllIcons.Actions.AddToDictionary;
    }
}

