/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.gradle.model.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.builders.BuildTargetLoader;
import org.jetbrains.jps.builders.ModuleBasedBuildTargetType;
import org.jetbrains.jps.gradle.model.JpsGradleExtensionService;
import org.jetbrains.jps.gradle.model.impl.GradleResourcesTarget;
import org.jetbrains.jps.model.JpsModel;
import org.jetbrains.jps.model.module.JpsModule;

public class GradleResourcesTargetType
extends ModuleBasedBuildTargetType<GradleResourcesTarget> {
    public static final GradleResourcesTargetType PRODUCTION = new GradleResourcesTargetType("gradle-resources-production", false);
    public static final GradleResourcesTargetType TEST = new GradleResourcesTargetType("gradle-resources-test", true);
    private final boolean myIsTests;

    private GradleResourcesTargetType(String typeId, boolean isTests) {
        super(typeId, true);
        this.myIsTests = isTests;
    }

    public boolean isTests() {
        return this.myIsTests;
    }

    @NotNull
    public List<GradleResourcesTarget> computeAllTargets(@NotNull JpsModel model) {
        ArrayList<GradleResourcesTarget> targets = new ArrayList<GradleResourcesTarget>();
        for (JpsModule module : model.getProject().getModules()) {
            if (JpsGradleExtensionService.getInstance().getExtension(module) == null) continue;
            targets.add(new GradleResourcesTarget(this, module));
        }
        return targets;
    }

    @NotNull
    public BuildTargetLoader<GradleResourcesTarget> createLoader(@NotNull JpsModel model) {
        final HashMap<String, JpsModule> modules = new HashMap<String, JpsModule>();
        for (JpsModule module : model.getProject().getModules()) {
            modules.put(module.getName(), module);
        }
        return new BuildTargetLoader<GradleResourcesTarget>(){

            @Nullable
            public GradleResourcesTarget createTarget(@NotNull String targetId) {
                JpsModule module = (JpsModule)modules.get(targetId);
                return module != null ? new GradleResourcesTarget(GradleResourcesTargetType.this, module) : null;
            }
        };
    }

    public static List<GradleResourcesTarget> buildModuleTargets(@NotNull JpsModule module, boolean includeTest) {
        ArrayList<GradleResourcesTarget> targets = new ArrayList<GradleResourcesTarget>();
        targets.add(new GradleResourcesTarget(PRODUCTION, module));
        if (includeTest) {
            targets.add(new GradleResourcesTarget(TEST, module));
        }
        return targets;
    }
}

