/*
 * Decompiled with CFR 0.152.
 */
package com.glavsoft.rfb.client;

import com.glavsoft.exceptions.TransportException;
import com.glavsoft.rfb.client.ClientMessageType;
import com.glavsoft.rfb.client.ClientToServerMessage;
import com.glavsoft.transport.Transport;

public class FramebufferUpdateRequestMessage
implements ClientToServerMessage {
    private final boolean incremental;
    private final int height;
    private final int width;
    private final int y;
    private final int x;

    public FramebufferUpdateRequestMessage(int x, int y, int width, int height, boolean incremental) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.incremental = incremental;
    }

    @Override
    public void send(Transport transport) throws TransportException {
        transport.writeByte(ClientMessageType.FRAMEBUFFER_UPDATE_REQUEST.id).writeByte(this.incremental ? 1 : 0).writeInt16(this.x).writeInt16(this.y).writeInt16(this.width).writeInt16(this.height).flush();
    }

    public String toString() {
        int n = this.x;
        int n2 = this.y;
        int n3 = this.width;
        int n4 = this.height;
        boolean bl = this.incremental;
        return new StringBuilder(122).append("FramebufferUpdateRequestMessage: [x: ").append(n).append(" y: ").append(n2).append(" width: ").append(n3).append(" height: ").append(n4).append(" incremental: ").append(bl).append("]").toString();
    }
}

