/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.actions;

import com.intellij.ide.scratch.RootType;
import com.intellij.ide.scratch.ScratchFileService;
import com.intellij.internal.statistic.connect.StatisticsResult;
import com.intellij.internal.statistic.eventLog.DeviceConfiguration;
import com.intellij.internal.statistic.eventLog.EventLogApplicationInfo;
import com.intellij.internal.statistic.eventLog.EventLogBuildType;
import com.intellij.internal.statistic.eventLog.EventLogConfiguration;
import com.intellij.internal.statistic.eventLog.EventLogInternalApplicationInfo;
import com.intellij.internal.statistic.eventLog.EventLogInternalRecorderConfig;
import com.intellij.internal.statistic.eventLog.EventLogRecorderConfig;
import com.intellij.internal.statistic.eventLog.EventLogResultDecorator;
import com.intellij.internal.statistic.eventLog.EventLogSettingsService;
import com.intellij.internal.statistic.eventLog.EventLogStatisticsService;
import com.intellij.internal.statistic.eventLog.EventLogUploadSettingsService;
import com.intellij.internal.statistic.eventLog.LogEventRecordRequest;
import com.intellij.internal.statistic.eventLog.LogEventSerializer;
import com.intellij.internal.statistic.eventLog.filters.LogEventCompositeFilter;
import com.intellij.internal.statistic.eventLog.filters.LogEventFilter;
import com.intellij.internal.statistic.eventLog.filters.LogEventSnapshotBuildFilter;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.AppUIExecutor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SendEventLogAction
extends AnAction {
    private static final String FUS_RECORDER = "FUS";

    public void actionPerformed(@NotNull AnActionEvent e) {
        final Project project = e.getProject();
        if (project == null) {
            return;
        }
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(project, "Send Feature Usage Event Log", false){

            public void run(@NotNull ProgressIndicator indicator) {
                boolean succeed;
                StatisticsResult result = this.send();
                StatisticsResult.ResultCode code = result.getCode();
                if ((code == StatisticsResult.ResultCode.SENT_WITH_ERRORS || code == StatisticsResult.ResultCode.SEND) && (succeed = SendEventLogAction.tryToOpenInScratch(project, result.getDescription()))) {
                    return;
                }
                ApplicationManager.getApplication().invokeLater(() -> Messages.showMultilineInputDialog((Project)project, (String)("Result: " + code), (String)"Statistics Result", (String)StringUtil.replace((String)result.getDescription(), (String)";", (String)"\n"), null, null), ModalityState.NON_MODAL, project.getDisposed());
            }

            private StatisticsResult send() {
                return EventLogStatisticsService.send((DeviceConfiguration)new DeviceConfiguration(EventLogConfiguration.INSTANCE.getDeviceId(), EventLogConfiguration.INSTANCE.getBucket()), (EventLogRecorderConfig)new EventLogInternalRecorderConfig(SendEventLogAction.FUS_RECORDER), (EventLogSettingsService)new EventLogTestSettingsService(), (EventLogResultDecorator)new EventLogTestResultDecorator());
            }
        });
    }

    private static boolean tryToOpenInScratch(@NotNull Project project, @NotNull String request) {
        String fileName = "fus-event-log.json";
        try {
            ThrowableComputable computable = () -> {
                Document document;
                ScratchFileService fileService = ScratchFileService.getInstance();
                VirtualFile file = fileService.findFile(RootType.findById((String)"scratches"), "fus-event-log.json", ScratchFileService.Option.create_new_always);
                fileService.getScratchesMapping().setMapping(file, (Object)Language.findLanguageByID((String)"JSON"));
                PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
                Document document2 = document = psiFile != null ? PsiDocumentManager.getInstance((Project)project).getDocument(psiFile) : null;
                if (document == null) {
                    return null;
                }
                document.insertString(document.getTextLength(), (CharSequence)request);
                PsiDocumentManager.getInstance((Project)project).commitDocument(document);
                return psiFile;
            };
            NavigatablePsiElement psiElement = (NavigatablePsiElement)WriteCommandAction.writeCommandAction((Project)project).withName("Creating JSON for event log upload results").withGlobalUndo().shouldRecordActionForActiveDocument(false).withUndoConfirmationPolicy(UndoConfirmationPolicy.REQUEST_CONFIRMATION).compute(computable);
            if (psiElement != null) {
                ((AppUIExecutor)AppUIExecutor.onUiThread().expireWith((Disposable)project)).submit(() -> psiElement.navigate(true));
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private static class EventLogTestResultDecorator
    implements EventLogResultDecorator {
        private final List<LogEventRecordRequest> mySucceed = new ArrayList<LogEventRecordRequest>();
        private final List<LogEventRecordRequest> myFailed = new ArrayList<LogEventRecordRequest>();

        private EventLogTestResultDecorator() {
        }

        public void onSucceed(@NotNull LogEventRecordRequest request, @NotNull String content, @NotNull String logPath) {
            this.mySucceed.add(request);
        }

        public void onFailed(@Nullable LogEventRecordRequest request, @Nullable String content) {
            if (request != null) {
                this.myFailed.add(request);
            } else {
                this.myFailed.add(new LogEventRecordRequest("INVALID", "INVALID", "INVALID", ContainerUtil.emptyList(), true));
            }
        }

        @NotNull
        public StatisticsResult onFinished() {
            int total = this.mySucceed.size() + this.myFailed.size();
            if (this.mySucceed.isEmpty() && this.myFailed.isEmpty()) {
                return new StatisticsResult(StatisticsResult.ResultCode.NOTHING_TO_SEND, "No files to upload.");
            }
            if (!this.myFailed.isEmpty()) {
                StringBuilder out = new StringBuilder("{\"total\":");
                out.append(total).append(", \"uploaded\":").append(this.mySucceed.size()).append(",");
                out.append("\"failed\":[");
                EventLogTestResultDecorator.append(out, this.myFailed);
                out.append("],\"succeed\":[");
                EventLogTestResultDecorator.append(out, this.mySucceed);
                out.append("]}");
                return new StatisticsResult(StatisticsResult.ResultCode.SENT_WITH_ERRORS, out.toString());
            }
            StringBuilder out = new StringBuilder("{\"total\":");
            out.append(total).append(", \"uploaded\":").append(this.mySucceed.size()).append(",");
            out.append("\"succeed\":[");
            EventLogTestResultDecorator.append(out, this.mySucceed);
            out.append("]}");
            return new StatisticsResult(StatisticsResult.ResultCode.SEND, out.toString());
        }

        private static void append(@NotNull StringBuilder out, @NotNull List<LogEventRecordRequest> requests) {
            for (LogEventRecordRequest request : requests) {
                out.append(LogEventSerializer.INSTANCE.toString(request)).append(",");
            }
        }
    }

    private static class EventLogTestApplication
    extends EventLogInternalApplicationInfo {
        private EventLogTestApplication() {
            super(SendEventLogAction.FUS_RECORDER, true);
        }

        public boolean isInternal() {
            return true;
        }
    }

    private static class EventLogTestSettingsService
    extends EventLogUploadSettingsService
    implements EventLogSettingsService {
        private EventLogTestSettingsService() {
            super(SendEventLogAction.FUS_RECORDER, (EventLogApplicationInfo)new EventLogTestApplication());
        }

        @NotNull
        public LogEventFilter getEventFilter(@NotNull LogEventFilter base, @NotNull EventLogBuildType type) {
            LogEventFilter filter2 = super.getEventFilter(base, type);
            if (filter2 instanceof LogEventCompositeFilter) {
                LogEventFilter[] withoutSnapshot = (LogEventFilter[])Arrays.stream(((LogEventCompositeFilter)filter2).getFilters()).filter(f -> f != LogEventSnapshotBuildFilter.INSTANCE).toArray(LogEventFilter[]::new);
                return new LogEventCompositeFilter(withoutSnapshot);
            }
            return filter2;
        }
    }
}

