/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.nj2k.conversions;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.java.stubs.index.JavaFullClassNameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.stubindex.KotlinFullClassNameIndex;
import org.jetbrains.kotlin.idea.stubindex.KotlinTopLevelFunctionFqnNameIndex;
import org.jetbrains.kotlin.idea.stubindex.KotlinTopLevelPropertyFqnNameIndex;
import org.jetbrains.kotlin.idea.stubindex.KotlinTopLevelTypeAliasFqNameIndex;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtTypeAlias;
import org.jetbrains.kotlin.resolve.ImportPath;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00070\u00132\u0006\u0010\u0010\u001a\u00020\u0011J\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0010\u001a\u00020\u0011J\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0010\u001a\u00020\u0011J\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0010\u001a\u00020\u0011J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010 \u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0010\u001a\u00020\u0011J&\u0010!\u001a\u0004\u0018\u00010\u001b2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u001b0#2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020%0#H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0013\u0010\u000b\u001a\u00070\f\u00a2\u0006\u0002\b\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lorg/jetbrains/kotlin/nj2k/conversions/JKResolver;", "", "project", "Lcom/intellij/openapi/project/Project;", "module", "Lcom/intellij/openapi/module/Module;", "contextElement", "Lcom/intellij/psi/PsiElement;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/module/Module;Lcom/intellij/psi/PsiElement;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "scope", "Lcom/intellij/psi/search/GlobalSearchScope;", "Lorg/jetbrains/annotations/NotNull;", "constructImportDirectiveWithContext", "Lorg/jetbrains/kotlin/psi/KtImportDirective;", "fqName", "Lorg/jetbrains/kotlin/name/FqName;", "multiResolveFqName", "", "resolveClass", "resolveDeclaration", "resolveField", "resolveFqName", "resolveFqNameOfJavaClassByIndex", "Lcom/intellij/psi/PsiClass;", "resolveFqNameOfKtClassByIndex", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "resolveFqNameOfKtFunctionByIndex", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "resolveFqNameOfKtPropertyByIndex", "Lorg/jetbrains/kotlin/psi/KtProperty;", "resolveMethod", "selectNearest", "classesPsi", "", "typeAliasesPsi", "Lorg/jetbrains/kotlin/psi/KtTypeAlias;", "kotlin.j2k.new"})
public final class JKResolver {
    private final GlobalSearchScope scope;
    @NotNull
    private final Project project;
    private final PsiElement contextElement;

    @Nullable
    public final PsiElement resolveDeclaration(@NotNull FqName fqName) {
        NavigatablePsiElement navigatablePsiElement;
        Intrinsics.checkNotNullParameter((Object)fqName, (String)"fqName");
        KtDeclaration ktDeclaration = this.resolveFqNameOfKtClassByIndex(fqName);
        NavigatablePsiElement navigatablePsiElement2 = ktDeclaration != null ? (NavigatablePsiElement)ktDeclaration : (NavigatablePsiElement)this.resolveFqNameOfJavaClassByIndex(fqName);
        if (navigatablePsiElement2 == null) {
            navigatablePsiElement2 = navigatablePsiElement = (NavigatablePsiElement)this.resolveFqNameOfKtFunctionByIndex(fqName);
        }
        if (navigatablePsiElement2 == null) {
            navigatablePsiElement = (NavigatablePsiElement)this.resolveFqNameOfKtPropertyByIndex(fqName);
        }
        return navigatablePsiElement != null ? (PsiElement)navigatablePsiElement : this.resolveFqName(fqName);
    }

    @Nullable
    public final PsiElement resolveClass(@NotNull FqName fqName) {
        Intrinsics.checkNotNullParameter((Object)fqName, (String)"fqName");
        KtDeclaration ktDeclaration = this.resolveFqNameOfKtClassByIndex(fqName);
        NavigatablePsiElement navigatablePsiElement = ktDeclaration != null ? (NavigatablePsiElement)ktDeclaration : (NavigatablePsiElement)this.resolveFqNameOfJavaClassByIndex(fqName);
        return navigatablePsiElement != null ? (PsiElement)navigatablePsiElement : this.resolveFqName(fqName);
    }

    @Nullable
    public final PsiElement resolveMethod(@NotNull FqName fqName) {
        Intrinsics.checkNotNullParameter((Object)fqName, (String)"fqName");
        KtNamedFunction ktNamedFunction = this.resolveFqNameOfKtFunctionByIndex(fqName);
        return ktNamedFunction != null ? (PsiElement)ktNamedFunction : this.resolveFqName(fqName);
    }

    @Nullable
    public final PsiElement resolveField(@NotNull FqName fqName) {
        Intrinsics.checkNotNullParameter((Object)fqName, (String)"fqName");
        KtProperty ktProperty = this.resolveFqNameOfKtPropertyByIndex(fqName);
        return ktProperty != null ? (PsiElement)ktProperty : this.resolveFqName(fqName);
    }

    private final KtDeclaration resolveFqNameOfKtClassByIndex(FqName fqName) {
        String string = fqName.asString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"fqName.asString()");
        String fqNameString = string;
        Collection collection = KotlinFullClassNameIndex.getInstance().get(fqNameString, this.project, this.scope);
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"KotlinFullClassNameIndex\u2026meString, project, scope]");
        Collection classesPsi = collection;
        Collection typeAliasesPsi = KotlinTopLevelTypeAliasFqNameIndex.Companion.getInstance().get(fqNameString, this.project, this.scope);
        return this.selectNearest(classesPsi, typeAliasesPsi);
    }

    private final PsiClass resolveFqNameOfJavaClassByIndex(FqName fqName) {
        Object v3;
        block1: {
            String string = fqName.asString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"fqName.asString()");
            String fqNameString = string;
            Collection collection = JavaFullClassNameIndex.getInstance().get(Integer.valueOf(fqNameString.hashCode()), this.project, this.scope);
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"JavaFullClassNameIndex.g\u2026shCode(), project, scope]");
            Iterable $this$firstOrNull$iv = collection;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                PsiClass it = (PsiClass)element$iv;
                boolean bl = false;
                PsiClass psiClass = it;
                Intrinsics.checkNotNullExpressionValue((Object)psiClass, (String)"it");
                if (!Intrinsics.areEqual((Object)psiClass.getQualifiedName(), (Object)fqNameString)) continue;
                v3 = element$iv;
                break block1;
            }
            v3 = null;
        }
        return v3;
    }

    private final KtNamedFunction resolveFqNameOfKtFunctionByIndex(FqName fqName) {
        Collection collection = KotlinTopLevelFunctionFqnNameIndex.getInstance().get(fqName.asString(), this.project, this.scope);
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"KotlinTopLevelFunctionFq\u2026String(), project, scope]");
        return (KtNamedFunction)CollectionsKt.firstOrNull((Iterable)collection);
    }

    private final KtProperty resolveFqNameOfKtPropertyByIndex(FqName fqName) {
        Collection collection = KotlinTopLevelPropertyFqnNameIndex.getInstance().get(fqName.asString(), this.project, this.scope);
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"KotlinTopLevelPropertyFq\u2026String(), project, scope]");
        return (KtProperty)CollectionsKt.firstOrNull((Iterable)collection);
    }

    private final PsiElement resolveFqName(FqName fqName) {
        PsiElement psiElement;
        block4: {
            if (fqName.isRoot()) {
                return null;
            }
            PsiElement $this$getChildOfType$iv = (PsiElement)this.constructImportDirectiveWithContext(fqName);
            boolean $i$f$getChildOfType = false;
            PsiReference[] psiReferenceArray = (PsiReference[])PsiTreeUtil.getChildOfType((PsiElement)$this$getChildOfType$iv, KtDotQualifiedExpression.class);
            if (psiReferenceArray != null && (psiReferenceArray = psiReferenceArray.getSelectorExpression()) != null && (psiReferenceArray = psiReferenceArray.getReferences()) != null) {
                PsiReference[] $this$firstNotNullResult$iv = psiReferenceArray;
                boolean $i$f$firstNotNullResult = false;
                for (PsiReference element$iv : $this$firstNotNullResult$iv) {
                    PsiReference p1 = element$iv;
                    boolean bl = false;
                    PsiElement result$iv = p1.resolve();
                    if (result$iv == null) continue;
                    psiElement = result$iv;
                    break block4;
                }
                psiElement = null;
            } else {
                psiElement = null;
            }
        }
        return psiElement;
    }

    private final KtImportDirective constructImportDirectiveWithContext(FqName fqName) {
        KtImportDirective importDirective = KtPsiFactoryKt.KtPsiFactory$default((PsiElement)this.contextElement, (boolean)false, (int)2, null).createImportDirective(new ImportPath(fqName, false, null, 4, null));
        KtFile ktFile = importDirective.getContainingKtFile();
        Intrinsics.checkNotNullExpressionValue((Object)ktFile, (String)"importDirective.containingKtFile");
        KtPsiFactoryKt.setAnalysisContext((KtFile)ktFile, (PsiElement)((PsiElement)this.contextElement.getContainingFile()));
        return importDirective;
    }

    private final KtDeclaration selectNearest(Collection<? extends KtDeclaration> classesPsi, Collection<KtTypeAlias> typeAliasesPsi) {
        return typeAliasesPsi.isEmpty() ? (KtDeclaration)CollectionsKt.firstOrNull((Iterable)classesPsi) : (classesPsi.isEmpty() ? (KtDeclaration)CollectionsKt.firstOrNull((Iterable)typeAliasesPsi) : (KtDeclaration)SequencesKt.minWithOrNull((Sequence)SequencesKt.plus((Sequence)CollectionsKt.asSequence((Iterable)classesPsi), (Sequence)CollectionsKt.asSequence((Iterable)typeAliasesPsi)), (Comparator)new Comparator<KtDeclaration>(this){
            final /* synthetic */ JKResolver this$0;

            public final int compare(KtDeclaration o1, KtDeclaration o2) {
                GlobalSearchScope globalSearchScope = JKResolver.access$getScope$p(this.this$0);
                KtDeclaration ktDeclaration = o1;
                Intrinsics.checkNotNullExpressionValue((Object)ktDeclaration, (String)"o1");
                PsiFile psiFile = ktDeclaration.getContainingFile();
                Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"o1.containingFile");
                VirtualFile virtualFile = psiFile.getVirtualFile();
                KtDeclaration ktDeclaration2 = o2;
                Intrinsics.checkNotNullExpressionValue((Object)ktDeclaration2, (String)"o2");
                PsiFile psiFile2 = ktDeclaration2.getContainingFile();
                Intrinsics.checkNotNullExpressionValue((Object)psiFile2, (String)"o2.containingFile");
                return globalSearchScope.compare(virtualFile, psiFile2.getVirtualFile());
            }
            {
                this.this$0 = jKResolver;
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<PsiElement> multiResolveFqName(@NotNull FqName fqName) {
        Object object;
        boolean bl;
        KtDotQualifiedExpression ktDotQualifiedExpression;
        Intrinsics.checkNotNullParameter((Object)fqName, (String)"fqName");
        PsiElement $this$getChildOfType$iv = (PsiElement)this.constructImportDirectiveWithContext(fqName);
        boolean $i$f$getChildOfType = false;
        KtDotQualifiedExpression ktDotQualifiedExpression2 = (KtDotQualifiedExpression)PsiTreeUtil.getChildOfType((PsiElement)$this$getChildOfType$iv, KtDotQualifiedExpression.class);
        if (ktDotQualifiedExpression2 != null && (ktDotQualifiedExpression2 = ktDotQualifiedExpression2.getSelectorExpression()) != null) {
            void $this$flatMapTo$iv$iv;
            void $this$flatMap$iv;
            void $this$filterIsInstanceTo$iv$iv;
            ktDotQualifiedExpression = ktDotQualifiedExpression2;
            bl = false;
            boolean bl2 = false;
            KtDotQualifiedExpression selector = ktDotQualifiedExpression;
            boolean bl3 = false;
            PsiReference[] psiReferenceArray = selector.getReferences();
            Intrinsics.checkNotNullExpressionValue((Object)psiReferenceArray, (String)"selector.references");
            Object $this$filterIsInstance$iv = psiReferenceArray;
            boolean $i$f$filterIsInstance = false;
            PsiReference[] psiReferenceArray2 = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (void element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof PsiPolyVariantReference)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filterIsInstance$iv = (List)destination$iv$iv;
            boolean $i$f$flatMap = false;
            $this$filterIsInstanceTo$iv$iv = $this$flatMap$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                void $this$mapNotNullTo$iv$iv;
                void $this$mapNotNull$iv;
                PsiPolyVariantReference polyVariantReference = (PsiPolyVariantReference)element$iv$iv;
                boolean bl4 = false;
                Intrinsics.checkNotNullExpressionValue((Object)polyVariantReference.multiResolve(false), (String)"polyVariantReference\n   \u2026     .multiResolve(false)");
                boolean $i$f$mapNotNull = false;
                void var18_21 = $this$mapNotNull$iv;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                void var23_26 = $this$forEach$iv$iv$iv;
                int n = ((void)var23_26).length;
                for (int j = 0; j < n; ++j) {
                    PsiElement psiElement;
                    void element$iv$iv$iv;
                    void element$iv$iv2 = element$iv$iv$iv = var23_26[j];
                    boolean bl5 = false;
                    void it = element$iv$iv2;
                    boolean bl6 = false;
                    void v2 = it;
                    Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"it");
                    if (v2.getElement() == null) continue;
                    boolean bl7 = false;
                    boolean bl8 = false;
                    PsiElement it$iv$iv = psiElement;
                    boolean bl9 = false;
                    destination$iv$iv2.add(it$iv$iv);
                }
                Iterable list$iv$iv = (List)destination$iv$iv2;
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            object = (List)destination$iv$iv;
        } else {
            object = null;
        }
        ktDotQualifiedExpression = object;
        bl = false;
        Object object2 = ktDotQualifiedExpression;
        if (object2 == null) {
            object2 = CollectionsKt.emptyList();
        }
        return object2;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    /*
     * WARNING - void declaration
     */
    public JKResolver(@NotNull Project project, @Nullable Module module, @NotNull PsiElement contextElement) {
        Module module2;
        block3: {
            block2: {
                void it;
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)contextElement, (String)"contextElement");
                this.project = project;
                this.contextElement = contextElement;
                JKResolver jKResolver = this;
                module2 = module;
                if (module2 == null) break block2;
                Module module3 = module2;
                boolean bl = false;
                boolean bl2 = false;
                Module module4 = module3;
                JKResolver jKResolver2 = jKResolver;
                boolean bl3 = false;
                GlobalSearchScope globalSearchScope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)it);
                jKResolver = jKResolver2;
                module2 = globalSearchScope;
                if (module2 != null) break block3;
            }
            module2 = GlobalSearchScope.allScope((Project)this.project);
        }
        Intrinsics.checkNotNullExpressionValue((Object)module2, (String)"module?.let {\n        Gl\u2026chScope.allScope(project)");
        jKResolver.scope = module2;
    }

    public static final /* synthetic */ GlobalSearchScope access$getScope$p(JKResolver $this) {
        return $this.scope;
    }
}

